/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.Debug3dProvider;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.polygon.ConstrainedDelaunayTriangulator;

public class PolygonUtil {
    private PolygonUtil() {
        throw new AssertionError("Don't instantiate me!", null);
    }

    public static List<Polygon> concaveToConvex(Polygon incoming) {
        Geometry triangles;
        boolean cw;
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        if (incoming == null) {
            return result;
        }
        if (incoming.vertices.size() < 3) {
            return result;
        }
        Polygon concave = incoming;
        Vector3d normalOfPlane = incoming.plane.getNormal();
        boolean reorent = normalOfPlane.z < 0.99999999999;
        Transform orentationInv = null;
        boolean debug = false;
        Vector3d normal = concave.plane.getNormal().clone();
        if (reorent) {
            double degreesToRotate = Math.toDegrees(Math.atan2(normalOfPlane.x, normalOfPlane.z));
            Transform orentation = new Transform().roty(degreesToRotate);
            Polygon tmp = incoming.transformed(orentation);
            Vector3d tmpnorm = tmp.plane.getNormal();
            double degreesToRotate2 = 90.0 + Math.toDegrees(Math.atan2(tmpnorm.z, tmpnorm.y));
            Transform orentation2 = orentation.rotx(degreesToRotate2);
            if (debug) {
                Debug3dProvider.clearScreen();
                Debug3dProvider.addObject(incoming);
            }
            concave = incoming.transformed(orentation2);
            orentationInv = orentation2.inverse();
            if (concave.plane.getNormal().z < 0.0) {
                Transform orentation3 = orentation2.rotx(180);
                concave = incoming.transformed(orentation3);
                orentationInv = orentation3.inverse();
            }
            Polygon transformed = concave.transformed(orentationInv);
            PolygonUtil.checkForValidPolyOrentation(normal, transformed);
        }
        boolean bl = cw = !Extrude.isCCW(concave);
        if (cw) {
            concave = Extrude.toCCW(concave);
        }
        if (debug) {
            Debug3dProvider.clearScreen();
            Debug3dProvider.addObject(concave);
        }
        double zplane = concave.vertices.get((int)0).pos.z;
        try {
            triangles = PolygonUtil.makeTriangles(concave, cw);
        }
        catch (IllegalStateException ex) {
            List<Vector3d> points = concave.getPoints();
            ArrayList<Vector3d> r = new ArrayList<Vector3d>(points);
            Collections.reverse(r);
            concave = Polygon.fromPoints(r);
            triangles = PolygonUtil.makeTriangles(concave, cw);
        }
        ArrayList<Vertex> triPoints = new ArrayList<Vertex>();
        for (int i = 0; i < triangles.getNumGeometries(); ++i) {
            Geometry tri = triangles.getGeometryN(i);
            Coordinate[] coords = tri.getCoordinates();
            int counter = 0;
            if (coords.length != 4) {
                throw new RuntimeException("Failed to triangulate");
            }
            for (int j = 0; j < 3; ++j) {
                Coordinate tp = coords[j];
                Vector3d pos = new Vector3d(tp.getX(), tp.getY(), zplane);
                triPoints.add(new Vertex(pos, normal));
                if (counter == 2) {
                    boolean b;
                    if (!cw) {
                        Collections.reverse(triPoints);
                    }
                    Polygon poly = new Polygon(triPoints, concave.getStorage(), true);
                    poly.plane.setNormal(concave.plane.getNormal());
                    boolean bl2 = b = !Extrude.isCCW(poly);
                    if (cw != b) {
                        Collections.reverse(triPoints);
                        poly = new Polygon(triPoints, concave.getStorage(), true);
                        boolean bl3 = b = !Extrude.isCCW(poly);
                        if (cw != b) {
                            // empty if block
                        }
                    }
                    if (debug) {
                        Debug3dProvider.addObject(poly);
                    }
                    if (reorent) {
                        poly = poly.transform(orentationInv);
                        poly = PolygonUtil.checkForValidPolyOrentation(normal, poly);
                    }
                    poly.setColor(incoming.getColor());
                    result.add(poly);
                    counter = 0;
                    triPoints = new ArrayList();
                    continue;
                }
                ++counter;
            }
        }
        return result;
    }

    private static Polygon checkForValidPolyOrentation(Vector3d normal, Polygon poly) {
        double d;
        Vector3d normal2 = poly.plane.getNormal();
        Vector3d minus = normal.minus(normal2);
        double length = minus.length();
        if (length > (d = 0.001) * 10.0 && length < 2.0 - d) {
            List<Vector3d> points = poly.getPoints();
            ArrayList<Vector3d> r = new ArrayList<Vector3d>(points);
            Collections.reverse(r);
            Polygon fromPoints = Polygon.fromPoints(r);
            double l = normal.minus(fromPoints.plane.getNormal()).length();
            if (!(l > d * 10.0) || !(l < 2.0 - d)) {
                poly = fromPoints;
            }
        }
        return poly;
    }

    private static Geometry makeTriangles(Polygon concave, boolean cw) {
        Polygon toTri = concave;
        Coordinate[] coordinates = new Coordinate[toTri.vertices.size() + 1];
        for (int i = 0; i < toTri.vertices.size(); ++i) {
            Vector3d v = toTri.vertices.get((int)i).pos;
            coordinates[i] = new Coordinate(v.x, v.y, v.z);
        }
        Vector3d v = toTri.vertices.get((int)0).pos;
        coordinates[toTri.vertices.size()] = new Coordinate(v.x, v.y, v.z);
        org.locationtech.jts.geom.Polygon geom = new GeometryFactory().createPolygon(coordinates);
        Geometry triangles = ConstrainedDelaunayTriangulator.triangulate((Geometry)geom);
        return triangles;
    }

    public static Polygon pruneDuplicatePoints(Polygon incoming) {
        ArrayList<Vertex> newPoints = new ArrayList<Vertex>();
        for (int i = 0; i < incoming.vertices.size(); ++i) {
            Vertex v = incoming.vertices.get(i);
            boolean duplicate = false;
            for (Vertex vx : newPoints) {
                if (!vx.pos.test((Object)v.pos, 1.0E-4)) continue;
                duplicate = true;
            }
            if (duplicate) continue;
            newPoints.add(v);
        }
        if (newPoints.size() < 3) {
            return null;
        }
        return new Polygon(newPoints);
    }
}

