/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.scene.paint.Color;

public class PropertyStorage {
    private final Map<String, Object> map = new HashMap<String, Object>();
    private static final Color[] colors = new Color[]{Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.WHITE, Color.BLACK, Color.GRAY, Color.ORANGE};

    public void set(String key, Object property) {
        this.map.put(key, property);
    }

    public <T> Optional<T> getValue(String key) {
        Object value = this.map.get(key);
        try {
            return Optional.ofNullable(value);
        }
        catch (ClassCastException ex) {
            return Optional.empty();
        }
    }

    public void delete(String key) {
        this.map.remove(key);
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public void syncProperties(PropertyStorage dying) {
        for (String o : dying.map.keySet()) {
            HashSet property = dying.map.get(o);
            if (HashSet.class.isInstance(property)) {
                HashSet clonedSet = new HashSet();
                clonedSet.addAll(property);
                property = clonedSet;
            }
            this.set(o, property);
        }
    }
}

