
/**
 * STL.java
 *
 * Copyright 2014-2014 Michael Hoffer info@michaelhoffer.de. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY Michael Hoffer info@michaelhoffer.de "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Michael Hoffer info@michaelhoffer.de OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of Michael Hoffer info@michaelhoffer.de.
 */ 

package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.ext.imagej.STLLoader;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.vecmath.Point3f;

// TODO: Auto-generated Javadoc
/**
 * Loads a CSG from stl.
 * 
 * @author Michael Hoffer &lt;info@michaelhoffer.de&gt;
 */
public class STL {
	
	/**
	 * Loads a CSG from stl.
	 *
	 * @param path file path
	 * @return CSG
	 * @throws IOException if loading failed
	 * @throws URISyntaxException the URI syntax exception
	 */
    public static CSG file(URL path) throws IOException, URISyntaxException {
    	final URI uri =path.toURI();
    	Map<String, String> env = new HashMap<>(); 
    	env.put("create", "true");
    	FileSystem zipfs = FileSystems.newFileSystem(uri, env);
    	Path myFolderPath = Paths.get(uri);
        return file(myFolderPath);
    }

	/**
	 * Loads a CSG from stl.
	 * 
	 * @param path file path
	 * @return CSG
	 * @throws IOException if loading failed
	 */
	public static CSG file(Path path) throws IOException {
		STLLoader loader = new STLLoader();

		List<Polygon> polygons = new ArrayList<>();
		List<Vector3d> vertices = new ArrayList<>();
		for (Vector3d p : loader.parse(path.toFile())) {
			vertices.add(p);
			if (vertices.size() == 3) {
				try {
					polygons.add(Polygon.fromPointsAllowDegenerate(vertices));
				} catch (RuntimeException ex) {
					//ex.printStackTrace();
					System.err.println("Pruning polygon loading STL::file");
				}
				vertices = new ArrayList<>();
			}
		}

		return CSG.fromPolygons(new PropertyStorage(), polygons);
	}
}
