/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import com.aparapi.Kernel;
import com.aparapi.Range;
import com.aparapi.device.Device;
import com.neuronrobotics.interaction.CadInteractionEvent;
import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.CSGtoJavafx;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.Debug3dProvider;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.ICSGProgress;
import eu.mihosoft.vrl.v3d.IDebug3dProvider;
import eu.mihosoft.vrl.v3d.IuserAPI;
import eu.mihosoft.vrl.v3d.MeshContainer;
import eu.mihosoft.vrl.v3d.Modifier;
import eu.mihosoft.vrl.v3d.Node;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.PrepForManufacturing;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.TextExtrude;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.WeightFunction;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonUtil;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import eu.mihosoft.vrl.v3d.parametrics.CSGDatabase;
import eu.mihosoft.vrl.v3d.parametrics.IParametric;
import eu.mihosoft.vrl.v3d.parametrics.IRegenerate;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import eu.mihosoft.vrl.v3d.parametrics.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.MeshView;
import javafx.scene.text.Font;
import javafx.scene.transform.Affine;
import javax.vecmath.Tuple3d;

public class CSG
implements IuserAPI {
    private static IDebug3dProvider providerOf3d = null;
    private static int numFacesInOffset = 15;
    private List<Polygon> polygons;
    private static OptType defaultOptType = OptType.CSG_BOUND;
    private OptType optType = null;
    private PropertyStorage str;
    private PropertyStorage assembly;
    private MeshView current;
    private static Color defaultcolor = Color.web((String)"#007956");
    private Color color = CSG.getDefaultColor();
    private Affine manipulator;
    private Bounds bounds;
    public static final int INDEX_OF_PARAMETRIC_DEFAULT = 0;
    public static final int INDEX_OF_PARAMETRIC_LOWER = 1;
    public static final int INDEX_OF_PARAMETRIC_UPPER = 2;
    private ArrayList<String> groovyFileLines = new ArrayList();
    private PrepForManufacturing manufactuing = null;
    private HashMap<String, IParametric> mapOfparametrics = null;
    private IRegenerate regenerate = null;
    private boolean markForRegeneration = false;
    private String name = "";
    private ArrayList<Transform> slicePlanes = null;
    private ArrayList<String> exportFormats = null;
    private ArrayList<Transform> datumReferences = null;
    private boolean triangulated;
    private static boolean needsDegeneratesPruned = false;
    private static boolean useStackTraces = true;
    private static boolean preventNonManifoldTriangles = false;
    private static boolean useGPU = false;
    private static ICSGProgress progressMoniter = new ICSGProgress(){

        @Override
        public void progressUpdate(int currentIndex, int finalIndex, String type, CSG intermediateShape) {
            System.err.println(type + "  cur:" + currentIndex + " of " + finalIndex);
        }
    };

    public CSG() {
        this.setStorage(new PropertyStorage());
        if (useStackTraces) {
            this.addStackTrace(new Exception());
        }
    }

    public CSG addDatumReference(Transform t) {
        if (this.getDatumReferences() == null) {
            this.setDatumReferences(new ArrayList<Transform>());
        }
        this.getDatumReferences().add(t);
        return this;
    }

    public CSG prepForManufacturing() {
        if (this.getManufacturing() == null) {
            return this;
        }
        CSG ret = this.getManufacturing().prep(this);
        if (ret == null) {
            return null;
        }
        ret.setName(this.getName());
        ret.color = this.color;
        ret.slicePlanes = this.slicePlanes;
        ret.mapOfparametrics = this.mapOfparametrics;
        ret.exportFormats = this.exportFormats;
        return ret;
    }

    public Color getColor() {
        return this.color;
    }

    public CSG setColor(Color color) {
        this.color = color;
        for (Polygon p : this.polygons) {
            p.setColor(color);
        }
        return this;
    }

    public void setMeshColor(Color color) {
        if (this.current != null) {
            PhongMaterial m = new PhongMaterial(color);
            this.current.setMaterial((Material)m);
        }
    }

    public CSG setTemporaryColor(Color color) {
        if (this.current != null) {
            PhongMaterial m = new PhongMaterial(color);
            this.current.setMaterial((Material)m);
        }
        return this;
    }

    public CSG setManipulator(Affine manipulator) {
        if (manipulator == null) {
            return this;
        }
        Affine old = manipulator;
        this.manipulator = manipulator;
        if (this.current != null) {
            this.current.getTransforms().clear();
            this.current.getTransforms().add((Object)manipulator);
        }
        return this;
    }

    public MeshView getMesh() {
        if (this.current != null) {
            return this.current;
        }
        this.current = this.newMesh();
        return this.current;
    }

    public MeshView newMesh() {
        boolean hasAssembly;
        MeshContainer meshContainer = this.toJavaFXMesh(null);
        MeshView current = meshContainer.getAsMeshViews().get(0);
        PhongMaterial m = new PhongMaterial(this.getColor());
        current.setMaterial((Material)m);
        boolean hasManipulator = this.getManipulator() != null;
        boolean bl = hasAssembly = this.getAssemblyStorage().getValue("AssembleAffine") != Optional.empty();
        if (hasManipulator || hasAssembly) {
            current.getTransforms().clear();
        }
        if (hasManipulator) {
            current.getTransforms().add((Object)this.getManipulator());
        }
        if (hasAssembly) {
            current.getTransforms().add((Object)((Affine)this.getAssemblyStorage().getValue("AssembleAffine").get()));
        }
        current.setCullFace(CullFace.NONE);
        if (this.isWireFrame()) {
            current.setDrawMode(DrawMode.LINE);
        } else {
            current.setDrawMode(DrawMode.FILL);
        }
        return current;
    }

    public CSG toZMin(CSG target) {
        return this.transformed(new Transform().translateZ(-target.getBounds().getMin().z));
    }

    public CSG toZMax(CSG target) {
        return this.transformed(new Transform().translateZ(-target.getBounds().getMax().z));
    }

    public CSG toXMin(CSG target) {
        return this.transformed(new Transform().translateX(-target.getBounds().getMin().x));
    }

    public CSG toXMax(CSG target) {
        return this.transformed(new Transform().translateX(-target.getBounds().getMax().x));
    }

    public CSG toYMin(CSG target) {
        return this.transformed(new Transform().translateY(-target.getBounds().getMin().y));
    }

    public CSG toYMax(CSG target) {
        return this.transformed(new Transform().translateY(-target.getBounds().getMax().y));
    }

    public CSG toZMin() {
        return this.toZMin(this);
    }

    public CSG toZMax() {
        return this.toZMax(this);
    }

    public CSG toXMin() {
        return this.toXMin(this);
    }

    public CSG toXMax() {
        return this.toXMax(this);
    }

    public CSG toYMin() {
        return this.toYMin(this);
    }

    public CSG toYMax() {
        return this.toYMax(this);
    }

    public CSG move(Number x, Number y, Number z) {
        return this.transformed(new Transform().translate(x.doubleValue(), y.doubleValue(), z.doubleValue()));
    }

    public CSG move(Vertex v) {
        return this.transformed(new Transform().translate(v.getX(), v.getY(), v.getZ()));
    }

    public CSG move(Vector3d v) {
        return this.transformed(new Transform().translate(v.x, v.y, v.z));
    }

    public CSG move(Number[] posVector) {
        return this.move(posVector[0], posVector[1], posVector[2]);
    }

    public CSG movey(Number howFarToMove) {
        return this.transformed(Transform.unity().translateY(howFarToMove.doubleValue()));
    }

    public CSG movez(Number howFarToMove) {
        return this.transformed(Transform.unity().translateZ(howFarToMove.doubleValue()));
    }

    public CSG movex(Number howFarToMove) {
        return this.transformed(Transform.unity().translateX(howFarToMove.doubleValue()));
    }

    public CSG moveToCenterX() {
        return this.movex(-this.getCenterX());
    }

    public CSG moveToCenterY() {
        return this.movey(-this.getCenterY());
    }

    public CSG moveToCenterZ() {
        return this.movez(-this.getCenterZ());
    }

    public CSG moveToCenter() {
        return this.movex(-this.getCenterX()).movey(-this.getCenterY()).movez(-this.getCenterZ());
    }

    public ArrayList<CSG> move(ArrayList<Transform> p) {
        ArrayList<CSG> bits = new ArrayList<CSG>();
        for (Transform t : p) {
            bits.add(this.clone());
        }
        return CSG.move(bits, p);
    }

    public static ArrayList<CSG> move(ArrayList<CSG> slice, ArrayList<Transform> p) {
        ArrayList<CSG> s = new ArrayList<CSG>();
        for (int i = 0; i < slice.size() && i < p.size(); ++i) {
            s.add(slice.get(i).transformed(p.get(i)));
        }
        return s;
    }

    public CSG mirrory() {
        return this.scaley(-1);
    }

    public CSG mirrorz() {
        return this.scalez(-1);
    }

    public CSG mirrorx() {
        return this.scalex(-1);
    }

    public CSG rot(Number x, Number y, Number z) {
        return this.rotx(x.doubleValue()).roty(y.doubleValue()).rotz(z.doubleValue());
    }

    public CSG rot(Number[] posVector) {
        return this.rot(posVector[0], posVector[1], posVector[2]);
    }

    public CSG rotz(Number degreesToRotate) {
        return this.transformed(new Transform().rotZ(degreesToRotate.doubleValue()));
    }

    public CSG roty(Number degreesToRotate) {
        return this.transformed(new Transform().rotY(degreesToRotate.doubleValue()));
    }

    public CSG rotx(Number degreesToRotate) {
        return this.transformed(new Transform().rotX(degreesToRotate.doubleValue()));
    }

    public CSG scalez(Number scaleValue) {
        return this.transformed(new Transform().scaleZ(scaleValue.doubleValue()));
    }

    public CSG scaley(Number scaleValue) {
        return this.transformed(new Transform().scaleY(scaleValue.doubleValue()));
    }

    public CSG scalex(Number scaleValue) {
        return this.transformed(new Transform().scaleX(scaleValue.doubleValue()));
    }

    public CSG scaleToMeasurmentZ(Number measurment) {
        Double scaleValue = measurment.doubleValue() / this.getTotalZ();
        return this.transformed(new Transform().scaleZ(scaleValue));
    }

    public CSG scaleToMeasurmentY(Number measurment) {
        Double scaleValue = measurment.doubleValue() / this.getTotalY();
        return this.transformed(new Transform().scaleY(scaleValue));
    }

    public CSG scaleToMeasurmentX(Number measurment) {
        Double scaleValue = measurment.doubleValue() / this.getTotalX();
        return this.transformed(new Transform().scaleX(scaleValue));
    }

    public CSG scale(Number scaleValue) {
        return this.transformed(new Transform().scale(scaleValue.doubleValue()));
    }

    public static CSG fromPolygons(List<Polygon> polygons) {
        CSG csg = new CSG();
        csg.setPolygons(polygons);
        return csg;
    }

    public static CSG fromPolygons(Polygon ... polygons) {
        return CSG.fromPolygons(Arrays.asList(polygons));
    }

    public static CSG fromPolygons(PropertyStorage storage, List<Polygon> polygons) {
        CSG csg = new CSG();
        csg.setPolygons(polygons);
        csg.setStorage(storage);
        for (Polygon polygon : polygons) {
            polygon.setStorage(storage);
        }
        return csg;
    }

    public static CSG fromPolygons(PropertyStorage storage, Polygon ... polygons) {
        return CSG.fromPolygons(storage, Arrays.asList(polygons));
    }

    public CSG clone() {
        CSG csg = new CSG();
        csg.setOptType(this.getOptType());
        ArrayList<Polygon> collect = new ArrayList<Polygon>();
        for (Polygon p : this.polygons) {
            if (p == null) continue;
            try {
                Polygon my = p.clone();
                collect.add(my);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        csg.setPolygons(collect);
        return csg.historySync(this);
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    public CSG optimization(OptType type) {
        this.setOptType(type);
        return this;
    }

    public CSG union(CSG csg) {
        switch (this.getOptType()) {
            case CSG_BOUND: {
                return this._unionCSGBoundsOpt(csg).historySync(this).historySync(csg);
            }
            case POLYGON_BOUND: {
                return this._unionPolygonBoundsOpt(csg).historySync(this).historySync(csg);
            }
        }
        return this._unionNoOpt(csg).historySync(this).historySync(csg);
    }

    public CSG dumbUnion(CSG csg) {
        boolean tri = this.triangulated && csg.triangulated;
        CSG result = this.clone();
        CSG other = csg.clone();
        result.getPolygons().addAll(other.getPolygons());
        this.bounds = null;
        result.triangulated = tri;
        return result.historySync(other);
    }

    public CSG union(List<CSG> csgs) {
        CSG result = this;
        for (int i = 0; i < csgs.size(); ++i) {
            CSG csg = csgs.get(i);
            result = result.union(csg);
            if (Thread.interrupted()) break;
            progressMoniter.progressUpdate(i, csgs.size(), "Union", result);
        }
        return result;
    }

    public CSG union(CSG ... csgs) {
        return this.union(Arrays.asList(csgs));
    }

    public CSG hull() {
        return HullUtil.hull(this, this.getStorage()).historySync(this);
    }

    public static CSG unionAll(CSG ... csgs) {
        return CSG.unionAll(Arrays.asList(csgs));
    }

    public static CSG unionAll(List<CSG> csgs) {
        CSG first = csgs.get(0);
        return first.union(csgs.stream().skip(1L).collect(Collectors.toList()));
    }

    public static CSG hullAll(CSG ... csgs) {
        return CSG.hullAll(Arrays.asList(csgs));
    }

    public static CSG hullAll(List<CSG> csgs) {
        return HullUtil.hull(csgs);
    }

    public CSG hull(List<CSG> csgs) {
        CSG csgsUnion = new CSG();
        csgsUnion.optType = this.optType;
        csgsUnion.setPolygons(this.clone().getPolygons());
        csgs.stream().forEach(csg -> {
            csgsUnion.getPolygons().addAll(csg.clone().getPolygons());
            csgsUnion.historySync((CSG)csg);
        });
        csgsUnion.getPolygons().forEach(p -> p.setStorage(this.getStorage()));
        this.bounds = null;
        return csgsUnion.hull();
    }

    public CSG hull(CSG ... csgs) {
        return this.hull(Arrays.asList(csgs));
    }

    private CSG _unionCSGBoundsOpt(CSG csg) {
        return this._unionIntersectOpt(csg);
    }

    private CSG _unionPolygonBoundsOpt(CSG csg) {
        ArrayList<Polygon> inner = new ArrayList<Polygon>();
        ArrayList outer = new ArrayList();
        Bounds b = csg.getBounds();
        this.getPolygons().stream().forEach(p -> {
            if (b.intersects(p.getBounds())) {
                inner.add((Polygon)p);
            } else {
                outer.add(p);
            }
        });
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        if (!inner.isEmpty()) {
            CSG innerCSG = CSG.fromPolygons(inner);
            allPolygons.addAll(outer);
            allPolygons.addAll(innerCSG._unionNoOpt(csg).getPolygons());
        } else {
            allPolygons.addAll(this.getPolygons());
            allPolygons.addAll(csg.getPolygons());
        }
        this.bounds = null;
        CSG back = CSG.fromPolygons(allPolygons).optimization(this.getOptType());
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            back.setName(this.name);
        }
        return back;
    }

    private CSG _unionIntersectOpt(CSG csg) {
        boolean intersects = false;
        Bounds bounds = csg.getBounds();
        for (Polygon p : this.getPolygons()) {
            if (!bounds.intersects(p.getBounds())) continue;
            intersects = true;
            break;
        }
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        if (intersects) {
            return this._unionNoOpt(csg);
        }
        allPolygons.addAll(this.getPolygons());
        allPolygons.addAll(csg.getPolygons());
        CSG back = CSG.fromPolygons(allPolygons).optimization(this.getOptType());
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            back.setName(this.name);
        }
        return back;
    }

    private CSG _unionNoOpt(CSG csg) {
        Node a = new Node(this.clone().getPolygons());
        Node b = new Node(csg.clone().getPolygons());
        a.clipTo(b);
        b.clipTo(a);
        b.invert();
        b.clipTo(a);
        b.invert();
        a.build(b.allPolygons());
        CSG back = CSG.fromPolygons(a.allPolygons()).optimization(this.getOptType());
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            back.setName(this.name);
        }
        return back;
    }

    public CSG difference(List<CSG> csgs) {
        if (csgs.isEmpty()) {
            return this.clone();
        }
        CSG csgsUnion = csgs.get(0);
        for (int i = 1; i < csgs.size(); ++i) {
            csgsUnion = csgsUnion.union(csgs.get(i));
            progressMoniter.progressUpdate(i, csgs.size(), "Difference", csgsUnion);
            csgsUnion.historySync(csgs.get(i));
            if (Thread.interrupted()) break;
        }
        return this.difference(csgsUnion);
    }

    public CSG difference(CSG ... csgs) {
        return this.difference(Arrays.asList(csgs));
    }

    public CSG difference(CSG csg) {
        try {
            if (this.getPolygons().size() > 0 && csg.getPolygons().size() > 0) {
                switch (this.getOptType()) {
                    case CSG_BOUND: {
                        return this._differenceCSGBoundsOpt(csg).historySync(this).historySync(csg);
                    }
                    case POLYGON_BOUND: {
                        return this._differencePolygonBoundsOpt(csg).historySync(this).historySync(csg);
                    }
                }
                return this._differenceNoOpt(csg).historySync(this).historySync(csg);
            }
            return this;
        }
        catch (Exception ex) {
            try {
                CSG intersectingParts = csg.intersect(this);
                if (intersectingParts.getPolygons().size() > 0) {
                    switch (this.getOptType()) {
                        case CSG_BOUND: {
                            return this._differenceCSGBoundsOpt(intersectingParts).historySync(this).historySync(intersectingParts);
                        }
                        case POLYGON_BOUND: {
                            return this._differencePolygonBoundsOpt(intersectingParts).historySync(this).historySync(intersectingParts);
                        }
                    }
                    return this._differenceNoOpt(intersectingParts).historySync(this).historySync(intersectingParts);
                }
                return this;
            }
            catch (Exception e) {
                e.printStackTrace();
                return this;
            }
        }
    }

    private CSG _differenceCSGBoundsOpt(CSG csg) {
        CSG a1 = this._differenceNoOpt(csg.getBounds().toCSG());
        CSG a2 = this.intersect(csg.getBounds().toCSG());
        CSG result = a2._differenceNoOpt(csg)._unionIntersectOpt(a1).optimization(this.getOptType());
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            result.setName(this.name);
        }
        result.color = this.color;
        return result;
    }

    private CSG _differencePolygonBoundsOpt(CSG csg) {
        ArrayList<Polygon> inner = new ArrayList<Polygon>();
        ArrayList outer = new ArrayList();
        Bounds bounds = csg.getBounds();
        this.getPolygons().stream().forEach(p -> {
            if (bounds.intersects(p.getBounds())) {
                inner.add((Polygon)p);
            } else {
                outer.add(p);
            }
        });
        CSG innerCSG = CSG.fromPolygons(inner);
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        allPolygons.addAll(outer);
        allPolygons.addAll(innerCSG._differenceNoOpt(csg).getPolygons());
        CSG BACK = CSG.fromPolygons(allPolygons).optimization(this.getOptType());
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            BACK.setName(this.name);
        }
        return BACK;
    }

    private CSG _differenceNoOpt(CSG csg) {
        Node a = new Node(this.clone().getPolygons());
        Node b = new Node(csg.clone().getPolygons());
        a.invert();
        a.clipTo(b);
        b.clipTo(a);
        b.invert();
        b.clipTo(a);
        b.invert();
        a.build(b.allPolygons());
        a.invert();
        CSG csgA = CSG.fromPolygons(a.allPolygons()).optimization(this.getOptType());
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            csgA.setName(this.name);
        }
        return csgA;
    }

    public CSG intersect(CSG csg) {
        Node a = new Node(this.clone().getPolygons());
        Node b = new Node(csg.clone().getPolygons());
        a.invert();
        b.clipTo(a);
        b.invert();
        a.clipTo(b);
        b.clipTo(a);
        a.build(b.allPolygons());
        a.invert();
        CSG back = CSG.fromPolygons(a.allPolygons()).optimization(this.getOptType()).historySync(csg).historySync(this);
        if (this.getName().length() != 0 && csg.getName().length() != 0) {
            back.setName(this.name);
        }
        return back;
    }

    public CSG intersect(List<CSG> csgs) {
        if (csgs.isEmpty()) {
            return this.clone();
        }
        CSG csgsUnion = csgs.get(0);
        for (int i = 1; i < csgs.size(); ++i) {
            csgsUnion = csgsUnion.union(csgs.get(i));
            progressMoniter.progressUpdate(i, csgs.size(), "Intersect", csgsUnion);
            csgsUnion.historySync(csgs.get(i));
            if (Thread.interrupted()) break;
        }
        return this.intersect(csgsUnion);
    }

    public CSG intersect(CSG ... csgs) {
        return this.intersect(Arrays.asList(csgs));
    }

    public String toStlString() {
        StringBuilder sb = new StringBuilder();
        this.toStlString(sb);
        return sb.toString();
    }

    public StringBuilder toStlString(StringBuilder sb) {
        this.triangulate(false);
        try {
            sb.append("solid v3d.csg\n");
            for (Polygon p : this.getPolygons()) {
                try {
                    Plane.computeNormal(p.vertices);
                    p.toStlString(sb);
                }
                catch (Exception ex) {
                    System.out.println("Prune Polygon on export");
                }
            }
            sb.append("endsolid v3d.csg\n");
            return sb;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public CSG triangulate() {
        return this.triangulate(false);
    }

    public CSG triangulate(boolean fix) {
        if (fix && needsDegeneratesPruned) {
            this.triangulated = false;
        }
        if (this.triangulated) {
            return this;
        }
        ArrayList<Polygon> toAdd = new ArrayList<Polygon>();
        ArrayList degenerates = new ArrayList();
        if (providerOf3d == null && Debug3dProvider.provider != null) {
            providerOf3d = Debug3dProvider.provider;
        }
        IDebug3dProvider start = Debug3dProvider.provider;
        Debug3dProvider.setProvider(null);
        if (preventNonManifoldTriangles) {
            for (int i = 0; i < 2; ++i) {
                if (CSG.isUseGPU()) {
                    this.runGPUMakeManifold();
                    continue;
                }
                this.runCPUMakeManifold();
            }
        }
        try {
            Stream polygonStream = this.polygons.stream();
            polygonStream.forEach(p -> this.updatePolygons(toAdd, degenerates, (Polygon)p));
            if (degenerates.size() > 0) {
                if (fix) {
                    Debug3dProvider.clearScreen();
                    Stream degenStreeam = this.polygons.stream();
                    degenStreeam.forEach(p -> this.fixDegenerates(toAdd, (Polygon)p));
                } else {
                    needsDegeneratesPruned = true;
                    toAdd.addAll(degenerates);
                }
            }
            if (toAdd.size() > 0) {
                this.setPolygons(toAdd);
            }
            this.triangulated = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Debug3dProvider.setProvider(start);
        return this;
    }

    private void runCPUMakeManifold() {
        long start = System.currentTimeMillis();
        System.err.println("Cleaning up the mesh by adding coincident points to the polygons they touch");
        int totalAdded = 0;
        double tOL = 1.0E-11;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int j = 0; j < this.polygons.size(); ++j) {
            int threadIndex = j;
            Thread t = new Thread(() -> {
                Edge e = null;
                Polygon i = this.polygons.get(threadIndex);
                ArrayList<Vertex> vertices = i.vertices;
                for (int k = 0; k < vertices.size(); ++k) {
                    int now = k;
                    int next = k + 1;
                    if (next == vertices.size()) {
                        next = 0;
                    }
                    Vertex p1 = vertices.get(now);
                    Vertex p2 = vertices.get(next);
                    if (e == null) {
                        e = new Edge(p1, p2);
                    } else {
                        e.setP1(p1);
                        e.setP2(p2);
                    }
                    for (int l = 0; l < this.polygons.size(); ++l) {
                        Polygon ii = this.polygons.get(l);
                        if (threadIndex == l) continue;
                        ArrayList<Vertex> vert = ii.vertices;
                        for (int iii = 0; iii < vert.size(); ++iii) {
                            Vertex vi = vert.get(iii);
                            if (e.isThisPointOneOfMine(vi, tOL) || !e.contains(vi.pos, tOL)) continue;
                            vertices.add(next, vi);
                            e.setP2(vi);
                        }
                    }
                }
            });
            if (threads.size() > 32) {
                for (Thread tr : threads) {
                    try {
                        tr.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                totalAdded += 32;
                threads.clear();
                if (threadIndex / 32 % 50 == 0 || j == this.polygons.size() - 1) {
                    progressMoniter.progressUpdate(j, this.polygons.size(), "STL Processing Polygons for Manifold Vertex, #" + totalAdded + " added so far", this);
                }
            }
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        progressMoniter.progressUpdate(this.polygons.size(), this.polygons.size(), "Manifold fix took " + (System.currentTimeMillis() - start), this);
    }

    private void runGPUMakeManifold() {
        int numberOfPoints = 0;
        int roomForMore = 10;
        int size = this.polygons.size();
        for (int i = 0; i < size; ++i) {
            numberOfPoints += this.polygons.get((int)i).vertices.size();
        }
        final float[] pointData = new float[numberOfPoints * 3];
        final int[] startIndex = new int[size];
        final int[] sizes = new int[size];
        final int[] insertions = new int[size * 2 * roomForMore];
        int runningPointIndex = 0;
        for (int i = 0; i < insertions.length; ++i) {
            insertions[i] = -1;
        }
        for (int polyIndex = 0; polyIndex < size; ++polyIndex) {
            sizes[polyIndex] = this.polygons.get((int)polyIndex).vertices.size();
            startIndex[polyIndex] = runningPointIndex;
            for (int ii = 0; ii < sizes[polyIndex]; ++ii) {
                Vector3d pos = this.polygons.get((int)polyIndex).vertices.get((int)ii).pos.clone().roundToEpsilon(Vector3d.getEXPORTEPSILON());
                pointData[startIndex[polyIndex] + 0 + ii] = (float)pos.x;
                pointData[startIndex[polyIndex] + 1 + ii] = (float)pos.y;
                pointData[startIndex[polyIndex] + 2 + ii] = (float)pos.z;
            }
            runningPointIndex += sizes[polyIndex] * 3;
        }
        System.out.println("Data loaded!");
        Kernel kernel = new Kernel(){

            public void run() {
                int myStartIndex;
                int i = this.getGlobalId();
                int size = sizes[i];
                for (int mypolyIndex = myStartIndex = startIndex[i]; mypolyIndex < size; ++mypolyIndex) {
                    float x = pointData[myStartIndex + 0 + mypolyIndex];
                    float y = pointData[myStartIndex + 1 + mypolyIndex];
                    float z = pointData[myStartIndex + 2 + mypolyIndex];
                    for (int polyIndex = 0; polyIndex < sizes.length; ++polyIndex) {
                        for (int ii = 0; ii < sizes[polyIndex]; ++ii) {
                            float xSub = pointData[startIndex[polyIndex] + 0 + ii];
                            float ySub = pointData[startIndex[polyIndex] + 1 + ii];
                            float zSub = pointData[startIndex[polyIndex] + 2 + ii];
                            insertions[i] = 1;
                        }
                    }
                }
            }
        };
        Device device = Device.best();
        System.out.println("Dev " + device.getShortDescription());
        Range range = device.createRange(size);
        kernel.execute(range);
        while (kernel.isExecuting()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Data processed!");
    }

    private CSG fixDegenerates(ArrayList<Polygon> toAdd, Polygon p) {
        Debug3dProvider.clearScreen();
        Debug3dProvider.addObject(p);
        ArrayList<Vertex> degen = p.getDegeneratePoints();
        Edge longEdge = p.getLongEdge();
        ArrayList<Polygon> polygonsSharing = new ArrayList<Polygon>();
        ArrayList<Polygon> polygonsSharingFixed = new ArrayList<Polygon>();
        for (Polygon ptoA : toAdd) {
            ArrayList<Edge> edges = ptoA.edges();
            for (Edge e : edges) {
                if (!e.equals(longEdge)) continue;
                polygonsSharing.add(ptoA);
                Debug3dProvider.addObject(ptoA);
                ArrayList<Vertex> newpoints = new ArrayList<Vertex>();
                for (Vertex v : ptoA.vertices) {
                    newpoints.add(v);
                    if (!e.isThisPointOneOfMine(v, Plane.EPSILON_Point)) continue;
                    for (Vertex v2 : degen) {
                        newpoints.add(v2);
                    }
                }
                Polygon e2 = new Polygon(newpoints, ptoA.getStorage());
                try {
                    List<Polygon> t = PolygonUtil.concaveToConvex(e2);
                    for (Polygon poly : t) {
                        if (poly.isDegenerate()) continue;
                        polygonsSharingFixed.add(poly);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (polygonsSharing.size() == 0) {
            // empty if block
        }
        if (polygonsSharingFixed.size() > 0) {
            toAdd.removeAll(polygonsSharing);
            toAdd.addAll(polygonsSharingFixed);
        }
        return this;
    }

    private CSG updatePolygons(ArrayList<Polygon> toAdd, ArrayList<Polygon> degenerates, Polygon p) {
        if (p == null) {
            return this;
        }
        if (p.vertices.size() == 3) {
            toAdd.add(p);
        } else {
            try {
                List<Polygon> triangles = PolygonUtil.concaveToConvex(p);
                for (Polygon poly : triangles) {
                    toAdd.add(poly);
                }
            }
            catch (Throwable ex) {
                progressMoniter.progressUpdate(1, 1, "Pruning bad polygon CSG::updatePolygons " + p, null);
            }
        }
        return this;
    }

    public CSG color(Color c) {
        this.getStorage().set("material:color", "" + c.getRed() + " " + c.getGreen() + " " + c.getBlue());
        return this;
    }

    public StringBuilder toObjString(StringBuilder sb) {
        this.triangulate(true);
        sb.append("# Group").append("\n");
        sb.append("g v3d.csg\n");
        sb.append("o " + (this.name == null || this.name.length() == 0 ? "CSG Export" : this.getName()) + "\n");
        ArrayList vertices = new ArrayList();
        class PolygonStruct {
            PropertyStorage storage;
            List<Integer> indices;
            String materialName;

            public PolygonStruct(PropertyStorage storage, List<Integer> indices, String materialName) {
                this.storage = storage;
                this.indices = indices;
                this.materialName = materialName;
            }
        }
        ArrayList<PolygonStruct> indices = new ArrayList<PolygonStruct>();
        sb.append("\n# Vertices\n");
        for (Polygon p : this.getPolygons()) {
            ArrayList<Integer> polyIndices = new ArrayList<Integer>();
            p.vertices.stream().forEach(v -> {
                if (!vertices.contains(v)) {
                    vertices.add(v);
                    v.toObjString(sb);
                    polyIndices.add(vertices.size());
                } else {
                    polyIndices.add(vertices.indexOf(v) + 1);
                }
            });
            indices.add(new PolygonStruct(this.getStorage(), polyIndices, " "));
        }
        HashMap<Vertex, Integer> mapping = new HashMap<Vertex, Integer>();
        HashMap<Transform, Vertex> mappingTF = new HashMap<Transform, Vertex>();
        if (this.datumReferences != null) {
            int startingIndex = vertices.size() + 1;
            sb.append("\n# Reference Datum").append("\n");
            for (Transform t : this.datumReferences) {
                Vertex v2 = new Vertex(new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0)).transform(t);
                Vertex v1 = new Vertex(new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, 1.0)).transform(t);
                mapping.put(v2, startingIndex++);
                mapping.put(v1, startingIndex++);
                mappingTF.put(t, v2);
                v2.toObjString(sb);
                v1.toObjString(sb);
            }
            sb.append("\n# Datum Lines").append("\n");
            for (Transform t : mappingTF.keySet()) {
                Vertex key = (Vertex)mappingTF.get(t);
                Integer obj = (Integer)mapping.get(key);
                sb.append("\nl ").append(obj + " ").append(obj + 1).append("\n");
            }
        }
        sb.append("\n# Faces").append("\n");
        for (PolygonStruct ps : indices) {
            List<Integer> pVerts = ps.indices;
            if (pVerts.size() != 3) {
                throw new RuntimeException(this.name + " can not be exported until triangulated");
            }
            int index1 = pVerts.get(0);
            for (int i = 0; i < pVerts.size() - 2; ++i) {
                int index2 = pVerts.get(i + 1);
                int index3 = pVerts.get(i + 2);
                sb.append("f ").append(index1).append(" ").append(index2).append(" ").append(index3).append("\n");
            }
        }
        sb.append("\n# End Group v3d.csg").append("\n");
        return sb;
    }

    public String toObjString() {
        StringBuilder sb = new StringBuilder();
        return this.toObjString(sb).toString();
    }

    public CSG weighted(WeightFunction f) {
        return new Modifier(f).modified(this);
    }

    public CSG transformed(Transform transform) {
        if (this.getPolygons().isEmpty()) {
            return this.clone();
        }
        List<Polygon> newpolygons = this.getPolygons().stream().map(p -> {
            try {
                return p.transformed(transform);
            }
            catch (Exception e) {
                System.err.println("Removing Polygon during transform");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        CSG csg = CSG.fromPolygons(newpolygons).optimization(this.getOptType());
        if (this.getName().length() != 0) {
            csg.setName(this.name);
        }
        return csg.historySync(this);
    }

    public MeshContainer toJavaFXMesh(CadInteractionEvent interact) {
        return this.toJavaFXMeshSimple(interact);
    }

    public MeshContainer toJavaFXMeshSimple(CadInteractionEvent interact) {
        return CSGtoJavafx.meshFromPolygon(this.getPolygons());
    }

    public Bounds getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.getPolygons().isEmpty()) {
            this.bounds = new Bounds(Vector3d.ZERO, Vector3d.ZERO);
            return this.bounds;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Polygon p : this.getPolygons()) {
            for (int i = 0; i < p.vertices.size(); ++i) {
                Vertex vert = p.vertices.get(i);
                if (vert.pos.x < minX) {
                    minX = vert.pos.x;
                }
                if (vert.pos.y < minY) {
                    minY = vert.pos.y;
                }
                if (vert.pos.z < minZ) {
                    minZ = vert.pos.z;
                }
                if (vert.pos.x > maxX) {
                    maxX = vert.pos.x;
                }
                if (vert.pos.y > maxY) {
                    maxY = vert.pos.y;
                }
                if (!(vert.pos.z > maxZ)) continue;
                maxZ = vert.pos.z;
            }
        }
        this.bounds = new Bounds(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ));
        return this.bounds;
    }

    public Vector3d getCenter() {
        return new Vector3d(this.getCenterX(), this.getCenterY(), this.getCenterZ());
    }

    public double getCenterX() {
        return this.getMinX() / 2.0 + this.getMaxX() / 2.0;
    }

    public double getCenterY() {
        return this.getMinY() / 2.0 + this.getMaxY() / 2.0;
    }

    public double getCenterZ() {
        return this.getMinZ() / 2.0 + this.getMaxZ() / 2.0;
    }

    public double getMaxX() {
        return this.getBounds().getMax().x;
    }

    public double getMaxY() {
        return this.getBounds().getMax().y;
    }

    public double getMaxZ() {
        return this.getBounds().getMax().z;
    }

    public double getMinX() {
        return this.getBounds().getMin().x;
    }

    public double getMinY() {
        return this.getBounds().getMin().y;
    }

    public double getMinZ() {
        return this.getBounds().getMin().z;
    }

    public double getTotalX() {
        return -this.getMinX() + this.getMaxX();
    }

    public double getTotalY() {
        return -this.getMinY() + this.getMaxY();
    }

    public double getTotalZ() {
        return -this.getMinZ() + this.getMaxZ();
    }

    protected OptType getOptType() {
        return this.optType != null ? this.optType : defaultOptType;
    }

    public static void setDefaultOptType(OptType optType) {
        defaultOptType = optType;
    }

    public CSG setOptType(OptType optType) {
        this.optType = optType;
        return this;
    }

    public CSG setPolygons(List<Polygon> polygons) {
        this.bounds = null;
        this.triangulated = false;
        this.polygons = polygons;
        return this;
    }

    @Deprecated
    public ArrayList<CSG> minovsky(CSG travelingShape) {
        return this.minkowski(travelingShape);
    }

    public ArrayList<CSG> mink(CSG travelingShape) {
        return this.minkowski(travelingShape);
    }

    public ArrayList<CSG> minkowskiHullShape(CSG travelingShape) {
        ArrayList<CSG> bits = new ArrayList<CSG>();
        for (Polygon p : this.getPolygons()) {
            ArrayList<Vector3d> plist = new ArrayList<Vector3d>();
            for (Vertex v : p.vertices) {
                CSG newSHape = travelingShape.move(v);
                for (Polygon np : newSHape.getPolygons()) {
                    for (Vertex nv : np.vertices) {
                        plist.add(nv.pos);
                    }
                }
            }
            bits.add(HullUtil.hull(plist));
        }
        return bits;
    }

    public ArrayList<CSG> minkowski(CSG travelingShape) {
        HashMap<Vertex, CSG> map = new HashMap<Vertex, CSG>();
        for (Polygon p : travelingShape.getPolygons()) {
            for (Vertex v : p.vertices) {
                if (map.get(v) != null) continue;
                map.put(v, this.move(v));
            }
        }
        return new ArrayList<CSG>(map.values());
    }

    public CSG minkowskiDifference(CSG itemToDifference, CSG minkowskiObject) {
        CSG intersection = this.intersect(itemToDifference);
        ArrayList<CSG> csgDiff = intersection.minkowskiHullShape(minkowskiObject);
        CSG result = this;
        for (int i = 0; i < csgDiff.size(); ++i) {
            result = result.difference(csgDiff.get(i));
            progressMoniter.progressUpdate(i, csgDiff.size(), "Minkowski difference", result);
        }
        return result;
    }

    public CSG minkowskiDifference(CSG itemToDifference, double tolerance) {
        double shellThickness = Math.abs(tolerance);
        if (shellThickness < 0.001) {
            return this;
        }
        return this.minkowskiDifference(itemToDifference, new Sphere(shellThickness / 2.0, 8, 4).toCSG());
    }

    public CSG toolOffset(Number sn) {
        double shellThickness = sn.doubleValue();
        boolean cut = shellThickness < 0.0;
        if ((shellThickness = Math.abs(shellThickness)) < 0.001) {
            return this;
        }
        double z = shellThickness;
        if (z > this.getTotalZ() / 2.0) {
            z = this.getTotalZ() / 2.0;
        }
        CSG printNozzel = new Sphere(z / 2.0, 8, 4).toCSG();
        if (cut) {
            ArrayList<CSG> mikObjs = this.minkowski(printNozzel);
            CSG remaining = this;
            for (CSG bit : mikObjs) {
                remaining = remaining.intersect(bit);
            }
            return remaining;
        }
        return this.union(this.minkowskiHullShape(printNozzel));
    }

    private int getNumFacesForOffsets() {
        return CSG.getNumfacesinoffset();
    }

    public CSG makeKeepaway(Number sn) {
        double shellThickness = sn.doubleValue();
        double x = Math.abs(this.getBounds().getMax().x) + Math.abs(this.getBounds().getMin().x);
        double y = Math.abs(this.getBounds().getMax().y) + Math.abs(this.getBounds().getMin().y);
        double z = Math.abs(this.getBounds().getMax().z) + Math.abs(this.getBounds().getMin().z);
        double xtol = (x + shellThickness) / x;
        double ytol = (y + shellThickness) / y;
        double ztol = (z + shellThickness) / z;
        double xPer = -(Math.abs(this.getBounds().getMax().x) - Math.abs(this.getBounds().getMin().x)) / x;
        double yPer = -(Math.abs(this.getBounds().getMax().y) - Math.abs(this.getBounds().getMin().y)) / y;
        double zPer = -(Math.abs(this.getBounds().getMax().z) - Math.abs(this.getBounds().getMin().z)) / z;
        return this.transformed(new Transform().scale(xtol, ytol, ztol)).transformed(new Transform().translateX(shellThickness * xPer)).transformed(new Transform().translateY(shellThickness * yPer)).transformed(new Transform().translateZ(shellThickness * zPer)).historySync(this);
    }

    public Affine getManipulator() {
        if (this.manipulator == null) {
            this.manipulator = new Affine();
        }
        return this.manipulator;
    }

    public CSG addCreationEventStackTraceList(ArrayList<Exception> incoming) {
        for (Exception ex : incoming) {
            this.addStackTrace(ex);
        }
        return this;
    }

    private CSG addStackTrace(Exception creationEventStackTrace2) {
        for (StackTraceElement el : creationEventStackTrace2.getStackTrace()) {
            try {
                if (el.getFileName().endsWith(".java") || el.getLineNumber() <= 0) continue;
                boolean dupLine = false;
                String thisline = el.getFileName() + ":" + el.getLineNumber();
                for (String s : this.groovyFileLines) {
                    if (!s.contentEquals(thisline)) continue;
                    dupLine = true;
                    break;
                }
                if (dupLine) continue;
                this.groovyFileLines.add(thisline);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this;
    }

    public CSG historySync(CSG dyingCSG) {
        if (useStackTraces) {
            this.addCreationEventStringList(dyingCSG.getCreationEventStackTraceList());
        }
        Set<String> params = dyingCSG.getParameters();
        for (String param : params) {
            Parameter vals;
            boolean existing = false;
            for (String s : this.getParameters()) {
                if (!s.contentEquals(param)) continue;
                existing = true;
            }
            if (existing || (vals = CSGDatabase.get(param)) == null) continue;
            this.setParameter(vals, dyingCSG.getMapOfparametrics().get(param));
        }
        if (this.getName().length() == 0) {
            this.setName(dyingCSG.getName());
        }
        this.color = dyingCSG.getColor();
        return this;
    }

    public CSG addCreationEventStringList(ArrayList<String> incoming) {
        if (useStackTraces) {
            for (String s : incoming) {
                this.addCreationEventString(s);
            }
        }
        return this;
    }

    public CSG addCreationEventString(String thisline) {
        if (useStackTraces) {
            boolean dupLine = false;
            for (String s : this.groovyFileLines) {
                if (!s.contentEquals(thisline)) continue;
                dupLine = true;
                break;
            }
            if (!dupLine) {
                this.groovyFileLines.add(thisline);
            }
        }
        return this;
    }

    public ArrayList<String> getCreationEventStackTraceList() {
        return this.groovyFileLines;
    }

    public CSG prepMfg() {
        return this.prepForManufacturing();
    }

    public PrepForManufacturing getManufacturing() {
        return this.manufactuing;
    }

    public PrepForManufacturing getMfg() {
        return this.getManufacturing();
    }

    public CSG setMfg(PrepForManufacturing manufactuing) {
        return this.setManufacturing(manufactuing);
    }

    public CSG setManufacturing(PrepForManufacturing manufactuing) {
        this.manufactuing = manufactuing;
        return this;
    }

    @Deprecated
    public PrepForManufacturing getManufactuing() {
        return this.getManufacturing();
    }

    @Deprecated
    public CSG setManufactuing(PrepForManufacturing manufactuing) {
        return this.setManufacturing(manufactuing);
    }

    public CSG setParameter(Parameter w, IParametric function) {
        if (w == null) {
            return this;
        }
        if (CSGDatabase.get(w.getName()) == null) {
            CSGDatabase.set(w.getName(), w);
        }
        if (this.getMapOfparametrics().get(w.getName()) == null) {
            this.getMapOfparametrics().put(w.getName(), function);
        }
        return this;
    }

    public CSG setParameter(final Parameter w) {
        this.setParameter(w, new IParametric(){

            @Override
            public CSG change(CSG oldCSG, String parameterKey, Long newValue) {
                if (parameterKey.contentEquals(w.getName())) {
                    CSGDatabase.get(w.getName()).setValue(newValue);
                }
                return oldCSG;
            }
        });
        return this;
    }

    public CSG setParameter(String key, double defaultValue, double upperBound, double lowerBound, IParametric function) {
        ArrayList<Double> vals = new ArrayList<Double>();
        vals.add(upperBound);
        vals.add(lowerBound);
        this.setParameter(new LengthParameter(key, defaultValue, vals), function);
        return this;
    }

    public CSG setParameterIfNull(final String key) {
        if (this.getMapOfparametrics().get(key) == null) {
            this.getMapOfparametrics().put(key, new IParametric(){

                @Override
                public CSG change(CSG oldCSG, String parameterKey, Long newValue) {
                    CSGDatabase.get(key).setValue(newValue);
                    return oldCSG;
                }
            });
        }
        return this;
    }

    public Set<String> getParameters() {
        return this.getMapOfparametrics().keySet();
    }

    public CSG setParameterNewValue(String key, double newValue) {
        IParametric function = this.getMapOfparametrics().get(key);
        if (function != null) {
            CSG setManipulator = function.change(this, key, new Long((long)(newValue * 1000.0))).setManipulator(this.getManipulator());
            setManipulator.color = this.color;
            return setManipulator;
        }
        return this;
    }

    public CSG setRegenerate(IRegenerate function) {
        this.regenerate = function;
        return this;
    }

    public IRegenerate getRegenerate() {
        return this.regenerate;
    }

    public CSG regenerate() {
        this.markForRegeneration = false;
        if (this.regenerate == null) {
            return this;
        }
        CSG regenerate2 = this.regenerate.regenerate(this);
        if (regenerate2 != null) {
            return regenerate2.setManipulator(this.getManipulator()).historySync(this);
        }
        return this;
    }

    public HashMap<String, IParametric> getMapOfparametrics() {
        if (this.mapOfparametrics == null) {
            this.mapOfparametrics = new HashMap();
        }
        return this.mapOfparametrics;
    }

    public boolean isMarkedForRegeneration() {
        return this.markForRegeneration;
    }

    public CSG markForRegeneration() {
        this.markForRegeneration = true;
        return this;
    }

    public boolean touching(CSG incoming) {
        CSG inter;
        return this.getMaxX() > incoming.getMinX() && this.getMinX() < incoming.getMaxX() && this.getMaxY() > incoming.getMinY() && this.getMinY() < incoming.getMaxY() && this.getMaxZ() > incoming.getMinZ() && this.getMinZ() < incoming.getMaxZ() && (inter = this.intersect(incoming)).getPolygons().size() > 0;
    }

    public static ICSGProgress getProgressMoniter() {
        return progressMoniter;
    }

    public static void setProgressMoniter(ICSGProgress progressMoniter) {
        CSG.progressMoniter = progressMoniter;
    }

    public static Color getDefaultColor() {
        return defaultcolor;
    }

    public static void setDefaultColor(Color defaultcolor) {
        CSG.defaultcolor = defaultcolor;
    }

    public CSG getBoundingBox() {
        return new Cube(-this.getMinX() + this.getMaxX(), -this.getMinY() + this.getMaxY(), -this.getMinZ() + this.getMaxZ()).toCSG().toXMax().movex(this.getMaxX()).toYMax().movey(this.getMaxY()).toZMax().movez(this.getMaxZ());
    }

    public String getName() {
        return this.name;
    }

    public CSG setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        return this;
    }

    public String toString() {
        if (this.name == null) {
            return this.getColor().toString();
        }
        return this.getName() + " " + this.getColor().toString();
    }

    public ArrayList<Transform> getSlicePlanes() {
        return this.slicePlanes;
    }

    public CSG addSlicePlane(Transform slicePlane) {
        if (this.slicePlanes == null) {
            this.slicePlanes = new ArrayList();
        }
        this.slicePlanes.add(slicePlane);
        return this;
    }

    public ArrayList<String> getExportFormats() {
        return this.exportFormats;
    }

    public CSG clearExportFormats() {
        if (this.exportFormats != null) {
            this.exportFormats.clear();
        }
        return this;
    }

    public CSG addExportFormat(String exportFormat) {
        if (this.exportFormats == null) {
            this.exportFormats = new ArrayList();
        }
        for (String f : this.exportFormats) {
            if (!f.toLowerCase().contains(exportFormat.toLowerCase())) continue;
            return this;
        }
        this.exportFormats.add(exportFormat.toLowerCase());
        return this;
    }

    public static int getNumfacesinoffset() {
        return CSG.getNumFacesInOffset();
    }

    public static int getNumFacesInOffset() {
        return numFacesInOffset;
    }

    public static void setNumFacesInOffset(int numFacesInOffset) {
        CSG.numFacesInOffset = numFacesInOffset;
    }

    public static boolean isUseStackTraces() {
        return useStackTraces;
    }

    public static void setUseStackTraces(boolean useStackTraces) {
        CSG.useStackTraces = useStackTraces;
    }

    public ArrayList<Transform> getDatumReferences() {
        return this.datumReferences;
    }

    private CSG setDatumReferences(ArrayList<Transform> datumReferences) {
        this.datumReferences = datumReferences;
        return this;
    }

    public PropertyStorage getStorage() {
        return this.str;
    }

    public CSG setStorage(PropertyStorage storage) {
        this.str = storage;
        return this;
    }

    public ArrayList<CSG> addTabs(Vector3d edgeDirection, CSG fastener) throws Exception {
        ArrayList<CSG> result = new ArrayList<CSG>();
        ArrayList<CSG> fasteners = new ArrayList<CSG>();
        Transform boardTrans = this.addTabsReorientation(edgeDirection);
        CSG boardTemp = this.transformed(boardTrans);
        double tabSize = boardTemp.getMaxZ() * 2.0;
        double cycleSize = tabSize * 3.0;
        double minBuffer = boardTemp.getMaxZ();
        CSG tabTemp = new Cube(tabSize, boardTemp.getMaxZ(), boardTemp.getMaxZ()).toCSG();
        tabTemp = tabTemp.movex(tabTemp.getMaxX()).movey(-tabTemp.getMaxY() + boardTemp.getMinY()).movez(tabTemp.getMaxZ());
        CSG fastenerHoleTemp = fastener.rotx(-90).movex(-tabSize).movey(0).movez(boardTemp.getMaxZ() / 2.0);
        int iterNum = (int)Math.floor((boardTemp.getMaxX() - tabSize - minBuffer * 2.0) / cycleSize);
        double bufferVal = (boardTemp.getMaxX() - (tabSize + cycleSize * (double)iterNum)) / 2.0;
        if (boardTemp.getTotalX() > tabSize + 2.0 * bufferVal) {
            boardTemp = boardTemp.union(tabTemp.movex(bufferVal));
        }
        for (int i = 1; i <= iterNum; ++i) {
            double xVal = bufferVal + (double)i * cycleSize;
            boardTemp = boardTemp.union(tabTemp.movex(xVal));
            fasteners.add(fastenerHoleTemp.movex(xVal).transformed(boardTrans.inverse()));
        }
        boardTemp = boardTemp.transformed(boardTrans.inverse());
        result.add(boardTemp);
        result.addAll(fasteners);
        return result;
    }

    private Transform addTabsReorientation(Vector3d edgeDirection) throws Exception {
        Transform boardTrans = new Transform();
        if (edgeDirection.equals((Tuple3d)Vector3d.X_ONE)) {
            boardTrans = boardTrans.rotz(90);
        } else if (edgeDirection.equals((Tuple3d)Vector3d.X_ONE.negated())) {
            boardTrans = boardTrans.rotz(-90);
        } else if (edgeDirection.equals((Tuple3d)Vector3d.Y_ONE)) {
            boardTrans = boardTrans.rotz(180);
        } else if (!edgeDirection.equals((Tuple3d)Vector3d.Y_ONE.negated())) {
            if (edgeDirection.equals((Tuple3d)Vector3d.Z_ONE)) {
                boardTrans = boardTrans.rotx(-90);
            } else if (edgeDirection.equals((Tuple3d)Vector3d.Z_ONE.negated())) {
                boardTrans = boardTrans.rotx(90);
            } else {
                throw new Exception("Invalid edge direction: edgeDirection must be a cartesian unit Vector3d object. Try Vector3d.Y_ONE.negated() - Current value: " + edgeDirection.toString());
            }
        }
        CSG boardTemp = this.transformed(boardTrans);
        boardTrans = boardTrans.movex(-boardTemp.getMinX()).movey(-boardTemp.getMinY()).movez(-boardTemp.getMinZ());
        boardTemp = this.transformed(boardTrans);
        if (boardTemp.getTotalZ() > boardTemp.getTotalX()) {
            boardTrans = boardTrans.roty(-90).movez(boardTemp.getMaxX());
        }
        return boardTrans;
    }

    public ArrayList<CSG> addTabs(Vector3d edgeDirection, LengthParameter fastenerHoleDiameter) throws Exception {
        Transform boardTrans = this.addTabsReorientation(edgeDirection);
        CSG boardTemp = this.transformed(boardTrans);
        double fastenerHoleRadius = fastenerHoleDiameter.getMM() / 2.0;
        double fastenerHoleDepth = boardTemp.getMaxZ();
        CSG fastenerHoleTemp = new Cylinder(fastenerHoleRadius, fastenerHoleDepth).toCSG();
        ArrayList<CSG> result = this.addTabs(edgeDirection, fastenerHoleTemp);
        return result;
    }

    public CSG addAssemblyStep(int stepNumber, Transform explodedPose) {
        Integer max;
        String key = "AssemblySteps";
        PropertyStorage incomingGetStorage = this.getAssemblyStorage();
        if (incomingGetStorage.getValue(key) == Optional.empty()) {
            HashMap map = new HashMap();
            incomingGetStorage.set(key, map);
        }
        if (incomingGetStorage.getValue("MaxAssemblyStep") == Optional.empty()) {
            incomingGetStorage.set("MaxAssemblyStep", stepNumber);
        }
        if (stepNumber > (max = (Integer)incomingGetStorage.getValue("MaxAssemblyStep").get())) {
            incomingGetStorage.set("MaxAssemblyStep", stepNumber);
        }
        HashMap map = (HashMap)incomingGetStorage.getValue(key).get();
        map.put(stepNumber, explodedPose);
        if (incomingGetStorage.getValue("AssembleAffine") == Optional.empty()) {
            incomingGetStorage.set("AssembleAffine", new Affine());
        }
        return this;
    }

    public PropertyStorage getAssemblyStorage() {
        if (this.assembly == null) {
            this.assembly = new PropertyStorage();
        }
        return this.assembly;
    }

    public boolean isWireFrame() {
        if (!this.getStorage().getValue("skeleton").isPresent()) {
            return false;
        }
        return (Boolean)this.getStorage().getValue("skeleton").get();
    }

    public CSG setIsWireFrame(boolean b) {
        this.getStorage().set("skeleton", b);
        return this;
    }

    public CSG setPrintBedNumber(int index) {
        this.getStorage().set("printBedIndex", index);
        return this;
    }

    public int getPrintBedIndex() {
        if (!this.getStorage().getValue("printBedIndex").isPresent()) {
            return 0;
        }
        return (Integer)this.getStorage().getValue("printBedIndex").get();
    }

    public static CSG text(String text, double height, double fontSize) {
        return CSG.text(text, height, fontSize, Font.getDefault().getName());
    }

    public static CSG text(String text, double height) {
        return CSG.text(text, height, 30.0);
    }

    public static CSG text(String text, double height, double fontSize, String fontType) {
        Font font = new Font(fontType, fontSize);
        if (!font.getName().toLowerCase().contains(fontType.toLowerCase())) {
            String options = "";
            for (String name : Font.getFontNames()) {
                options = options + name + "\n";
            }
            new Exception(options + "\nIs Not " + fontType + " instead got " + font.getName()).printStackTrace();
        }
        ArrayList<CSG> stuff = TextExtrude.text(height, text, font);
        CSG back = null;
        for (int i = 0; i < stuff.size(); ++i) {
            back = back == null ? stuff.get(i) : back.dumbUnion(stuff.get(i));
        }
        back = back.rotx(180).toZMin();
        return back;
    }

    public static CSG textToSize(String text, double x, double y, double z) {
        CSG startText = CSG.text(text, z);
        double scalex = x / startText.getTotalX();
        double scaley = y / startText.getTotalY();
        return startText.scalex(scalex).scaley(scaley).toXMin();
    }

    public boolean hasMassSet() {
        return this.getStorage().getValue("massKg").isPresent();
    }

    public CSG setMassKG(double mass) {
        this.getStorage().set("massKg", mass);
        return this;
    }

    public double getMassKG(double mass) {
        Optional o = this.getStorage().getValue("massKg");
        if (o.isPresent()) {
            return (Double)o.get();
        }
        return mass;
    }

    public CSG setCenterOfMass(Transform com) {
        Bounds b = this.getBounds();
        if (b.contains(com)) {
            this.getStorage().set("massCentroid", com);
        }
        return this;
    }

    public CSG setCenterOfMass(double x, double y, double z) {
        Transform com = new Transform().movex(x).movey(y).movez(z);
        return this.setCenterOfMass(com);
    }

    public Transform getCenterOfMass() {
        Optional o = this.getStorage().getValue("massCentroid");
        if (o.isPresent()) {
            return (Transform)o.get();
        }
        return new Transform().move(this.getCenter());
    }

    public CSG addGroupMembership(String groupID) {
        if (!this.getStorage().getValue("groupMembership").isPresent()) {
            this.getStorage().set("groupMembership", new HashSet());
        }
        ((HashSet)this.getStorage().getValue("groupMembership").get()).add(groupID);
        return this;
    }

    public CSG removeGroupMembership(String groupID) {
        if (!this.getStorage().getValue("groupMembership").isPresent()) {
            this.getStorage().set("groupMembership", new HashSet());
        }
        ((HashSet)this.getStorage().getValue("groupMembership").get()).remove(groupID);
        return this;
    }

    public boolean isInGroup() {
        Optional value = this.getStorage().getValue("groupMembership");
        return value.isPresent() && ((HashSet)value.get()).size() > 0;
    }

    public boolean checkGroupMembership(String groupName) {
        Optional o = this.getStorage().getValue("groupMembership");
        if (o.isPresent()) {
            for (String s : (HashSet)o.get()) {
                if (!s.contentEquals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    public CSG addIsGroupResult(String res) {
        if (!this.getStorage().getValue("GroupResult").isPresent()) {
            this.getStorage().set("GroupResult", new HashSet());
        }
        ((HashSet)this.getStorage().getValue("GroupResult").get()).add(res);
        return this;
    }

    public CSG removeIsGroupResult(String res) {
        if (!this.getStorage().getValue("GroupResult").isPresent()) {
            this.getStorage().set("GroupResult", new HashSet());
        }
        ((HashSet)this.getStorage().getValue("GroupResult").get()).remove(res);
        return this;
    }

    public boolean isGroupResult() {
        Optional o = this.getStorage().getValue("GroupResult");
        if (o.isPresent()) {
            return ((HashSet)o.get()).size() > 0;
        }
        return false;
    }

    public CSG setIsLock(boolean Lock) {
        this.getStorage().set("isLock", Lock);
        return this;
    }

    public boolean isLock() {
        Optional o = this.getStorage().getValue("isLock");
        if (o.isPresent()) {
            return (Boolean)o.get();
        }
        return false;
    }

    public CSG setIsHide(boolean Hide) {
        this.getStorage().set("isHide", Hide);
        return this;
    }

    public boolean isHide() {
        Optional o = this.getStorage().getValue("isHide");
        if (o.isPresent()) {
            return (Boolean)o.get();
        }
        return false;
    }

    public CSG setIsHole(boolean hole) {
        this.getStorage().set("isHole", hole);
        return this;
    }

    public boolean isHole() {
        Optional o = this.getStorage().getValue("isHole");
        if (o.isPresent()) {
            return (Boolean)o.get();
        }
        return false;
    }

    public CSG syncProperties(CSG dying) {
        this.getStorage().syncProperties(dying.getStorage());
        return this;
    }

    public static List<CSG> tessellate(CSG incoming, int xSteps, int ySteps, int zSteps, double xGrid, double yGrid, double zGrid, double oddRowXOffset, double oddRowYOffset, double oddRowZOffset, double oddColXOffset, double oddColYOffset, double oddColZOffset, double oddLayXOffset, double oddLayYOffset, double oddLayZOffset) {
        ArrayList<CSG> back = new ArrayList<CSG>();
        for (int i = 0; i < xSteps; ++i) {
            for (int j = 0; j < ySteps; ++j) {
                for (int k = 0; k < zSteps; ++k) {
                    double xoff = 0.0;
                    double yoff = 0.0;
                    double zoff = 0.0;
                    if (i % 2 != 0) {
                        xoff += oddRowXOffset;
                        yoff += oddRowYOffset;
                        zoff += oddRowZOffset;
                    }
                    if (j % 2 != 0) {
                        xoff += oddColXOffset;
                        yoff += oddColYOffset;
                        zoff += oddColZOffset;
                    }
                    if (k % 2 != 0) {
                        xoff += oddLayXOffset;
                        yoff += oddLayYOffset;
                        zoff += oddLayZOffset;
                    }
                    back.add(incoming.move(xoff + (double)i * xGrid, yoff + (double)j * yGrid, zoff + (double)k * zGrid));
                }
            }
        }
        return back;
    }

    public static List<CSG> tessellate(CSG incoming, int xSteps, int ySteps, int zSteps, double xGrid, double yGrid, double zGrid, double[][] offsets) {
        double oddRowXOffset = offsets[0][0];
        double oddRowYOffset = offsets[0][1];
        double oddRowZOffset = offsets[0][2];
        double oddColXOffset = offsets[1][0];
        double oddColYOffset = offsets[1][1];
        double oddColZOffset = offsets[1][2];
        double oddLayXOffset = offsets[2][0];
        double oddLayYOffset = offsets[2][1];
        double oddLayZOffset = offsets[2][2];
        return CSG.tessellate(incoming, xSteps, ySteps, zSteps, xGrid, yGrid, zGrid, oddRowXOffset, oddRowYOffset, oddRowZOffset, oddColXOffset, oddColYOffset, oddColZOffset, oddLayXOffset, oddLayYOffset, oddLayZOffset);
    }

    public static List<CSG> tessellate(CSG incoming, int xSteps, int ySteps, int zSteps) {
        return CSG.tessellate(incoming, xSteps, ySteps, zSteps, incoming.getTotalX(), incoming.getTotalY(), incoming.getTotalZ(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static List<CSG> tessellate(CSG incoming, int xSteps, int ySteps, int zSteps, double oddRowXOffset, double oddRowYOffset, double oddRowZOffset, double oddColXOffset, double oddColYOffset, double oddColZOffset, double oddLayXOffset, double oddLayYOffset, double oddLayZOffset) {
        double[][] offsets = new double[][]{{oddRowXOffset, oddRowYOffset, oddRowZOffset}, {oddColXOffset, oddColYOffset, oddColZOffset}, {oddLayXOffset, oddLayYOffset, oddLayZOffset}};
        return CSG.tessellate(incoming, xSteps, ySteps, zSteps, incoming.getTotalX(), incoming.getTotalY(), incoming.getTotalZ(), offsets);
    }

    public static List<CSG> tessellate(CSG incoming, int steps, double gridSpacing) {
        return CSG.tessellate(incoming, steps, steps, steps, gridSpacing, gridSpacing, gridSpacing, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static List<CSG> tessellate(CSG incoming, int steps) {
        return CSG.tessellate(incoming, steps, steps, steps, incoming.getTotalX(), incoming.getTotalY(), incoming.getTotalZ(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static List<CSG> tessellateXY(CSG incoming, int xSteps, int ySteps, double xGrid, double yGrid, double oddRowXOffset, double oddRowYOffset, double oddColXOffset, double oddColYOffset) {
        return CSG.tessellate(incoming, xSteps, ySteps, 1, xGrid, yGrid, 0.0, oddRowXOffset, oddRowYOffset, 0.0, oddColXOffset, oddColYOffset, 0.0, 0.0, 0.0, 0.0);
    }

    public static List<CSG> tessellateXY(CSG incoming, int xSteps, int ySteps, double xGrid, double yGrid, double[][] offsets) {
        double oddRowXOffset = offsets[0][0];
        double oddRowYOffset = offsets[0][1];
        double oddColXOffset = offsets[1][0];
        double oddColYOffset = offsets[1][1];
        return CSG.tessellate(incoming, xSteps, ySteps, 1, xGrid, yGrid, 0.0, oddRowXOffset, oddRowYOffset, 0.0, oddColXOffset, oddColYOffset, 0.0, 0.0, 0.0, 0.0);
    }

    public static List<CSG> tessellateXY(CSG incoming, int xSteps, int ySteps) {
        return CSG.tessellateXY(incoming, xSteps, ySteps, incoming.getTotalX(), incoming.getTotalY(), 0.0, 0.0, 0.0, 0.0);
    }

    public static List<CSG> tessellateXY(CSG incoming, int xSteps, int ySteps, double xGrid, double yGrid) {
        return CSG.tessellateXY(incoming, xSteps, ySteps, xGrid, yGrid, 0.0, 0.0, 0.0, 0.0);
    }

    List<CSG> tessellateHex(CSG incoming, int xSteps, int ySteps, double spacing) {
        double y = incoming.getTotalY() + spacing;
        double x = y / Math.sqrt(3.0) * 1.0;
        return CSG.tessellateXY(incoming, xSteps, ySteps, x, y, 0.0, 0.0, 0.0, y / 2.0);
    }

    List<CSG> tessellateHex(CSG incoming, int xSteps, int ySteps) {
        return this.tessellateHex(incoming, xSteps, ySteps, 0.0);
    }

    public static boolean isPreventNonManifoldTriangles() {
        return preventNonManifoldTriangles;
    }

    public static void setPreventNonManifoldTriangles(boolean preventNonManifoldTriangles) {
        if (!preventNonManifoldTriangles) {
            System.err.println("WARNING:This will make STL's incompatible with low quality slicing engines like Slice3r and PrusaSlicer");
        }
        CSG.preventNonManifoldTriangles = preventNonManifoldTriangles;
    }

    public static boolean isUseGPU() {
        return useGPU;
    }

    public static void setUseGPU(boolean useGPU) {
        CSG.useGPU = useGPU;
    }

    public static enum OptType {
        CSG_BOUND,
        POLYGON_BOUND,
        NONE;

    }
}

