/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import java.util.List;

public class ChamferedCylinder
extends Primitive {
    double r;
    double h;
    double chamferHeight;
    private final PropertyStorage properties = new PropertyStorage();

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public ChamferedCylinder(double r, double h, double chamferHeight) {
        this.r = r;
        this.h = h;
        this.chamferHeight = chamferHeight;
    }

    @Override
    public List<Polygon> toPolygons() {
        CSG cube1 = new Cylinder(this.r - this.chamferHeight, this.h).toCSG();
        CSG cube2 = new Cylinder(this.r, this.h - this.chamferHeight * 2.0).toCSG().movez(this.chamferHeight);
        return cube1.union(cube2).hull().getPolygons();
    }
}

