/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class TextExtrude {
    private static final String default_font = "FreeSerif";
    private static final int POINTS_CURVE = 10;
    private final String text;
    private Vector3d p0;
    private final List<LineSegment> polis = new ArrayList<LineSegment>();
    ArrayList<CSG> sections = new ArrayList();
    ArrayList<CSG> holes = new ArrayList();
    private double dir;
    private static final double CURVE_SEGMENTS = 3.0;
    private static final double POINT_EPSILON = 1.0E-4;

    private TextExtrude(String text, Font font, double dir) {
        if (dir <= 0.0) {
            throw new NumberFormatException("length can not be negative");
        }
        this.dir = dir;
        this.text = text;
        Text textNode = new Text(text);
        textNode.setFont(font);
        Path subtract = (Path)Shape.subtract((Shape)textNode, (Shape)new Rectangle(0.0, 0.0));
        List<List<Vector3d>> outlines = TextExtrude.extractOutlines(subtract);
        double zOff = 0.0;
        for (List<Vector3d> points : outlines) {
            boolean hole = Extrude.isCCW(Polygon.fromPoints(points));
            CSG newLetter = Extrude.points(new Vector3d(0.0, 0.0, dir), points).movez(zOff);
            if (!hole) {
                this.sections.add(newLetter);
                continue;
            }
            this.holes.add(newLetter);
        }
        for (int i = 0; i < this.sections.size(); ++i) {
            for (CSG h : this.holes) {
                try {
                    if (!this.sections.get(i).touching(h)) continue;
                    CSG nl = this.sections.get(i).difference(h);
                    this.sections.set(i, nl);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static ArrayList<CSG> text(double dir, String text, Font font) {
        TextExtrude te = new TextExtrude(text, font, dir);
        return te.sections;
    }

    public List<LineSegment> getLineSegment() {
        return this.polis;
    }

    public List<Vector3d> getOffset() {
        return this.polis.stream().sorted((p1, p2) -> (int)(p1.getOrigen().x - p2.getOrigen().x)).map(LineSegment::getOrigen).collect(Collectors.toList());
    }

    public static List<List<Vector3d>> extractOutlines(Path text) {
        List<List<Vector3d>> rawOutlines = TextExtrude.extractRawOutlines(text);
        ArrayList<List<Vector3d>> cleanedOutlines = new ArrayList<List<Vector3d>>();
        for (List<Vector3d> outline : rawOutlines) {
            List<Vector3d> cleaned = TextExtrude.cleanOutline(outline);
            if (cleaned.size() < 3) continue;
            cleanedOutlines.add(cleaned);
        }
        return cleanedOutlines;
    }

    private static List<List<Vector3d>> extractRawOutlines(Path textPath) {
        ArrayList<List<Vector3d>> allOutlines = new ArrayList<List<Vector3d>>();
        ArrayList<Vector3d> currentPath = new ArrayList<Vector3d>();
        Vector3d lastPoint = null;
        for (PathElement element : textPath.getElements()) {
            List<Vector3d> curvePoints;
            CubicCurveTo curve;
            if (element instanceof MoveTo) {
                if (!currentPath.isEmpty()) {
                    allOutlines.add(new ArrayList(currentPath));
                    currentPath.clear();
                }
                MoveTo move = (MoveTo)element;
                lastPoint = Vector3d.xyz(move.getX(), move.getY(), 0.0);
                currentPath.add(lastPoint);
                continue;
            }
            if (element instanceof LineTo) {
                LineTo line = (LineTo)element;
                lastPoint = Vector3d.xyz(line.getX(), line.getY(), 0.0);
                currentPath.add(lastPoint);
                continue;
            }
            if (element instanceof CubicCurveTo) {
                curve = (CubicCurveTo)element;
                curvePoints = TextExtrude.approximateCubicCurve(lastPoint, Vector3d.xyz(curve.getControlX1(), curve.getControlY1(), 0.0), Vector3d.xyz(curve.getControlX2(), curve.getControlY2(), 0.0), Vector3d.xyz(curve.getX(), curve.getY(), 0.0));
                currentPath.addAll(curvePoints);
                lastPoint = curvePoints.get(curvePoints.size() - 1);
                continue;
            }
            if (!(element instanceof QuadCurveTo)) continue;
            curve = (QuadCurveTo)element;
            curvePoints = TextExtrude.approximateQuadCurve(lastPoint, Vector3d.xyz(curve.getControlX(), curve.getControlY(), 0.0), Vector3d.xyz(curve.getX(), curve.getY(), 0.0));
            currentPath.addAll(curvePoints);
            lastPoint = curvePoints.get(curvePoints.size() - 1);
        }
        if (!currentPath.isEmpty()) {
            allOutlines.add(currentPath);
        }
        return allOutlines;
    }

    private static List<Vector3d> cleanOutline(List<Vector3d> outline) {
        if (outline.isEmpty()) {
            return outline;
        }
        ArrayList<Vector3d> cleaned = new ArrayList<Vector3d>();
        Vector3d prevPoint = null;
        for (Vector3d point : outline) {
            if (prevPoint != null && TextExtrude.isNearlyEqual(prevPoint, point)) continue;
            cleaned.add(point);
            prevPoint = point;
        }
        return TextExtrude.removeRedundantPoints(cleaned);
    }

    private static List<Vector3d> removeRedundantPoints(List<Vector3d> points) {
        if (points.size() < 3) {
            return points;
        }
        ArrayList<Vector3d> result = new ArrayList<Vector3d>();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            Vector3d curr = points.get(i);
            result.add(curr);
        }
        return result;
    }

    private static boolean isNearlyEqual(Vector3d v1, Vector3d v2) {
        return v1.minus(v2).length() < 1.0E-4;
    }

    private static List<Vector3d> approximateCubicCurve(Vector3d start, Vector3d control1, Vector3d control2, Vector3d end) {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        for (double i = 1.0; i <= 3.0; i += 1.0) {
            double t = i / 3.0;
            double x = TextExtrude.cubicBezier(start.x, control1.x, control2.x, end.x, t);
            double y = TextExtrude.cubicBezier(start.y, control1.y, control2.y, end.y, t);
            points.add(Vector3d.xyz(x, y, 0.0));
        }
        return points;
    }

    private static List<Vector3d> approximateQuadCurve(Vector3d start, Vector3d control, Vector3d end) {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        for (double i = 1.0; i <= 3.0; i += 1.0) {
            double t = i / 3.0;
            double x = TextExtrude.quadBezier(start.x, control.x, end.x, t);
            double y = TextExtrude.quadBezier(start.y, control.y, end.y, t);
            points.add(Vector3d.xyz(x, y, 0.0));
        }
        return points;
    }

    private static double cubicBezier(double p0, double p1, double p2, double p3, double t) {
        double mt = 1.0 - t;
        return p0 * mt * mt * mt + 3.0 * p1 * mt * mt * t + 3.0 * p2 * mt * t * t + p3 * t * t * t;
    }

    private static double quadBezier(double p0, double p1, double p2, double t) {
        double mt = 1.0 - t;
        return p0 * mt * mt + 2.0 * p1 * mt * t + p2 * t * t;
    }

    class LineSegment {
        private boolean hole;
        private List<Vector3d> points;
        private Path path;
        private Vector3d origen;
        private List<LineSegment> holes = new ArrayList<LineSegment>();
        private String letter;

        public LineSegment(String text) {
            this.letter = text;
        }

        public String getLetter() {
            return this.letter;
        }

        public void setLetter(String letter) {
            this.letter = letter;
        }

        public boolean isHole() {
            return this.hole;
        }

        public void setHole(boolean isHole) {
            this.hole = isHole;
        }

        public List<Vector3d> getPoints() {
            return this.points;
        }

        public void setPoints(List<Vector3d> points) {
            this.points = points;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public Vector3d getOrigen() {
            return this.origen;
        }

        public void setOrigen(Vector3d origen) {
            this.origen = origen;
        }

        public List<LineSegment> getHoles() {
            return this.holes;
        }

        public void setHoles(List<LineSegment> holes) {
            this.holes = holes;
        }

        public void addHole(LineSegment hole) {
            this.holes.add(hole);
        }

        public String toString() {
            return "Poly{points=" + this.points + ", path=" + this.path + ", origen=" + (Object)((Object)this.origen) + ", holes=" + this.holes + '}';
        }
    }
}

