/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.imagej;

import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;

public class STLLoader {
    String line;
    BufferedReader in;
    private ArrayList<Vector3d> vertices = new ArrayList();
    private Vector3d normal = new Vector3d(0.0, 0.0, 0.0);
    private FileInputStream fis;
    private int triangles;

    public ArrayList<Vector3d> parse(File f) throws IOException {
        this.vertices.clear();
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            String[] words = line.trim().split("\\s+");
            if (line.indexOf(0) < 0 && words[0].equalsIgnoreCase("solid")) {
                this.parseAscii(f);
                br.close();
                return this.vertices;
            }
            br.close();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        FileInputStream fs = new FileInputStream(f);
        byte[] buffer = new byte[84];
        fs.read(buffer, 0, 84);
        fs.close();
        this.triangles = (buffer[83] & 0xFF) << 24 | (buffer[82] & 0xFF) << 16 | (buffer[81] & 0xFF) << 8 | buffer[80] & 0xFF;
        if ((f.length() - 84L) / 50L == (long)this.triangles) {
            this.parseBinary(f);
            return this.vertices;
        }
        return this.vertices;
    }

    private void parseAscii(File f) {
        try {
            this.in = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.vertices = new ArrayList();
        try {
            while ((this.line = this.in.readLine()) != null) {
                String[] numbers = this.line.trim().split("\\s+");
                if (numbers[0].equals("vertex")) {
                    double x = this.parseDouble(numbers[1]);
                    double y = this.parseDouble(numbers[2]);
                    double z = this.parseDouble(numbers[3]);
                    Vector3d vertex = new Vector3d(x, y, z);
                    this.vertices.add(vertex);
                    continue;
                }
                if (!numbers[0].equals("facet") || !numbers[1].equals("normal")) continue;
                this.normal.x = this.parseDouble(numbers[2]);
                this.normal.y = this.parseDouble(numbers[3]);
                this.normal.z = this.parseDouble(numbers[4]);
            }
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void parseBinary(File f) {
        this.vertices = new ArrayList();
        try {
            this.fis = new FileInputStream(f);
            for (int h = 0; h < 84; ++h) {
                this.fis.read();
            }
            for (int t = 0; t < this.triangles; ++t) {
                byte[] tri = new byte[50];
                for (int tb = 0; tb < 50; ++tb) {
                    tri[tb] = (byte)this.fis.read();
                }
                this.normal.x = this.leBytesToFloat(tri[0], tri[1], tri[2], tri[3]);
                this.normal.y = this.leBytesToFloat(tri[4], tri[5], tri[6], tri[7]);
                this.normal.z = this.leBytesToFloat(tri[8], tri[9], tri[10], tri[11]);
                for (int i = 0; i < 3; ++i) {
                    int j = i * 12 + 12;
                    double px = this.leBytesToFloat(tri[j], tri[j + 1], tri[j + 2], tri[j + 3]);
                    double py = this.leBytesToFloat(tri[j + 4], tri[j + 5], tri[j + 6], tri[j + 7]);
                    double pz = this.leBytesToFloat(tri[j + 8], tri[j + 9], tri[j + 10], tri[j + 11]);
                    Vector3d p = new Vector3d(px, py, pz);
                    this.vertices.add(p);
                }
            }
            this.fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double parseDouble(String string) throws ParseException {
        return Double.parseDouble(string);
    }

    private double leBytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        return Float.intBitsToFloat((b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF);
    }
}

