/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.svg;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.JavaFXInitializer;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Slice;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SVGExporter {
    private String footer = "</svg>";
    private String section = "";
    private static final double Scale = 3.543307;
    private static final double VueBoxSize = 100.0;
    private int colorTicker = 0;
    public static List<String> colorNames = Arrays.asList("crimson", "gray", "darkmagenta", "darkolivegreen", "darkgreen", "darkblue", "deeppink", "chartreuse", "green", "orange", "lime", "black", "tomato");
    double[] min = new double[]{0.0, 0.0};
    double[] max = new double[]{100.0, 100.0};
    private ArrayList<String> polylines = new ArrayList();
    private ArrayList<String> groups = new ArrayList();
    private ArrayList<String> layers = new ArrayList();
    private int layerCounter = 1;
    private int groupCounter = 1;
    private int lineCounter = 0;
    private String name = "";

    public String make() {
        this.makeLayer();
        String output = "";
        for (String s : this.layers) {
            output = output + s + "\n";
        }
        double totalX = Math.abs(this.max[0]) + Math.abs(this.min[0]);
        double totalY = Math.abs(this.max[1]) + Math.abs(this.min[1]);
        double totalXmm = totalX / 3.543307;
        double totalYmm = totalY / 3.543307;
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<svg    xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\"\n viewBox=\"0 0 " + totalX + " " + totalY + "\"\n id=\"svg2\" \n width=\"" + totalXmm + "mm\"\n height=\"" + totalYmm + "mm\">\n";
        header = header + " <defs  \n  id=\"defs4\" /> \n <sodipodi:namedview \n  id=\"base\" \n  pagecolor=\"#ffffff\" \n  bordercolor=\"#666666\" \n  borderopacity=\"1.0\" \n inkscape:pageopacity=\"0.0\" \n inkscape:pageshadow=\"2\" \n  inkscape:document-units=\"mm\" \n  inkscape:current-layer=\"layer1\" \n showgrid=\"false\" \n  />\n";
        output = output + this.footer;
        output = header + output;
        return output;
    }

    private void colorTick() {
        ++this.colorTicker;
        if (this.colorTicker == colorNames.size()) {
            this.colorTicker = 0;
        }
        this.makeLayer();
    }

    public void makeGroup() {
        if (this.polylines.size() == 0) {
            return;
        }
        String groupsLine = "<g\nid=\"g37" + this.groupCounter + "\">\n";
        for (String p : this.polylines) {
            groupsLine = groupsLine + p + "\n";
        }
        groupsLine = groupsLine + "</g>";
        ++this.groupCounter;
        this.groups.add(groupsLine);
        this.polylines.clear();
    }

    private void makeLayer() {
        this.makeGroup();
        String groupsLine = "<g\ninkscape:label=\"" + this.name + "Slice " + this.layerCounter + "\"\ninkscape:groupmode=\"layer\" \nid=\"layer" + this.layerCounter + "\" \n>";
        for (String p : this.groups) {
            groupsLine = groupsLine + p + "\n";
        }
        groupsLine = groupsLine + "</g>";
        ++this.layerCounter;
        this.layers.add(groupsLine);
        this.groups.clear();
    }

    private void toPolyLine(Polygon p) {
        String color = colorNames.get(this.colorTicker);
        String section = "  <polyline points=\"";
        for (Vertex v : p.getVertices()) {
            Vector3d position = v.pos.transformed(new Transform().rotX(180.0));
            double x = position.x * 3.543307;
            double y = position.y * 3.543307 + 100.0;
            section = section + x + "," + y + " ";
        }
        Vector3d position = p.getVertices().get((int)0).pos.transformed(new Transform().rotX(180.0));
        double x = position.x * 3.543307;
        double y = position.y * 3.543307 + 100.0;
        section = section + x + "," + y + " ";
        section = section + "\" \nstroke=\"" + color + "\" \nstroke-width=\"1\" \nfill=\"none\"\nid=\"line" + this.lineCounter++ + "\" />\n";
        this.polylines.add(section);
    }

    public static void export(List<Polygon> polygons, File defaultDir, boolean groupAll) throws IOException {
        SVGExporter svg = new SVGExporter();
        for (Polygon p : polygons) {
            svg.toPolyLine(p);
            if (groupAll) continue;
            svg.colorTick();
        }
        SVGExporter.write(svg.make(), defaultDir);
    }

    private static void write(String output, File defaultDir) throws IOException {
        if (!defaultDir.exists()) {
            defaultDir.createNewFile();
        }
        FileWriter fw = new FileWriter(defaultDir.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(output);
        bw.close();
    }

    public static void export(CSG currentCsg, File defaultDir) throws IOException {
        SVGExporter svg = new SVGExporter();
        SVGExporter.addCsg(currentCsg, svg);
        SVGExporter.write(svg.make(), defaultDir);
    }

    public static void export(List<CSG> currentCsg, File defaultDir) throws IOException {
        try {
            JavaFXInitializer.go();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!JavaFXInitializer.errored) {
            SVGExporter svg = new SVGExporter();
            int i = 0;
            long start = System.currentTimeMillis();
            for (CSG tmp : currentCsg) {
                SVGExporter.addCsg(tmp, svg);
                ++i;
            }
            SVGExporter.write(svg.make(), defaultDir);
        }
    }

    private static void addCsg(CSG currentCsg, SVGExporter svg) throws IOException {
        svg.setName(currentCsg.getName());
        for (Transform slicePlane : currentCsg.getSlicePlanes()) {
            List<Polygon> polygons = Slice.slice(currentCsg.prepMfg(), slicePlane, 0.0);
            for (Polygon p : polygons) {
                svg.toPolyLine(p);
            }
            svg.colorTick();
        }
    }

    private void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }
}

