/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.CSGRemoteOperation;
import eu.mihosoft.vrl.v3d.Cube;
import java.io.File;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

class CSGClient {
    private static CSGClient client = null;
    private String hostname;
    private int port;
    private String key = null;
    private static boolean serverCall = false;

    public CSGClient(String hostname, int port, File f) throws Exception {
        this.hostname = hostname;
        this.port = port;
        if (f == null) {
            throw new NullPointerException("API key file can not be null");
        }
        if (f.exists()) {
            this.key = Files.readAllLines(f.toPath()).toArray(new String[0])[0];
        } else {
            System.err.println("Error! API key file does not exist! " + f.getAbsolutePath());
        }
        if (this.key == null || this.key.length() == 0) {
            System.err.println("Key error, no key provided by " + f.getAbsolutePath());
        } else {
            System.out.println("API Key Loaded from " + f.getAbsolutePath());
        }
        Socket socket = new Socket(hostname, port);
        socket.close();
    }

    public ArrayList<CSG> union(List<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.UNION);
    }

    public ArrayList<CSG> difference(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.DIFFERENCE);
    }

    public ArrayList<CSG> intersect(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.INTERSECT);
    }

    public ArrayList<CSG> minkowskiHullShape(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.minkowskiHullShape);
    }

    public ArrayList<CSG> triangulate(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.TRIANGULATE);
    }

    /*
     * Exception decompiling
     */
    private ArrayList<CSG> performOperation(List<CSG> csgList, CSGRemoteOperation operation) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getServerInfo() {
        return this.hostname + ":" + this.port + " (connected: )";
    }

    public static boolean start(String hostname, int port, File f) throws Exception {
        if (CSGClient.getClient() != null) {
            return false;
        }
        CSGClient.setClient(new CSGClient(hostname, port, f));
        return true;
    }

    public static void close() {
        client = null;
    }

    public static boolean isRunning() {
        if (CSGClient.isServerCall()) {
            return false;
        }
        return CSGClient.getClient() != null;
    }

    public static void main(String[] args) {
        String hostname = "192.168.10.125";
        int port = 3742;
        try {
            File f = new File("/opt/File.txt");
            CSGClient.start(hostname, port, f);
            CSG.setMinPolygonsForOffloading(4);
            System.out.println("Client info: " + CSGClient.getClient().getServerInfo());
            CSG a = new Cube(20.0).toCSG();
            CSG b = new Cube(20.0, 30.0, 5.0).toCSG();
            CSG c = new Cube(10.0, 10.0, 10.0).toCSG();
            CSG u = CSG.unionAll(a, b, c);
            CSG d = a.difference(b);
            CSG t = d.triangulate(true);
            ArrayList<CSG> arrayList = a.minkowskiHullShape(b);
        }
        catch (Exception e) {
            System.err.println("Communication error: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("\nClient example completed.");
    }

    public static CSGClient getClient() {
        return client;
    }

    private static void setClient(CSGClient client) {
        CSGClient.client = client;
    }

    public static boolean isServerCall() {
        return serverCall;
    }

    public static void setServerCall(boolean serverCall) {
        CSGClient.serverCall = serverCall;
    }
}

