/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.CSGClient;
import eu.mihosoft.vrl.v3d.CSGRequest;
import eu.mihosoft.vrl.v3d.CSGResponse;
import eu.mihosoft.vrl.v3d.ServerActionState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;

class CSGServerHandler
implements Runnable {
    private SSLSocket clientSocket;
    private String[] APIKEY = null;

    public CSGServerHandler(SSLSocket socket, String[] lines) {
        this.clientSocket = socket;
        this.APIKEY = lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (ObjectInputStream ois = new ObjectInputStream(this.clientSocket.getInputStream());
             ObjectOutputStream oos = new ObjectOutputStream(this.clientSocket.getOutputStream());){
            System.out.println("Client connected: " + this.clientSocket.getRemoteSocketAddress());
            CSGRequest request = (CSGRequest)ois.readObject();
            System.out.println("Received request: " + (Object)((Object)request.getOperation()));
            boolean APIPass = true;
            String apiKey2 = request.getAPIKey();
            if (this.getAPIKEYs() != null) {
                APIPass = false;
                if (apiKey2 != null) {
                    for (int i = 0; i < this.getAPIKEYs().length; ++i) {
                        if (!apiKey2.contentEquals(this.getAPIKEYs()[i])) continue;
                        APIPass = true;
                        System.out.println("API Key Match");
                        break;
                    }
                }
            }
            CSGResponse response = null;
            if (APIPass) {
                try {
                    response = this.processCSGRequest(request);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    response = new CSGResponse();
                    response.setState(ServerActionState.ERROR);
                    response.setMessage(t);
                }
            } else {
                response = new CSGResponse();
                response.setState(ServerActionState.BADAPIKEY);
                response.setMessage("Your API key " + apiKey2 + " Does not match server's key");
            }
            oos.writeObject(response);
            oos.flush();
            System.out.println("Sent response: " + response);
        }
        catch (IOException | ClassNotFoundException e) {
            System.err.println("client disconnected: ");
        }
        finally {
            this.close();
        }
    }

    private void close() {
        System.out.println("Closing Handler socket");
        try {
            if (!this.clientSocket.isClosed()) {
                this.clientSocket.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error closing client socket: " + e.getMessage());
        }
    }

    private CSGResponse processCSGRequest(CSGRequest request) {
        ArrayList<CSG> back = new ArrayList<CSG>();
        CSGClient.setServerCall(true);
        try {
            switch (request.getOperation()) {
                case DIFFERENCE: {
                    CSG first = request.getCsgList().remove(0);
                    back.add(first.difference(request.getCsgList()));
                    break;
                }
                case INTERSECT: {
                    CSG f = request.getCsgList().remove(0);
                    back.add(f.intersect(request.getCsgList()));
                    break;
                }
                case TRIANGULATE: {
                    CSG.setPreventNonManifoldTriangles(true);
                    for (CSG c : request.getCsgList()) {
                        back.add(c.triangulate(true));
                    }
                    break;
                }
                case UNION: {
                    back.add(CSG.unionAll(request.getCsgList()));
                    break;
                }
                case minkowskiHullShape: {
                    CSG m1 = request.getCsgList().remove(0);
                    CSG t = request.getCsgList().remove(0);
                    back.addAll(m1.minkowskiHullShape(t));
                    break;
                }
                default: {
                    throw new RuntimeException("No Such Operation " + (Object)((Object)request.getOperation()));
                }
            }
        }
        finally {
            CSGClient.setServerCall(false);
        }
        return new CSGResponse(back, request.getOperation());
    }

    public String[] getAPIKEYs() {
        return this.APIKEY;
    }

    public void setAPIKEYs(String[] aPIKEY) {
        this.APIKEY = aPIKEY;
    }
}

