/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.imagej.STLLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;

public class STL {
    public static CSG file(URL path) throws IOException, URISyntaxException {
        URI uri = path.toURI();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        FileSystem zipfs = FileSystems.newFileSystem(uri, env);
        Path myFolderPath = Paths.get(uri);
        return STL.file(myFolderPath);
    }

    public static CSG file(Path path) throws IOException {
        STLLoader loader = new STLLoader();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (Vertex p : loader.parse(path.toFile())) {
            vertices.add(p);
            if (vertices.size() != 3) continue;
            try {
                Plane pl = new Plane(((Vertex)vertices.get((int)0)).normal, vertices);
                polygons.add(new Polygon(vertices, null, false, pl));
            }
            catch (RuntimeException ex) {
                System.err.println("Pruning polygon loading STL::file");
            }
            vertices = new ArrayList();
        }
        return CSG.fromPolygons(new PropertyStorage(), polygons);
    }
}

