/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Debug3dProvider;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.IPolygonRepairTool;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.scene.paint.Color;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.polygon.ConstrainedDelaunayTriangulator;

public class PolygonUtil {
    private static final double triangleScale = 1000.0;
    private static IPolygonRepairTool repair = concave1 -> {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList toRemove = new ArrayList();
        List<Vertex> v = concave1.getVertices();
        ArrayList<Vertex> modifiable = new ArrayList<Vertex>();
        modifiable.addAll(v);
        for (int i = 0; i < v.size(); ++i) {
            Edge e = new Edge(v.get(i), v.get((i + 1) % v.size()));
            double l = e.length();
            if (l < 1.0E-4) {
                System.out.println("Length of edge is " + l);
            }
            edges.add(e);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int threadCount = 64;
        if (threadCount >= edges.size()) {
            threadCount = 1;
        }
        int perThread = edges.size() / threadCount;
        for (int k = 0; k < threadCount; ++k) {
            int start = k * perThread;
            Thread t = new Thread(() -> {
                for (int i = start; i < edges.size() && i <= start + perThread; ++i) {
                    boolean c;
                    Edge test = (Edge)edges.get(i);
                    if (i < edges.size() - 1 && (c = test.colinear((Edge)edges.get(i + 1)))) {
                        System.out.println("Colinear edged found " + i);
                    }
                    if (start == 0) {
                        CSG.getProgressMoniter().progressUpdate(i * (edges.size() / perThread), edges.size(), " Repairing intersecting polygon (Hint in Inkscape->Path->Simplify): found # " + toRemove.size(), null);
                    }
                    for (int j = 0; j < edges.size(); ++j) {
                        boolean c2;
                        if (i == j) continue;
                        Edge test2 = (Edge)edges.get(j);
                        boolean b = Edge.falseBoundaryEdgeSharedWithOtherEdge(test, test2);
                        Optional<Vector3d> cross = test.getCrossingPoint(test2);
                        boolean bl = c2 = cross.isPresent() && i < j;
                        if (c2) {
                            for (int x = i + 1; x < j; ++x) {
                                toRemove.add(v.get(x));
                            }
                        }
                        if (!b) continue;
                        System.out.println("\n\nFalse Boundary " + test + " \n " + test2);
                        try {
                            Vertex vBad = test.getCommonPoint(test2);
                            toRemove.add(vBad);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Vertex vr : toRemove) {
            modifiable.remove(vr);
        }
        return new Polygon(modifiable, concave1.getStorage(), false, concave1.getPlane());
    };

    public static boolean doPolygonsOverlap(Polygon polygon1, Polygon polygon2) {
        if (!PolygonUtil.areCoplanar(polygon1, polygon2)) {
            return PolygonUtil.checkEdgeFaceIntersections(polygon1, polygon2);
        }
        return PolygonUtil.checkCoplanarIntersection(polygon1, polygon2);
    }

    private static boolean areCoplanar(Polygon polygon1, Polygon polygon2) {
        boolean normalsParallel;
        Vector3d normal2;
        Vector3d normal1 = polygon1.getPlane().getNormal();
        double dotProduct = normal1.dot(normal2 = polygon2.getPlane().getNormal());
        boolean bl = normalsParallel = Math.abs(Math.abs(dotProduct) - 1.0) < Plane.getEPSILON();
        if (!normalsParallel) {
            return false;
        }
        Vector3d point2 = polygon2.getVertices().get((int)0).pos;
        Vector3d point1 = polygon1.getVertices().get((int)0).pos;
        double distance = normal1.dot(point2.minus(point1));
        return Math.abs(distance) < Plane.getEPSILON();
    }

    private static boolean checkCoplanarIntersection(Polygon polygon1, Polygon polygon2) {
        Vector3d normal = polygon1.getPlane().getNormal();
        int dominantAxis = PolygonUtil.getDominantAxis(normal);
        List<Vector3d> projected1 = PolygonUtil.projectPolygonVertices(polygon1, dominantAxis);
        List<Vector3d> projected2 = PolygonUtil.projectPolygonVertices(polygon2, dominantAxis);
        for (int i = 0; i < projected1.size(); ++i) {
            Vector3d p1 = projected1.get(i);
            Vector3d p2 = projected1.get((i + 1) % projected1.size());
            for (int j = 0; j < projected2.size(); ++j) {
                Vector3d q2;
                Vector3d q1 = projected2.get(j);
                if (!PolygonUtil.doLineSegmentsIntersect(p1, p2, q1, q2 = projected2.get((j + 1) % projected2.size()), dominantAxis)) continue;
                return true;
            }
        }
        return PolygonUtil.isPointInPolygon(projected1.get(0), projected2, dominantAxis) || PolygonUtil.isPointInPolygon(projected2.get(0), projected1, dominantAxis);
    }

    private static List<Vector3d> projectPolygonVertices(Polygon polygon, int dominantAxis) {
        ArrayList<Vector3d> projectedVertices = new ArrayList<Vector3d>();
        for (Vertex vertex : polygon.getVertices()) {
            Vector3d pos = vertex.pos;
            projectedVertices.add(pos);
        }
        return projectedVertices;
    }

    private static int getDominantAxis(Vector3d vector) {
        double absX = Math.abs(vector.x);
        double absY = Math.abs(vector.y);
        double absZ = Math.abs(vector.z);
        if (absX >= absY && absX >= absZ) {
            return 0;
        }
        if (absY >= absX && absY >= absZ) {
            return 1;
        }
        return 2;
    }

    private static double[] getNonDominantCoordinates(Vector3d v, int dominantAxis) {
        switch (dominantAxis) {
            case 0: {
                return new double[]{v.y, v.z};
            }
            case 1: {
                return new double[]{v.x, v.z};
            }
        }
        return new double[]{v.x, v.y};
    }

    private static boolean doLineSegmentsIntersect(Vector3d p1, Vector3d p2, Vector3d q1, Vector3d q2, int dominantAxis) {
        double[] p1Coords = PolygonUtil.getNonDominantCoordinates(p1, dominantAxis);
        double[] p2Coords = PolygonUtil.getNonDominantCoordinates(p2, dominantAxis);
        double[] q1Coords = PolygonUtil.getNonDominantCoordinates(q1, dominantAxis);
        double[] q2Coords = PolygonUtil.getNonDominantCoordinates(q2, dominantAxis);
        int o1 = PolygonUtil.orientation(p1Coords, p2Coords, q1Coords);
        int o2 = PolygonUtil.orientation(p1Coords, p2Coords, q2Coords);
        int o3 = PolygonUtil.orientation(q1Coords, q2Coords, p1Coords);
        int o4 = PolygonUtil.orientation(q1Coords, q2Coords, p2Coords);
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && PolygonUtil.onSegment(p1Coords, q1Coords, p2Coords)) {
            return true;
        }
        if (o2 == 0 && PolygonUtil.onSegment(p1Coords, q2Coords, p2Coords)) {
            return true;
        }
        if (o3 == 0 && PolygonUtil.onSegment(q1Coords, p1Coords, q2Coords)) {
            return true;
        }
        return o4 == 0 && PolygonUtil.onSegment(q1Coords, p2Coords, q2Coords);
    }

    private static int orientation(double[] p, double[] q, double[] r) {
        double val = (q[1] - p[1]) * (r[0] - q[0]) - (q[0] - p[0]) * (r[1] - q[1]);
        if (Math.abs(val) < 1.0E-10) {
            return 0;
        }
        return val > 0.0 ? 1 : 2;
    }

    private static boolean onSegment(double[] p, double[] q, double[] r) {
        return q[0] <= Math.max(p[0], r[0]) && q[0] >= Math.min(p[0], r[0]) && q[1] <= Math.max(p[1], r[1]) && q[1] >= Math.min(p[1], r[1]);
    }

    private static boolean isPointInPolygon(Vector3d point, List<Vector3d> polygon, int dominantAxis) {
        double[] pointCoords = PolygonUtil.getNonDominantCoordinates(point, dominantAxis);
        boolean inside = false;
        int n = polygon.size();
        int i = 0;
        int j = n - 1;
        while (i < n) {
            double[] jCoords;
            double[] iCoords = PolygonUtil.getNonDominantCoordinates(polygon.get(i), dominantAxis);
            if (iCoords[1] > pointCoords[1] != (jCoords = PolygonUtil.getNonDominantCoordinates(polygon.get(j), dominantAxis))[1] > pointCoords[1] && pointCoords[0] < (jCoords[0] - iCoords[0]) * (pointCoords[1] - iCoords[1]) / (jCoords[1] - iCoords[1]) + iCoords[0]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    private static boolean checkEdgeFaceIntersections(Polygon polygon1, Polygon polygon2) {
        List<Vertex> vertices1 = polygon1.getVertices();
        for (int i = 0; i < vertices1.size(); ++i) {
            Vector3d v1 = vertices1.get((int)i).pos;
            Vector3d v2 = vertices1.get((int)((i + 1) % vertices1.size())).pos;
            if (!PolygonUtil.doesLineIntersectPolygon(v1, v2, polygon2)) continue;
            return true;
        }
        List<Vertex> vertices2 = polygon2.getVertices();
        for (int i = 0; i < vertices2.size(); ++i) {
            Vector3d v1 = vertices2.get((int)i).pos;
            Vector3d v2 = vertices2.get((int)((i + 1) % vertices2.size())).pos;
            if (!PolygonUtil.doesLineIntersectPolygon(v1, v2, polygon1)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesLineIntersectPolygon(Vector3d lineStart, Vector3d lineEnd, Polygon polygon) {
        Vector3d normal = polygon.getPlane().getNormal();
        Vector3d polygonPoint = polygon.getVertices().get((int)0).pos;
        Vector3d lineDirection = lineEnd.minus(lineStart);
        double denominatorTerm = normal.dot(lineDirection);
        if (Math.abs(denominatorTerm) < 1.0E-10) {
            return false;
        }
        double t = normal.dot(polygonPoint.minus(lineStart)) / denominatorTerm;
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        Vector3d intersectionPoint = lineStart.plus(lineDirection.times(t));
        int dominantAxis = PolygonUtil.getDominantAxis(normal);
        ArrayList<Vector3d> polygonVertices = new ArrayList<Vector3d>();
        for (Vertex vertex : polygon.getVertices()) {
            polygonVertices.add(vertex.pos);
        }
        return PolygonUtil.isPointInPolygon(intersectionPoint, polygonVertices, dominantAxis);
    }

    private PolygonUtil() {
        throw new AssertionError("Don't instantiate me!", null);
    }

    public static List<Polygon> concaveToConvex(Polygon incoming) {
        return PolygonUtil.concaveToConvex(incoming, true);
    }

    public static List<Polygon> concaveToConvex(Polygon incoming, boolean toCCW) {
        boolean cw;
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        if (incoming == null) {
            return result;
        }
        if (incoming.getVertices().size() < 3) {
            return result;
        }
        Polygon concave = incoming;
        Vector3d normalOfPlane = incoming.getPlane().getNormal();
        boolean reorent = normalOfPlane.z < 1.0 - Plane.getEPSILON();
        Transform orentationInv = null;
        boolean debug = false;
        Vector3d normal = concave.getPlane().getNormal().clone();
        if (reorent) {
            double degreesToRotate = Math.toDegrees(Math.atan2(normalOfPlane.x, normalOfPlane.z));
            Transform orentation = new Transform().roty(degreesToRotate);
            Polygon tmp = incoming.transformed(orentation);
            Vector3d tmpnorm = tmp.getPlane().getNormal();
            double degreesToRotate2 = 90.0 + Math.toDegrees(Math.atan2(tmpnorm.z, tmpnorm.y));
            Transform orentation2 = orentation.rotx(degreesToRotate2);
            if (debug) {
                Debug3dProvider.clearScreen();
                Debug3dProvider.addObject(incoming);
            }
            concave = incoming.transformed(orentation2);
            orentationInv = orentation2.inverse();
            if (concave.getPlane().getNormal().z < 0.0) {
                Transform orentation3 = orentation2.rotx(180);
                concave = incoming.transformed(orentation3);
                orentationInv = orentation3.inverse();
            }
            Polygon transformed = concave.transformed(orentationInv);
            PolygonUtil.checkForValidPolyOrentation(normal, transformed);
        }
        boolean bl = cw = !Extrude.isCCW(concave);
        if (cw && toCCW) {
            concave = Extrude.toCCW(concave);
        }
        if (debug) {
            Debug3dProvider.clearScreen();
            Debug3dProvider.addObject(concave);
        }
        double zplane = concave.getVertices().get((int)0).pos.z;
        try {
            PolygonUtil.makeTriangles(concave, cw, result, zplane, normal, debug, orentationInv, reorent, incoming.getColor());
        }
        catch (IllegalStateException ex) {
            int start = concave.getVertices().size();
            concave = PolygonUtil.repairOverlappingEdges(concave);
            int end = concave.getVertices().size();
            PolygonUtil.makeTriangles(concave, cw, result, zplane, normal, debug, orentationInv, reorent, incoming.getColor());
            System.out.println("Repaired the polygon! pruned " + (start - end));
        }
        return result;
    }

    private static Polygon repairOverlappingEdges(Polygon concave) {
        return PolygonUtil.getRepair().repairOverlappingEdges(concave);
    }

    private static Polygon checkForValidPolyOrentation(Vector3d normal, Polygon poly) {
        double d;
        Vector3d normal2 = poly.getPlane().getNormal();
        Vector3d minus = normal.minus(normal2);
        double length = minus.length();
        if (length > (d = 0.001) * 10.0 && length < 2.0 - d) {
            List<Vector3d> points = poly.getPoints();
            ArrayList<Vector3d> r = new ArrayList<Vector3d>(points);
            Collections.reverse(r);
            Polygon fromPoints = Polygon.fromPoints(r);
            double l = normal.minus(fromPoints.getPlane().getNormal()).length();
            if (!(l > d * 10.0) || !(l < 2.0 - d)) {
                poly = fromPoints;
            }
        }
        return poly;
    }

    private static Geometry makeTriangles(Polygon concave, boolean cw, List<Polygon> result, double zplane, Vector3d normal, boolean debug, Transform orentationInv, boolean reorent, Color color) {
        Polygon toTri = concave;
        Coordinate[] coordinates = new Coordinate[toTri.getVertices().size() + 1];
        for (int i = 0; i < toTri.getVertices().size(); ++i) {
            Vector3d v = toTri.getVertices().get((int)i).pos;
            coordinates[i] = new Coordinate(v.x * 1000.0, v.y * 1000.0, v.z * 1000.0);
        }
        Vector3d v = toTri.getVertices().get((int)0).pos;
        coordinates[toTri.getVertices().size()] = new Coordinate(v.x * 1000.0, v.y * 1000.0, v.z * 1000.0);
        org.locationtech.jts.geom.Polygon geom = new GeometryFactory().createPolygon(coordinates);
        Geometry triangles = ConstrainedDelaunayTriangulator.triangulate((Geometry)geom);
        ArrayList<Vertex> triPoints = new ArrayList<Vertex>();
        for (int i = 0; i < triangles.getNumGeometries(); ++i) {
            Geometry tri = triangles.getGeometryN(i);
            Coordinate[] coords = tri.getCoordinates();
            int counter = 0;
            if (coords.length != 4) {
                throw new RuntimeException("Failed to triangulate");
            }
            for (int j = 0; j < 3; ++j) {
                Coordinate tp = coords[j];
                Vector3d pos = new Vector3d(tp.getX() / 1000.0, tp.getY() / 1000.0, zplane);
                triPoints.add(new Vertex(pos, normal));
                if (counter == 2) {
                    boolean b;
                    if (!cw) {
                        Collections.reverse(triPoints);
                    }
                    Polygon poly = new Polygon(triPoints, concave.getStorage(), true, concave.getPlane());
                    poly.getPlane().setNormal(concave.getPlane().getNormal());
                    boolean bl = b = !Extrude.isCCW(poly);
                    if (cw != b) {
                        Collections.reverse(triPoints);
                        poly = new Polygon(triPoints, concave.getStorage(), true, concave.getPlane());
                        boolean bl2 = b = !Extrude.isCCW(poly);
                        if (cw != b) {
                            // empty if block
                        }
                    }
                    if (debug) {
                        Debug3dProvider.addObject(poly);
                    }
                    if (reorent) {
                        poly = poly.transform(orentationInv);
                        poly = PolygonUtil.checkForValidPolyOrentation(normal, poly);
                    }
                    poly.setColor(color);
                    result.add(poly);
                    counter = 0;
                    triPoints = new ArrayList();
                    continue;
                }
                ++counter;
            }
        }
        return triangles;
    }

    public static IPolygonRepairTool getRepair() {
        return repair;
    }

    public static void setRepair(IPolygonRepairTool repair) {
        PolygonUtil.repair = repair;
    }
}

