/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.List;

public class Isosceles
extends Primitive {
    double w;
    double h;
    double d;
    private final PropertyStorage properties = new PropertyStorage();

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public Isosceles(double w, double h, double d) {
        this.w = w;
        this.h = h;
        this.d = d;
    }

    @Override
    public List<Polygon> toPolygons() {
        if (this.w <= 0.0) {
            throw new NumberFormatException("w can not be negative");
        }
        if (this.h <= 0.0) {
            throw new NumberFormatException("h can not be negative");
        }
        if (this.d <= 0.0) {
            throw new NumberFormatException("d can not be negative");
        }
        CSG polygon = Extrude.points(new Vector3d(0.0, 0.0, this.w), new Vector3d(0.0, 0.0), new Vector3d(0.0, -this.h / 2.0), new Vector3d(this.d, 0.0), new Vector3d(0.0, this.h / 2.0)).roty(90).rotz(180);
        return polygon.getPolygons();
    }
}

