/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

class MouseBehaviorImpl1
implements EventHandler<MouseEvent> {
    private double anchorAngleX;
    private double anchorAngleY;
    private double anchorX;
    private double anchorY;
    private final Rotate rotateX = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
    private final Rotate rotateZ = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);
    private MouseButton btn;

    public MouseBehaviorImpl1(Node n, MouseButton btn) {
        n.getTransforms().addAll((Object[])new Transform[]{this.rotateX, this.rotateZ});
        this.btn = btn;
        if (btn == null) {
            this.btn = MouseButton.MIDDLE;
        }
    }

    public void handle(MouseEvent t) {
        if (!this.btn.equals((Object)t.getButton())) {
            return;
        }
        t.consume();
        if (MouseEvent.MOUSE_PRESSED.equals(t.getEventType())) {
            this.anchorX = t.getSceneX();
            this.anchorY = t.getSceneY();
            this.anchorAngleX = this.rotateX.getAngle();
            this.anchorAngleY = this.rotateZ.getAngle();
            t.consume();
        } else if (MouseEvent.MOUSE_DRAGGED.equals(t.getEventType())) {
            this.rotateZ.setAngle(this.anchorAngleY + (this.anchorX - t.getSceneX()) * 0.7);
            this.rotateX.setAngle(this.anchorAngleX - (this.anchorY - t.getSceneY()) * 0.7);
        }
    }
}

