/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import java.util.ArrayList;

public class Parabola {
    double Radius;
    double w;
    double a;
    double b;
    double FocalLength;
    boolean fromEq = true;

    private Parabola() {
    }

    private double computeY(double x) {
        if (this.fromEq) {
            return this.a * x * x + this.b * x;
        }
        return x * x / (this.FocalLength * 4.0);
    }

    public Parabola fromEquation(double Radius, double a, double b) {
        if (Radius <= 0.0) {
            throw new NumberFormatException("radius can not be negative");
        }
        this.Radius = Radius;
        if (Math.abs(a) == 0.0) {
            throw new RuntimeException("A value in parabola must be non zero");
        }
        this.a = a;
        this.b = b;
        this.fromEq = true;
        return this;
    }

    public Parabola fromFocalLength(double Radius, double Focus) {
        this.Radius = Radius;
        if (Math.abs(Focus) == 0.0) {
            throw new RuntimeException("A value in parabola must be non zero");
        }
        this.FocalLength = Focus;
        this.fromEq = false;
        return this;
    }

    public ArrayList<Vector3d> getpoints() {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        points.add(new Vector3d(0.0, this.computeY(this.Radius)));
        for (double i = 0.0; i <= 1.0; i += 0.05) {
            double x = this.Radius * i;
            double y = this.computeY(x);
            points.add(new Vector3d(x, y));
        }
        points.add(new Vector3d(this.Radius, this.computeY(this.Radius)));
        return points;
    }

    public static CSG coneByEquation(double Radius, double a, double b) {
        ArrayList<Vector3d> points = new Parabola().fromEquation(Radius, a, b).getpoints();
        ArrayList<Vector3d> pointsOut = new ArrayList<Vector3d>();
        for (double i = 0.0; i <= 360.0; i += 10.0) {
            Transform transform = new Transform().roty(i);
            for (Vector3d p : points) {
                pointsOut.add(p.transformed(transform));
            }
        }
        return HullUtil.hull(pointsOut);
    }

    public static CSG cone(double Radius, double height) {
        return Parabola.coneByHeight(Radius, height, 0.0).rotx(90).toZMin();
    }

    public static CSG cone(double Radius, double height, double b) {
        return Parabola.coneByHeight(Radius, height, b).rotx(90).toZMin();
    }

    public static CSG coneByHeight(double Radius, double height) {
        return Parabola.coneByHeight(Radius, height, 0.0);
    }

    public static CSG coneByHeight(double Radius, double height, double b) {
        double a = (height - b * Radius) / (Radius * Radius);
        ArrayList<Vector3d> points = new Parabola().fromEquation(Radius, a, b).getpoints();
        ArrayList<Vector3d> pointsOut = new ArrayList<Vector3d>();
        for (double i = 0.0; i <= 360.0; i += 10.0) {
            Transform transform = new Transform().roty(i);
            for (Vector3d p : points) {
                pointsOut.add(p.transformed(transform));
            }
        }
        return HullUtil.hull(pointsOut);
    }

    public static CSG coneByFocalLength(double Radius, double FocalLength) {
        ArrayList<Vector3d> points = new Parabola().fromFocalLength(Radius, FocalLength).getpoints();
        ArrayList<Vector3d> pointsOut = new ArrayList<Vector3d>();
        for (double i = 0.0; i <= 360.0; i += 10.0) {
            Transform transform = new Transform().roty(i);
            for (Vector3d p : points) {
                pointsOut.add(p.transformed(transform));
            }
        }
        return HullUtil.hull(pointsOut);
    }

    public static CSG extrudeByEquation(double Radius, double a, double b, double thickness) {
        return Extrude.points(new Vector3d(0.0, 0.0, thickness), new Parabola().fromEquation(Radius, a, b).getpoints());
    }
}

