/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import java.util.ArrayList;
import java.util.List;

public class Sphere
extends Primitive {
    private static final int NUM_SLICES = 16;
    private static final int NUM_STACKS = 8;
    private Vector3d center;
    private double radius;
    private int numSlices;
    private int numStacks;
    private final PropertyStorage properties = new PropertyStorage();

    public Sphere() {
        this.init();
    }

    public Sphere(double radius) {
        this.init();
        this.radius = radius;
    }

    public Sphere(LengthParameter size) {
        this(size.getMM());
        this.parametrics.add(size);
    }

    public Sphere(LengthParameter size, int numSlices, int numStacks) {
        this(size.getMM(), numSlices, numStacks);
        this.parametrics.add(size);
    }

    public Sphere(double radius, int numSlices, int numStacks) {
        this.init();
        this.radius = radius;
        this.setNumSlices(numSlices);
        this.setNumStacks(numStacks);
    }

    public Sphere(Vector3d center, double radius, int numSlices, int numStacks) {
        this.center = center;
        this.radius = radius;
        this.setNumSlices(numSlices);
        this.setNumStacks(numStacks);
    }

    private void init() {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.radius = 1.0;
        this.setNumSlices(16);
        this.setNumStacks(8);
    }

    private Vertex sphereVertex(Vector3d c, double r, double theta, double phi) {
        Vector3d dir = new Vector3d(Math.cos(theta *= Math.PI * 2) * Math.sin(phi *= Math.PI), Math.cos(phi), Math.sin(theta) * Math.sin(phi));
        return new Vertex(c.plus(dir.times(r)), dir);
    }

    @Override
    public List<Polygon> toPolygons() {
        if (this.radius <= 0.0) {
            throw new NumberFormatException("radius can not be negative");
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.getNumSlices(); ++i) {
            for (int j = 0; j < this.getNumStacks(); ++j) {
                ArrayList<Vertex> vertices = new ArrayList<Vertex>();
                vertices.add(this.sphereVertex(this.center, this.radius, (double)i / (double)this.getNumSlices(), (double)j / (double)this.getNumStacks()));
                if (j > 0) {
                    vertices.add(this.sphereVertex(this.center, this.radius, (double)(i + 1) / (double)this.getNumSlices(), (double)j / (double)this.getNumStacks()));
                }
                if (j < this.getNumStacks() - 1) {
                    vertices.add(this.sphereVertex(this.center, this.radius, (double)(i + 1) / (double)this.getNumSlices(), (double)(j + 1) / (double)this.getNumStacks()));
                }
                vertices.add(this.sphereVertex(this.center, this.radius, (double)i / (double)this.getNumSlices(), (double)(j + 1) / (double)this.getNumStacks()));
                polygons.add(new Polygon(vertices, this.getProperties()));
            }
        }
        return polygons;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public Sphere setCenter(Vector3d center) {
        this.center = center;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public Sphere setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public Sphere setNumSlices(int numSlices) {
        if (numSlices > 64) {
            System.out.println("Very large sphere! this may crash!");
        }
        this.numSlices = numSlices;
        return this;
    }

    public int getNumStacks() {
        return this.numStacks;
    }

    public Sphere setNumStacks(int numStacks) {
        if (numStacks > 32) {
            System.out.println("Very large sphere! this may crash!");
        }
        this.numStacks = numStacks;
        return this;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }
}

