/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Toroid
extends Primitive {
    private final PropertyStorage properties = new PropertyStorage();
    List<Polygon> polys;

    public Toroid(double innerRadius, double OuterRadius) {
        this(innerRadius, OuterRadius, 20, 16);
    }

    public Toroid(double innerRadius, double OuterRadius, int numSlices, int facets) {
        if (innerRadius < 0.0) {
            throw new RuntimeException("Inner radious must be positive");
        }
        if (innerRadius >= OuterRadius) {
            throw new RuntimeException("Outer radius must be larger than inner radius");
        }
        OuterRadius = innerRadius + (OuterRadius - innerRadius) / 2.0;
        double crossSecRad = OuterRadius - innerRadius;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        double f = facets;
        for (int i = 0; i < facets; ++i) {
            double index = i;
            double rad = index / f * 2.0 * Math.PI;
            double a = Math.cos(rad) * crossSecRad;
            double b = Math.sin(rad) * crossSecRad;
            vertices.add(new Vertex(new Vector3d(a, b), new Vector3d(-1.0, 0.0, 0.0)));
        }
        Polygon poly = new Polygon(vertices, this.properties);
        ArrayList<Polygon> slices = new ArrayList<Polygon>();
        for (int i = 0; i < numSlices; ++i) {
            double angle = 360.0 / (double)numSlices * (double)i;
            slices.add(poly.transformed(new Transform().movex(innerRadius + crossSecRad).roty(angle)));
        }
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        for (int j = 0; j < slices.size(); ++j) {
            int next = j + 1;
            if (next == slices.size()) {
                next = 0;
            }
            Polygon polygon1 = (Polygon)slices.get(j);
            Polygon polygon2 = (Polygon)slices.get(next);
            if (polygon1.getVertices().size() != polygon2.getVertices().size()) {
                throw new RuntimeException("These polygons do not match");
            }
            int numvertices = polygon1.getVertices().size();
            for (int i = 0; i < numvertices; ++i) {
                int nexti = (i + 1) % numvertices;
                Vector3d bottomV1 = polygon1.getVertices().get((int)i).pos;
                Vector3d topV1 = polygon2.getVertices().get((int)i).pos;
                Vector3d bottomV2 = polygon1.getVertices().get((int)nexti).pos;
                Vector3d topV2 = polygon2.getVertices().get((int)nexti).pos;
                List<Vector3d> pPoints = Arrays.asList(bottomV2, topV2, topV1, bottomV1);
                newPolygons.add(Polygon.fromPoints(pPoints, polygon1.getStorage()));
            }
            polygon2 = polygon2.flipped();
        }
        this.polys = newPolygons;
    }

    @Override
    public List<Polygon> toPolygons() {
        return this.polys;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }
}

