/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.TriangleMesh;

public class Validator {
    public void validate(Node node) {
        if (node instanceof MeshView) {
            MeshView meshView = (MeshView)node;
            this.validate(meshView.getMesh());
        } else if (node instanceof Parent) {
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                this.validate(child);
            }
        }
    }

    public void validate(Mesh mesh) {
        if (!(mesh instanceof TriangleMesh)) {
            throw new AssertionError((Object)("Mesh is not TriangleMesh: " + mesh.getClass() + ", mesh = " + mesh));
        }
        TriangleMesh tMesh = (TriangleMesh)mesh;
        int numPoints = tMesh.getPoints().size() / tMesh.getPointElementSize();
        int numTexCoords = tMesh.getTexCoords().size() / tMesh.getTexCoordElementSize();
        int numFaces = tMesh.getFaces().size() / tMesh.getFaceElementSize();
        if (numPoints == 0 || numPoints * tMesh.getPointElementSize() != tMesh.getPoints().size()) {
            throw new AssertionError((Object)("Points array size is not correct: " + tMesh.getPoints().size()));
        }
        if (numTexCoords == 0 || numTexCoords * tMesh.getTexCoordElementSize() != tMesh.getTexCoords().size()) {
            throw new AssertionError((Object)("TexCoords array size is not correct: " + tMesh.getPoints().size()));
        }
        if (numFaces == 0 || numFaces * tMesh.getFaceElementSize() != tMesh.getFaces().size()) {
            throw new AssertionError((Object)("Faces array size is not correct: " + tMesh.getPoints().size()));
        }
        if (numFaces != tMesh.getFaceSmoothingGroups().size() && tMesh.getFaceSmoothingGroups().size() > 0) {
            throw new AssertionError((Object)("FaceSmoothingGroups array size is not correct: " + tMesh.getPoints().size() + ", numFaces = " + numFaces));
        }
        ObservableFaceArray faces = tMesh.getFaces();
        for (int i = 0; i < faces.size(); i += 2) {
            int pIndex = faces.get(i);
            if (pIndex < 0 || pIndex > numPoints) {
                throw new AssertionError((Object)("Incorrect point index: " + pIndex + ", numPoints = " + numPoints));
            }
            int tcIndex = faces.get(i + 1);
            if (tcIndex < 0 || tcIndex > numTexCoords) {
                throw new AssertionError((Object)("Incorrect texCoord index: " + tcIndex + ", numTexCoords = " + numTexCoords));
            }
        }
    }
}

