/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.parametrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eu.mihosoft.vrl.v3d.parametrics.IParameterChanged;
import eu.mihosoft.vrl.v3d.parametrics.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CSGDatabaseInstance {
    ConcurrentHashMap<String, Parameter> database = null;
    File dbFile = null;
    final Type TT_mapStringString = new TypeToken<ConcurrentHashMap<String, Parameter>>(){}.getType();
    final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    final ConcurrentHashMap<String, CopyOnWriteArrayList<IParameterChanged>> parameterListeners = new ConcurrentHashMap();

    public CSGDatabaseInstance(File db) {
        this.dbFile = db;
    }

    public void set(String key, Parameter value) {
        this.getDatabase();
        this.getDatabase().put(key, value);
    }

    public Parameter get(String key) {
        Parameter ret = null;
        this.getDatabase();
        ret = this.getDatabase().get(key);
        return ret;
    }

    public void clear() {
        this.getDatabase();
        this.database.clear();
        this.parameterListeners.clear();
        this.saveDatabase();
    }

    public void addParameterListener(String key, IParameterChanged l) {
        CopyOnWriteArrayList<IParameterChanged> list = this.getParamListeners(key);
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameterListeners(String key) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<IParameterChanged>> concurrentHashMap = this.parameterListeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<IParameterChanged> back = this.parameterListeners.get(key);
            if (back == null) {
                back = new CopyOnWriteArrayList();
                this.parameterListeners.put(key, back);
            }
            back.clear();
        }
    }

    public void removeParameterListener(String key, IParameterChanged l) {
        if (this.parameterListeners.get(key) == null) {
            return;
        }
        CopyOnWriteArrayList<IParameterChanged> list = this.parameterListeners.get(key);
        if (list.contains(l)) {
            list.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyOnWriteArrayList<IParameterChanged> getParamListeners(String key) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<IParameterChanged>> concurrentHashMap = this.parameterListeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<IParameterChanged> back = this.parameterListeners.get(key);
            if (back == null) {
                back = new CopyOnWriteArrayList();
                this.parameterListeners.put(key, back);
            }
            return back;
        }
    }

    public void delete(String key) {
        this.getDatabase().remove(key);
    }

    private ConcurrentHashMap<String, Parameter> getDatabase() {
        if (this.database == null) {
            new Thread(){

                @Override
                public void run() {
                    block6: {
                        try {
                            String jsonString;
                            if (!CSGDatabaseInstance.this.getDbFile().exists()) {
                                CSGDatabaseInstance.this.setDatabase(new ConcurrentHashMap());
                                break block6;
                            }
                            FileInputStream in = null;
                            try {
                                in = FileUtils.openInputStream((File)CSGDatabaseInstance.this.getDbFile());
                                jsonString = IOUtils.toString((InputStream)in);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            ConcurrentHashMap tm = (ConcurrentHashMap)CSGDatabaseInstance.this.gson.fromJson(jsonString, CSGDatabaseInstance.this.TT_mapStringString);
                            if (tm != null) {
                                CSGDatabaseInstance.this.setDatabase(tm);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            CSGDatabaseInstance.this.setDatabase(new ConcurrentHashMap());
                        }
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            CSGDatabaseInstance.this.saveDatabase();
                        }
                    });
                }
            }.start();
            long start = System.currentTimeMillis();
            while (this.database == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (System.currentTimeMillis() - start <= 500L) continue;
                this.setDatabase(new ConcurrentHashMap<String, Parameter>());
            }
        }
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDatabaseFromFile(File f) {
        FileInputStream in = null;
        try {
            try {
                in = FileUtils.openInputStream((File)f);
                String jsonString = IOUtils.toString((InputStream)in);
                ConcurrentHashMap tm = (ConcurrentHashMap)this.gson.fromJson(jsonString, this.TT_mapStringString);
                if (tm != null) {
                    for (String k : tm.keySet()) {
                        this.set(k, (Parameter)tm.get(k));
                    }
                }
                this.saveDatabase();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public String getDataBaseString() {
        String writeOut = null;
        this.getDatabase();
        writeOut = this.gson.toJson(this.database, this.TT_mapStringString);
        return writeOut;
    }

    public void saveDatabase() {
        String writeOut = this.getDataBaseString();
        try {
            if (!this.getDbFile().exists()) {
                this.getDbFile().createNewFile();
            }
            FileOutputStream out = null;
            try {
                out = FileUtils.openOutputStream((File)this.getDbFile(), (boolean)false);
                IOUtils.write((String)writeOut, (OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setDatabase(ConcurrentHashMap<String, Parameter> database) {
        if (this.database != null) {
            return;
        }
        this.database = database;
    }

    public File getDbFile() {
        return this.dbFile;
    }

    public void setDbFile(File dbFile) {
        if (!dbFile.exists()) {
            try {
                dbFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dbFile = dbFile;
        this.loadDatabaseFromFile(dbFile);
    }

    public void reLoadDbFile() {
        this.setDbFile(this.dbFile);
    }
}

