/*
 * Decompiled with CFR 0.152.
 */
package com.piro.bezier;

import com.piro.bezier.Bezier;
import com.piro.bezier.BezierHistory;
import com.piro.bezier.ParseException;
import com.piro.bezier.PathHandler;
import java.util.ArrayList;

public class BezierListProducer
implements PathHandler {
    final ArrayList<Bezier> bezierSegs = new ArrayList();
    double[] coords = new double[6];
    double curveLength = 0.0;
    BezierHistory hist = new BezierHistory();

    @Override
    public void startPath() throws ParseException {
        this.curveLength = 0.0;
        this.bezierSegs.clear();
    }

    @Override
    public void movetoRel(double x, double y) throws ParseException {
        double offx = this.hist.lastPoint.x;
        double offy = this.hist.lastPoint.y;
        this.movetoAbs(offx + x, offy + y);
    }

    @Override
    public void movetoAbs(double x, double y) throws ParseException {
        this.hist.setLastPoint(x, y);
    }

    @Override
    public void closePath() throws ParseException {
    }

    @Override
    public void linetoRel(double x, double y) throws ParseException {
        double offx = this.hist.lastPoint.x;
        double offy = this.hist.lastPoint.y;
        this.linetoAbs(offx + x, offy + y);
    }

    @Override
    public void linetoAbs(double x, double y) throws ParseException {
        this.coords[0] = x;
        this.coords[1] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 1);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x, y);
    }

    @Override
    public void linetoHorizontalRel(double x) throws ParseException {
        this.linetoAbs(x + this.hist.lastPoint.x, this.hist.lastPoint.y);
    }

    @Override
    public void linetoHorizontalAbs(double x) throws ParseException {
        this.linetoAbs(x, this.hist.lastPoint.y);
    }

    @Override
    public void linetoVerticalRel(double y) throws ParseException {
        this.linetoAbs(this.hist.lastPoint.x, y + this.hist.lastPoint.y);
    }

    @Override
    public void linetoVerticalAbs(double y) throws ParseException {
        this.linetoAbs(this.hist.lastPoint.x, y);
    }

    @Override
    public void curvetoCubicRel(double x1, double y1, double x2, double y2, double x, double y) throws ParseException {
        double offx = this.hist.lastPoint.x;
        double offy = this.hist.lastPoint.y;
        this.curvetoCubicAbs(x1 + offx, y1 + offy, x2 + offx, y2 + offy, x + offx, y + offy);
    }

    @Override
    public void curvetoCubicAbs(double x1, double y1, double x2, double y2, double x, double y) throws ParseException {
        this.coords[0] = x1;
        this.coords[1] = y1;
        this.coords[2] = x2;
        this.coords[3] = y2;
        this.coords[4] = x;
        this.coords[5] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 3);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x2, y2);
    }

    @Override
    public void curvetoCubicSmoothRel(double x2, double y2, double x, double y) throws ParseException {
        double offx = this.hist.lastPoint.x;
        double offy = this.hist.lastPoint.y;
        this.curvetoCubicSmoothAbs(x2 + offx, y2 + offy, x + offx, y + offy);
    }

    @Override
    public void curvetoCubicSmoothAbs(double x2, double y2, double x, double y) throws ParseException {
        double oldKx = this.hist.lastKnot.x;
        double oldKy = this.hist.lastKnot.y;
        double oldX = this.hist.lastPoint.x;
        double oldY = this.hist.lastPoint.y;
        double k1x = oldX * 2.0 - oldKx;
        double k1y = oldY * 2.0 - oldKy;
        this.coords[0] = k1x;
        this.coords[1] = k1y;
        this.coords[2] = x2;
        this.coords[3] = y2;
        this.coords[4] = x;
        this.coords[5] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 3);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x2, y2);
    }

    @Override
    public void curvetoQuadraticRel(double x1, double y1, double x, double y) throws ParseException {
        double offx = this.hist.lastPoint.x;
        double offy = this.hist.lastPoint.y;
        this.curvetoQuadraticAbs(x1 + offx, y1 + offy, x + offx, y + offy);
    }

    @Override
    public void curvetoQuadraticAbs(double x1, double y1, double x, double y) throws ParseException {
        this.coords[0] = x1;
        this.coords[1] = y1;
        this.coords[2] = x;
        this.coords[3] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 2);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x1, y1);
    }

    @Override
    public void curvetoQuadraticSmoothRel(double x, double y) {
        double offx = this.hist.lastPoint.x;
        double offy = this.hist.lastPoint.y;
        this.curvetoQuadraticSmoothAbs(x + offx, y + offy);
    }

    @Override
    public void curvetoQuadraticSmoothAbs(double x, double y) throws ParseException {
        this.curvetoQuadraticAbs(this.hist.lastKnot.x, this.hist.lastKnot.y, x, y);
    }

    @Override
    public void arcRel(double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) throws ParseException {
    }

    @Override
    public void arcAbs(double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) throws ParseException {
    }

    @Override
    public void endPath() throws ParseException {
        this.hist.setLastPoint(this.hist.startPoint.x, this.hist.startPoint.y);
        this.hist.setLastKnot(this.hist.startPoint.x, this.hist.startPoint.y);
    }
}

