/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.device.gameController;

import edu.wpi.SimplePacketComs.BytePacketType;
import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.device.UdpDevice;
import edu.wpi.SimplePacketComs.phy.UDPSimplePacketComs;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class GameController
extends UdpDevice {
    private PacketType gamestate = new BytePacketType(1970, 64);
    private final byte[] status = new byte[60];
    private final byte[] data = new byte[20];
    private final int[] dataI = new int[20];

    private GameController(InetAddress add) throws Exception {
        super(add);
        this.addPollingPacket(this.gamestate);
        this.addEvent(this.gamestate.idOfCommand, new Runnable(){

            @Override
            public void run() {
                GameController.this.readBytes(((GameController)GameController.this).gamestate.idOfCommand, GameController.this.data);
                for (int i = 0; i < GameController.this.data.length - 1; ++i) {
                    ((GameController)GameController.this).dataI[i] = GameController.this.data[i + 1];
                    if (GameController.this.dataI[i] >= 0) continue;
                    int[] nArray = GameController.this.dataI;
                    int n = i;
                    nArray[n] = nArray[n] + 256;
                }
                GameController.this.writeBytes(((GameController)GameController.this).gamestate.idOfCommand, GameController.this.getStatus());
            }
        });
    }

    public static List<GameController> get(String name) throws Exception {
        HashSet<InetAddress> addresses = UDPSimplePacketComs.getAllAddresses(name);
        ArrayList<GameController> robots = new ArrayList<GameController>();
        if (addresses.size() < 1) {
            System.out.println("No GameControllers found named " + name);
            return robots;
        }
        for (InetAddress add : addresses) {
            System.out.println("Got " + add.getHostAddress());
            GameController e = new GameController(add);
            robots.add(e);
        }
        return robots;
    }

    public static List<GameController> get() throws Exception {
        return GameController.get("GameController*");
    }

    public byte[] getStatus() {
        return this.status;
    }

    public int[] getData() {
        return this.dataI;
    }

    public byte getControllerIndex() {
        return this.data[0];
    }
}

