/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.phy;

import edu.wpi.SimplePacketComs.AbstractSimpleComsDevice;
import java.util.ArrayList;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;

public class HIDSimplePacketComs
extends AbstractSimpleComsDevice {
    private int vid = 0;
    private int pid = 0;
    private static HidServices hidServices = null;
    private static ArrayList<HIDSimplePacketComs> connected = new ArrayList();
    private HidDevice hidDevice = null;

    public HIDSimplePacketComs(int vidIn, int pidIn) {
        this.setVid(vidIn);
        this.setPid(pidIn);
    }

    public HIDSimplePacketComs() {
    }

    public int read(byte[] message, int howLongToWaitBeforeTimeout) {
        return this.hidDevice.read(message, howLongToWaitBeforeTimeout);
    }

    public int write(byte[] message, int length, int howLongToWaitBeforeTimeout) {
        return this.hidDevice.write(message, length, (byte)0);
    }

    public boolean disconnectDeviceImp() {
        try {
            if (this.hidDevice != null) {
                this.hidDevice.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (connected.contains((Object)this)) {
            connected.remove((Object)this);
        }
        if (connected.size() == 0 && hidServices != null) {
            try {
                hidServices.shutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            hidServices = null;
        }
        System.out.println("HID device clean shutdown");
        return false;
    }

    public boolean connectDeviceImp() {
        if (hidServices == null) {
            hidServices = HidManager.getHidServices();
        }
        this.hidDevice = null;
        int foundInterface = Integer.MAX_VALUE;
        for (HidDevice h : hidServices.getAttachedHidDevices()) {
            if (!h.isVidPidSerial(this.getVid(), this.getPid(), null)) continue;
            System.out.println("Found! " + h.getInterfaceNumber() + " " + h);
            if (h.getInterfaceNumber() >= foundInterface || h.isOpen()) continue;
            this.hidDevice = h;
            foundInterface = h.getInterfaceNumber();
        }
        if (this.hidDevice == null) {
            return false;
        }
        System.out.println("Connecting to " + foundInterface + " " + this.hidDevice);
        boolean opened = this.hidDevice.open();
        if (opened) {
            connected.add(this);
            return true;
        }
        throw new RuntimeException();
    }

    public int getVid() {
        return this.vid;
    }

    public void setVid(int vid) {
        this.vid = vid;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }
}

