/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class PacketType {
    public int idOfCommand = 0;
    public Number[] downstream;
    public Number[] upstream;
    public boolean done = false;
    public boolean started = false;
    protected ByteOrder be = ByteOrder.LITTLE_ENDIAN;
    protected int packetSize = 64;
    protected int numberOfBytesPerValue = 4;
    public int numValues = this.packetSize / 4 - 1;

    public PacketType(int id) {
        this.idOfCommand = id;
    }

    public void init() {
        this.downstream = new Number[this.numValues];
        this.upstream = new Number[this.numValues];
        for (int i = 0; i < this.numValues; ++i) {
            this.downstream[i] = 0;
            this.upstream[i] = 0;
        }
    }

    int getId(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(this.be).getInt(0);
    }

    public abstract Number[] parse(byte[] var1);

    public abstract byte[] command(int var1, Number[] var2);
}

