/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class PacketType {
    public int idOfCommand = 0;
    public Number[] downstream;
    public Number[] upstream;
    public boolean done = false;
    public boolean started = false;
    protected static ByteOrder be = ByteOrder.LITTLE_ENDIAN;
    public static int packetSize = 64;
    protected int numberOfBytesPerValue = 4;
    public int numValues = packetSize / 4 - 1;
    private boolean oneShotMode = false;
    private boolean oneShotDone = false;

    public PacketType(int id) {
        this.idOfCommand = id;
    }

    public static int getId(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(be).getInt(0);
    }

    public static void writeId(int idOfCommand, byte[] bytes) {
        bytes[3] = (byte)(idOfCommand >> 24);
        bytes[2] = (byte)(idOfCommand >> 16);
        bytes[1] = (byte)(idOfCommand >> 8);
        bytes[0] = (byte)idOfCommand;
    }

    public byte[] command() {
        return this.command(this.idOfCommand, this.downstream);
    }

    public void oneShotMode() {
        this.oneShotMode = true;
        this.oneShotDone = false;
    }

    public void pollingMode() {
        this.oneShotMode = false;
        this.oneShotDone = false;
    }

    public boolean sendOk() {
        if (!this.oneShotMode) {
            return true;
        }
        if (!this.oneShotDone) {
            this.oneShotDone = true;
            return true;
        }
        return false;
    }

    public abstract Number[] parse(byte[] var1);

    public abstract byte[] command(int var1, Number[] var2);
}

