/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.device.warehouse;

import edu.wpi.SimplePacketComs.BytePacketType;
import edu.wpi.SimplePacketComs.FloatPacketType;
import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.device.UdpDevice;
import edu.wpi.SimplePacketComs.device.warehouse.WarehouseRobotStatus;
import edu.wpi.SimplePacketComs.phy.UDPSimplePacketComs;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class WarehouseRobot
extends UdpDevice {
    private PacketType estop = new BytePacketType(1989, 64);
    private PacketType getStatus = new BytePacketType(2012, 64);
    private PacketType clearFaults = new BytePacketType(1871, 64);
    private PacketType pickOrder = new FloatPacketType(1936, 64);
    private PacketType approve = new BytePacketType(1994, 64);
    private byte[] status = new byte[1];
    private double[] pickOrderData = new double[3];
    private double[] driveStatus = new double[1];

    private WarehouseRobot(InetAddress add) throws Exception {
        super(add);
        for (PacketType pt : Arrays.asList(this.clearFaults, this.pickOrder, this.getStatus, this.approve, this.estop)) {
            this.addPollingPacket(pt);
        }
        this.addEvent(this.getStatus.idOfCommand, new Runnable(){

            @Override
            public void run() {
                WarehouseRobot.this.readBytes(((WarehouseRobot)WarehouseRobot.this).getStatus.idOfCommand, WarehouseRobot.this.status);
            }
        });
        this.pickOrder.waitToSendMode();
        this.clearFaults.waitToSendMode();
        this.estop.waitToSendMode();
        this.approve.waitToSendMode();
    }

    public static List<WarehouseRobot> get(String name) throws Exception {
        HashSet<InetAddress> addresses = UDPSimplePacketComs.getAllAddresses(name);
        ArrayList<WarehouseRobot> robots = new ArrayList<WarehouseRobot>();
        if (addresses.size() < 1) {
            System.out.println("No WarehouseRobot found named " + name);
            return robots;
        }
        for (InetAddress add : addresses) {
            System.out.println("Got " + add.getHostAddress());
            WarehouseRobot e = new WarehouseRobot(add);
            e.connect();
            robots.add(e);
        }
        return robots;
    }

    public static List<WarehouseRobot> get() throws Exception {
        return WarehouseRobot.get("Warehouse*");
    }

    public String toString() {
        return this.getName();
    }

    public void estop() {
        this.estop.oneShotMode();
    }

    public double getDriveStatus() {
        return this.driveStatus[0];
    }

    public void pickOrder(double material, double angle, double dropLocation) {
        this.pickOrderData[0] = material;
        this.pickOrderData[1] = angle;
        this.pickOrderData[2] = dropLocation;
        this.writeFloats(this.pickOrder.idOfCommand, this.pickOrderData);
        this.pickOrder.oneShotMode();
    }

    public WarehouseRobotStatus getStatus() {
        return WarehouseRobotStatus.fromValue(this.status[0]);
    }

    public void clearFaults() {
        this.clearFaults.oneShotMode();
    }

    public void approve() {
        this.approve.oneShotMode();
    }
}

