/*
 * Decompiled with CFR 0.152.
 */
package com.cdata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class CData
implements AutoCloseable {
    private long nativeHandle;

    private static void loadFromJar() throws IOException {
        String archName = CData.getArchitectureName();
        String libraryName = System.mapLibraryName("cdatajni");
        String tempDir = System.getProperty("java.io.tmpdir");
        File tempFile = new File(tempDir, "cdatajni-" + archName + "-" + System.currentTimeMillis() + "-" + libraryName);
        tempFile.deleteOnExit();
        String name = "/com/cdata/" + libraryName;
        try (InputStream in = CData.class.getResourceAsStream(name);){
            if (in == null) {
                throw new IOException("Library not found in JAR: /com/cdata/" + libraryName);
            }
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(tempFile.getAbsolutePath());
    }

    private static String getArchitectureName() {
        String arch = System.getProperty("os.arch").toLowerCase();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux")) {
            if (arch.contains("amd64") || arch.contains("x86_64")) {
                return "x86_64-linux";
            }
            if (arch.contains("aarch64") || arch.contains("arm64")) {
                return "arm64-linux";
            }
        }
        throw new UnsatisfiedLinkError("Unsupported architecture: " + arch + " on " + os);
    }

    public CData(String schemaString, String mappedFile, int timeout, boolean isProducer) {
        this.nativeHandle = this.createNative(schemaString, mappedFile, timeout, isProducer);
        if (this.nativeHandle == 0L) {
            throw new RuntimeException("Failed to create native CData object");
        }
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            this.destroyNative(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private native long createNative(String var1, String var2, int var3, boolean var4);

    private native void destroyNative(long var1);

    public native void setData();

    public native int waitOnStateChange();

    public native boolean updateData();

    public native void trigger();

    public native void setValueFloatById(int var1, float var2);

    public native void setValueDoubleById(int var1, double var2);

    public native void setValueIntById(int var1, int var2);

    public native void setValueBoolById(int var1, boolean var2);

    public native void setValueUint64ById(int var1, long var2);

    public native float getValueFloatById(int var1);

    public native double getValueDoubleById(int var1);

    public native int getValueIntById(int var1);

    public native boolean getValueBoolById(int var1);

    public native long getValueUint64ById(int var1);

    public native void setValueFloatByKey(String var1, float var2);

    public native void setValueDoubleByKey(String var1, double var2);

    public native void setValueIntByKey(String var1, int var2);

    public native void setValueBoolByKey(String var1, boolean var2);

    public native void setValueUint64ByKey(String var1, long var2);

    public native float getValueFloatByKey(String var1);

    public native double getValueDoubleByKey(String var1);

    public native int getValueIntByKey(String var1);

    public native boolean getValueBoolByKey(String var1);

    public native long getValueUint64ByKey(String var1);

    static {
        try {
            try {
                System.loadLibrary("cdatajni");
            }
            catch (UnsatisfiedLinkError e) {
                CData.loadFromJar();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load native library: " + e.getMessage(), e);
        }
    }
}

