/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import com.numdata.commons.java8.CheckedBiFunction;
import com.numdata.commons.java8.CheckedConsumer;
import com.numdata.commons.java8.CheckedFunction;
import com.numdata.commons.java8.CheckedIntConsumer;
import com.numdata.commons.java8.CheckedIntSupplier;
import com.numdata.commons.java8.CheckedSupplier;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class FunctionTools {
    private FunctionTools() {
    }

    @NotNull
    @Contract(pure=true)
    public static <T, R> Function<T, R> wrapFunctionException(@NotNull CheckedFunction<T, R, ?> checkedFunction) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T, R, EX extends Exception> Function<T, R> liftFunctionException(@NotNull CheckedFunction<T, R, EX> checkedFunction) throws EX {
        return FunctionTools.hideFunctionException(checkedFunction);
    }

    @NotNull
    @Contract(pure=true)
    private static <T, R, EX extends Exception> Function<T, R> hideFunctionException(@NotNull CheckedFunction<T, R, EX> checkedFunction) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception ex) {
                return FunctionTools.sneakyThrow(ex);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <A, B, R> BiFunction<A, B, R> wrapBiFunctionException(@NotNull CheckedBiFunction<A, B, R, ?> checkedBiFunction) {
        return (a, b) -> {
            try {
                return checkedBiFunction.apply(a, b);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <A, B, R, EX extends Exception> BiFunction<A, B, R> liftBiFunctionException(@NotNull CheckedBiFunction<A, B, R, EX> checkedBiFunction) throws EX {
        return FunctionTools.hideBiFunctionException(checkedBiFunction);
    }

    @NotNull
    @Contract(pure=true)
    private static <A, B, R, EX extends Exception> BiFunction<A, B, R> hideBiFunctionException(@NotNull CheckedBiFunction<A, B, R, EX> checkedBiFunction) {
        return (a, b) -> {
            try {
                return checkedBiFunction.apply(a, b);
            }
            catch (Exception ex) {
                return FunctionTools.sneakyThrow(ex);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Consumer<T> wrapConsumerException(@NotNull CheckedConsumer<T, ?> checkedConsumer) {
        return t -> {
            try {
                checkedConsumer.apply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T, EX extends Exception> Consumer<T> liftConsumerException(@NotNull CheckedConsumer<T, EX> checkedConsumer) throws EX {
        return FunctionTools.hideConsumerException(checkedConsumer);
    }

    @NotNull
    @Contract(pure=true)
    private static <T, EX extends Exception> Consumer<T> hideConsumerException(@NotNull CheckedConsumer<T, EX> checkedConsumer) {
        return t -> {
            try {
                checkedConsumer.apply(t);
            }
            catch (Exception ex) {
                FunctionTools.sneakyThrow(ex);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static IntConsumer wrapIntConsumerException(@NotNull CheckedIntConsumer<?> checkedIntConsumer) {
        return t -> {
            try {
                checkedIntConsumer.apply(t);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <EX extends Exception> IntConsumer liftIntConsumerException(@NotNull CheckedIntConsumer<EX> checkedIntConsumer) throws EX {
        return FunctionTools.hideIntConsumerException(checkedIntConsumer);
    }

    @NotNull
    @Contract(pure=true)
    private static <EX extends Exception> IntConsumer hideIntConsumerException(@NotNull CheckedIntConsumer<EX> checkedIntConsumer) {
        return t -> {
            try {
                checkedIntConsumer.apply(t);
            }
            catch (Exception ex) {
                FunctionTools.sneakyThrow(ex);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Supplier<T> wrapSupplierException(@NotNull CheckedSupplier<T, ?> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T, EX extends Exception> Supplier<T> liftSupplierException(@NotNull CheckedSupplier<T, EX> checkedSupplier) throws EX {
        return FunctionTools.hideSupplierException(checkedSupplier);
    }

    @NotNull
    @Contract(pure=true)
    private static <T, EX extends Exception> Supplier<T> hideSupplierException(@NotNull CheckedSupplier<T, EX> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Exception ex) {
                return FunctionTools.sneakyThrow(ex);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static IntSupplier wrapIntSupplierException(@NotNull CheckedIntSupplier<?> checkedIntSupplier) {
        return () -> {
            try {
                return checkedIntSupplier.get();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <EX extends Exception> IntSupplier liftIntSupplierException(@NotNull CheckedIntSupplier<EX> checkedIntSupplier) throws EX {
        return FunctionTools.hideIntSupplierException(checkedIntSupplier);
    }

    @NotNull
    @Contract(pure=true)
    private static <EX extends Exception> IntSupplier hideIntSupplierException(@NotNull CheckedIntSupplier<EX> checkedIntSupplier) {
        return () -> {
            try {
                return checkedIntSupplier.get();
            }
            catch (Exception ex) {
                return (Integer)FunctionTools.sneakyThrow(ex);
            }
        };
    }

    private static <E extends Throwable, T> T sneakyThrow(@NotNull Throwable throwable) throws E {
        throw throwable;
    }
}

