/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.support.AliasTable;
import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.ExpressionType;
import com.ursful.framework.orm.support.JoinType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Join
implements Serializable {
    private JoinType type;
    private List<Condition> conditions;
    private AliasTable table;

    public Object getTable() {
        return this.table.getTable();
    }

    public Join(AliasTable table) {
        this(table, JoinType.LEFT_JOIN);
    }

    public Join(AliasTable table, JoinType type) {
        this.table = table;
        this.type = type;
        this.conditions = new ArrayList<Condition>();
    }

    public static Join create(AliasTable table) {
        return new Join(table);
    }

    public static Join create(AliasTable table, JoinType type) {
        return new Join(table, type);
    }

    public Join on(Column column, Object value, ExpressionType expressionType) {
        this.conditions.add(new Condition().and(new Expression(column, value, expressionType)));
        return this;
    }

    public Join on(String columnName, Object value, ExpressionType expressionType) {
        this.conditions.add(new Condition().and(new Expression(new Column(this.table.getAlias(), columnName), value, expressionType)));
        return this;
    }

    public Join on(String columnName, Column column) {
        this.conditions.add(new Condition().and(new Expression(new Column(this.table.getAlias(), columnName), (Object)column, ExpressionType.CDT_EQUAL)));
        return this;
    }

    public Join on(Column thisColumn, Column column) {
        this.conditions.add(new Condition().and(new Expression(thisColumn, (Object)column, ExpressionType.CDT_EQUAL)));
        return this;
    }

    public Join on(Condition condition) {
        if (condition != null) {
            this.conditions.add(condition);
        }
        return this;
    }

    public JoinType getType() {
        return this.type;
    }

    public void setType(JoinType type) {
        this.type = type;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public String getAlias() {
        return this.table.getAlias();
    }
}

