/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.option;

import com.objectsql.annotation.RdColumn;
import com.objectsql.annotation.RdForeignKey;
import com.objectsql.annotation.RdId;
import com.objectsql.annotation.RdTable;
import com.objectsql.annotation.RdUniqueKey;
import com.objectsql.exception.ORMException;
import com.objectsql.option.MySQLOptions;
import com.objectsql.support.ColumnInfo;
import com.objectsql.support.ColumnType;
import com.objectsql.support.Table;
import com.objectsql.support.TableColumn;
import com.objectsql.utils.ORMUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class H2Options
extends MySQLOptions {
    @Override
    public String keyword() {
        return "h2";
    }

    @Override
    public String databaseType() {
        return "H2";
    }

    @Override
    public List<Table> tables(Connection connection, String keyword) {
        ArrayList<Table> temp = new ArrayList<Table>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT TABLE_NAME,REMARKS FROM information_schema.TABLES WHERE TABLE_CATALOG = ? ";
            if (!ORMUtils.isEmpty(keyword)) {
                sql = sql + "AND TABLE_NAME LIKE ? ";
            }
            ps = connection.prepareStatement(sql);
            ps.setString(1, dbName);
            if (!ORMUtils.isEmpty(keyword)) {
                ps.setString(2, "%" + keyword + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(new Table(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return temp;
    }

    @Override
    public Table table(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        Table table = new Table(tableName);
        table.setSensitive(rdTable.sensitive());
        return this.table(connection, table);
    }

    @Override
    public Table table(Connection connection, Table table) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String tableName = this.getCaseSensitive(table.getName(), table.getSensitive());
            String dbName = connection.getCatalog();
            String sql = "SELECT TABLE_NAME,REMARKS,TABLE_CATALOG FROM information_schema.TABLES WHERE TABLE_NAME = ? AND TABLE_CATALOG = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            ps.setString(2, dbName);
            rs = ps.executeQuery();
            if (rs.next()) {
                Table table2 = new Table(rs.getString(1), rs.getString(2));
                return table2;
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    private void print(Connection connection) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT TABLE_NAME,REMARKS,TABLE_CATALOG FROM information_schema.TABLES WHERE TABLE_CATALOG = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, dbName);
            rs = ps.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getString(1) + "--->" + rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean tableExists(Connection connection, String tableName) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = ? AND TABLE_CATALOG = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            ps.setString(2, dbName);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<TableColumn> columns(Connection connection, String tableName) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            String dbName = connection.getCatalog();
            String sql = "SELECT * FROM information_schema.COLUMNS WHERE TABLE_NAME = ? AND TABLE_CATALOG = ? ";
            ps = connection.prepareStatement(sql);
            ps.setString(1, tableName);
            ps.setString(2, dbName);
            rs = ps.executeQuery();
            while (rs.next()) {
                TableColumn column = new TableColumn(tableName, rs.getString("COLUMN_NAME"));
                column.setType(rs.getString("TYPE_NAME").toUpperCase(Locale.ROOT));
                column.setLength(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                column.setNullable("YES".equalsIgnoreCase(rs.getString("IS_NULLABLE")));
                column.setPrecision(rs.getInt("NUMERIC_PRECISION"));
                column.setDefaultValue(rs.getString("COLUMN_DEFAULT"));
                column.setScale(rs.getInt("NUMERIC_SCALE"));
                column.setOrder(rs.getInt("ORDINAL_POSITION"));
                column.setComment(rs.getString("REMARKS"));
                columns.add(column);
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return columns;
    }

    @Override
    public List<TableColumn> columns(Connection connection, RdTable rdTable) throws ORMException {
        String tableName = this.getTableName(rdTable);
        return this.columns(connection, tableName);
    }

    private List<String> tableConstraints(Connection connection) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String sql = "SELECT CONSTRAINT_NAME AS INDEX_NAME FROM INFORMATION_SCHEMA.CONSTRAINTS";
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                names.add(indexName.toUpperCase(Locale.ROOT));
            }
        }
        catch (SQLException e) {
            throw new ORMException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return names;
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, RdTable table, List<ColumnInfo> infos, boolean tableExisted, List<TableColumn> tableColumns) {
        String tableName = this.getCaseSensitive(table.name(), table.sensitive());
        ArrayList<String> sqls = new ArrayList<String>();
        List<String> constraints = this.tableConstraints(connection);
        if (table.dropped()) {
            if (tableExisted) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("DROP TABLE %s", tableName));
                } else {
                    sqls.add(String.format("DROP TABLE \"%s\"", tableName));
                }
            }
        } else if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (ColumnInfo info : infos) {
                String foreignSQL;
                String uniqueSQL;
                String columnName = this.getCaseSensitive(info.getColumnName(), table.sensitive());
                TableColumn tableColumn = (TableColumn)columnMap.get(columnName);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                if (tableColumn != null) {
                    if (rdColumn.dropped()) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                        } else {
                            sqls.add(String.format("ALTER TABLE \"%s\" DROP COLUMN \"%s\"", tableName, columnName));
                        }
                    } else {
                        String temp;
                        boolean needUpdate = false;
                        if ("VARCHAR".equalsIgnoreCase(tableColumn.getType()) || "CHAR".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getLength() == null) continue;
                            if (tableColumn.getLength().intValue() != rdColumn.length()) {
                                needUpdate = true;
                            }
                        } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                            if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                            if ("Date".equalsIgnoreCase(info.getType())) {
                                if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale() != 0) {
                                    needUpdate = true;
                                }
                            } else if (tableColumn.getPrecision().intValue() != rdColumn.precision() || tableColumn.getScale().intValue() != rdColumn.scale()) {
                                needUpdate = true;
                            }
                        } else {
                            String type = this.getColumnType(info, rdColumn).toUpperCase(Locale.ROOT);
                            if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                                needUpdate = true;
                            }
                        }
                        if (!needUpdate && !ORMUtils.isEmpty(tableColumn.getDefaultValue())) {
                            String defaultValue = tableColumn.getDefaultValue().trim();
                            if (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                            }
                            if (!defaultValue.equals(rdColumn.defaultValue())) {
                                needUpdate = true;
                            }
                        }
                        RdId rdId = info.getField().getAnnotation(RdId.class);
                        if (!needUpdate && tableColumn.isNullable() != rdColumn.nullable() && !tableColumn.isPrimaryKey() && rdId == null) {
                            temp = this.columnStringChangeNull(info, table.sensitive(), rdColumn.nullable());
                            sqls.add(String.format("ALTER TABLE %s ALTER %s ", tableName, temp));
                        }
                        if (needUpdate) {
                            temp = this.columnString(info, table.sensitive(), rdColumn, false);
                            if (table.sensitive() == 0) {
                                sqls.add(String.format("ALTER TABLE %s ALTER COLUMN %s", tableName, temp));
                            } else {
                                sqls.add(String.format("ALTER TABLE \"%s\" ALTER COLUMN %s", tableName, temp));
                            }
                            String comment = this.columnComment(rdColumn);
                            if (!ORMUtils.isEmpty(comment)) {
                                if (table.sensitive() == 0) {
                                    sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                                } else {
                                    sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                                }
                            }
                        }
                    }
                } else if (!rdColumn.dropped()) {
                    String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                    if (table.sensitive() == 0) {
                        sqls.add(String.format("ALTER TABLE %s ADD COLUMN %s", tableName, temp));
                    } else {
                        sqls.add(String.format("ALTER TABLE \"%s\" ADD COLUMN %s", tableName, temp));
                    }
                    String comment = this.columnComment(rdColumn);
                    if (!ORMUtils.isEmpty(comment)) {
                        if (table.sensitive() == 0) {
                            sqls.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                        } else {
                            sqls.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                        }
                    }
                }
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    if (table.sensitive() == 0) {
                        sqls.add("ALTER TABLE " + tableName + " ADD " + uniqueSQL);
                    } else {
                        sqls.add("ALTER TABLE \"" + tableName + "\" ADD " + uniqueSQL);
                    }
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                if (table.sensitive() == 0) {
                    sqls.add("ALTER TABLE " + tableName + " ADD " + foreignSQL);
                    continue;
                }
                sqls.add("ALTER TABLE \"" + tableName + "\" ADD " + foreignSQL);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE ");
            if (table.sensitive() == 0) {
                sql.append(tableName);
            } else {
                sql.append(String.format("\"%s\" ", tableName));
            }
            sql.append(" (");
            ArrayList<String> columnSQL = new ArrayList<String>();
            ArrayList<String> comments = new ArrayList<String>();
            for (int i = 0; i < infos.size(); ++i) {
                String foreignSQL;
                String uniqueSQL;
                ColumnInfo info = infos.get(i);
                RdColumn rdColumn = info.getField().getAnnotation(RdColumn.class);
                RdUniqueKey uniqueKey = info.getField().getAnnotation(RdUniqueKey.class);
                RdForeignKey foreignKey = info.getField().getAnnotation(RdForeignKey.class);
                String temp = this.columnString(info, table.sensitive(), rdColumn, true);
                String comment = this.columnComment(rdColumn);
                String columnName = this.getCaseSensitive(info.getColumnName(), table.sensitive());
                if (!ORMUtils.isEmpty(comment)) {
                    if (table.sensitive() == 0) {
                        comments.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, comment));
                    } else {
                        comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s'", tableName, columnName, comment));
                    }
                }
                columnSQL.add(temp.toString());
                if (!info.getPrimaryKey().booleanValue() && uniqueKey != null && !constraints.contains(uniqueKey.name().toUpperCase(Locale.ROOT)) && (uniqueSQL = this.getUniqueSQL(table, rdColumn, uniqueKey)) != null) {
                    columnSQL.add(uniqueSQL);
                }
                if (foreignKey == null || constraints.contains(foreignKey.name().toUpperCase(Locale.ROOT)) || (foreignSQL = this.getForeignSQL(table, rdColumn, foreignKey)) == null) continue;
                columnSQL.add(foreignSQL);
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            String comment = table.comment();
            sqls.add(sql.toString());
            if (!ORMUtils.isEmpty(comment)) {
                if (table.sensitive() == 0) {
                    sqls.add(String.format("COMMENT ON TABLE %s IS '%s'", tableName, comment));
                } else {
                    sqls.add(String.format("COMMENT ON TABLE \"%s\" IS '%s'", tableName, comment));
                }
            }
            sqls.addAll(comments);
        }
        return sqls;
    }

    @Override
    public List<String> createOrUpdateSqls(Connection connection, Table table, List<TableColumn> columns, List<TableColumn> tableColumns, boolean tableExisted) {
        String tableName = this.getCaseSensitive(table.getName(), table.getSensitive());
        ArrayList<String> sqls = new ArrayList<String>();
        if (tableExisted) {
            HashMap<String, TableColumn> columnMap = new HashMap<String, TableColumn>();
            int sensitive = -1;
            for (TableColumn column : tableColumns) {
                columnMap.put(column.getColumn(), column);
            }
            for (TableColumn tc : columns) {
                String columnName = this.getCaseSensitive(tc.getColumn(), table.getSensitive());
                TableColumn tableColumn = null;
                tableColumn = sensitive == 1 ? (TableColumn)columnMap.get(columnName.toLowerCase(Locale.ROOT)) : (TableColumn)columnMap.get(columnName);
                if (tableColumn != null) {
                    if (tc.isDropped()) {
                        if (table.getSensitive() == 0) {
                            sqls.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName));
                            continue;
                        }
                        sqls.add(String.format("ALTER TABLE `%s` DROP COLUMN `%s`", tableName, columnName));
                        continue;
                    }
                    boolean needUpdate = false;
                    if ("VARCHAR".equalsIgnoreCase(tableColumn.getType()) || "CHAR".equalsIgnoreCase(tableColumn.getType())) {
                        if (tableColumn.getLength() == null) continue;
                        if ((long)tableColumn.getLength().intValue() != tc.getLength()) {
                            needUpdate = true;
                        }
                    } else if ("DECIMAL".equalsIgnoreCase(tableColumn.getType())) {
                        if (tableColumn.getPrecision() == null || tableColumn.getScale() == null) continue;
                        if ("Date".equalsIgnoreCase(tc.getType())) {
                            if (tableColumn.getPrecision().intValue() != tc.getPrecision().intValue() || tableColumn.getScale() != 0) {
                                needUpdate = true;
                            }
                        } else if (tableColumn.getPrecision().intValue() != tc.getPrecision().intValue() || tableColumn.getScale().intValue() != tc.getScale().intValue()) {
                            needUpdate = true;
                        }
                    } else {
                        String type = tc.getType().toUpperCase(Locale.ROOT);
                        if (!type.startsWith(tableColumn.getType().toUpperCase(Locale.ROOT))) {
                            needUpdate = true;
                        }
                    }
                    if (!(needUpdate || ORMUtils.isEmpty(tableColumn.getDefaultValue()) || tableColumn.getDefaultValue().equals(tc.getDefaultValue()))) {
                        needUpdate = true;
                    }
                    if (!(needUpdate || tableColumn.isNullable() == tc.isNullable() || tableColumn.isPrimaryKey() || tc.isPrimaryKey())) {
                        needUpdate = true;
                    }
                    if (!needUpdate) continue;
                    String temp = this.columnString(tableColumn, table.getSensitive(), false);
                    String comment = tableColumn.getComment();
                    if (!ORMUtils.isEmpty(comment)) {
                        temp = temp + " COMMENT '" + comment + "'";
                    }
                    if (table.getSensitive() == 0) {
                        sqls.add(String.format("ALTER TABLE %s MODIFY COLUMN %s", tableName, temp));
                        continue;
                    }
                    sqls.add(String.format("ALTER TABLE `%s` MODIFY COLUMN %s", tableName, temp));
                    continue;
                }
                if (tc.isDropped()) continue;
                String temp = this.columnString(tc, table.getSensitive(), true);
                String comment = tc.getComment();
                if (!ORMUtils.isEmpty(comment)) {
                    temp = temp + " COMMENT'" + comment + "'";
                }
                if (table.getSensitive() == 0) {
                    sqls.add(String.format("ALTER TABLE %s ADD COLUMN %s", tableName, temp));
                    continue;
                }
                sqls.add(String.format("ALTER TABLE `%s` ADD COLUMN %s", tableName, temp));
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE " + tableName + "(");
            ArrayList<String> columnSQL = new ArrayList<String>();
            for (int i = 0; i < columns.size(); ++i) {
                TableColumn tc = columns.get(i);
                String temp = this.columnString(tc, table.getSensitive(), true);
                String comment = tc.getComment();
                if (!ORMUtils.isEmpty(comment)) {
                    temp = temp + " COMMENT '" + comment + "'";
                }
                columnSQL.add(temp.toString());
            }
            sql.append(ORMUtils.join(columnSQL, ","));
            sql.append(")");
            sqls.add(sql.toString());
            String comment = table.getComment();
            if (!ORMUtils.isEmpty(comment)) {
                sqls.add("COMMENT ON TABLE " + tableName + " IS '" + comment + "';");
            }
        }
        return sqls;
    }

    protected String columnStringChangeNull(ColumnInfo info, int sensitive, boolean isNull) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("\"%s\"", cname));
        }
        if (isNull) {
            temp.append(" SET NULL");
        } else {
            temp.append(" SET NOT NULL");
        }
        return temp.toString();
    }

    @Override
    protected String columnString(TableColumn tableColumn, int sensitive, boolean addKey) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(tableColumn.getColumn(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("`%s`", cname));
        }
        String it = this.getColumnType(tableColumn);
        String type = " " + it;
        if (!ORMUtils.isEmpty(tableColumn.getDefaultValue())) {
            type = type + " DEFAULT '" + tableColumn.getDefaultValue() + "'";
        }
        if (!tableColumn.isNullable()) {
            type = type + " NOT NULL";
        }
        temp.append(type);
        if (tableColumn.isPrimaryKey() && addKey) {
            temp.append(" PRIMARY KEY");
        }
        if (tableColumn.isPrimaryKey() && tableColumn.isAutoIncrement()) {
            temp.append(" AUTO_INCREMENT");
        }
        return temp.toString();
    }

    @Override
    protected String columnString(ColumnInfo info, int sensitive, RdColumn rdColumn, boolean addKey) {
        StringBuffer temp = new StringBuffer();
        String cname = this.getCaseSensitive(info.getColumnName(), sensitive);
        if (sensitive == 0) {
            temp.append(cname);
        } else {
            temp.append(String.format("\"%s\"", cname));
        }
        temp.append(" ");
        String type = this.getColumnType(info, rdColumn);
        if (!ORMUtils.isEmpty(rdColumn.defaultValue())) {
            type = type + " DEFAULT '" + rdColumn.defaultValue() + "'";
        }
        if (!rdColumn.nullable() && addKey) {
            type = type + " NOT NULL";
        }
        temp.append(type);
        if (info.getPrimaryKey().booleanValue() && addKey) {
            temp.append(" ");
            temp.append("PRIMARY KEY");
        }
        return temp.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getColumnType(ColumnInfo info, RdColumn rdColumn) {
        String type = "";
        String infoType = info.getField().getType().getName();
        if (String.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.TEXT) return "TEXT";
            if (info.getColumnType() == ColumnType.MEDIUM_TEXT) return "TEXT";
            if (info.getColumnType() == ColumnType.LONG_TEXT) {
                return "TEXT";
            }
            if (info.getColumnType() == ColumnType.BLOB) {
                return "BLOB";
            }
            if (info.getColumnType() == ColumnType.CLOB) {
                return "CLOB";
            }
            if (info.getColumnType() == ColumnType.BINARY) {
                return "VARBINARY(" + rdColumn.length() + ")";
            }
            if (info.getColumnType() != ColumnType.CHAR) return "VARCHAR(" + rdColumn.length() + ")";
            return "CHAR(" + rdColumn.length() + ")";
        }
        if (Integer.class.getName().equals(infoType)) {
            return "INTEGER";
        }
        if (Date.class.getName().equals(infoType)) {
            if (info.getColumnType() == ColumnType.LONG) {
                return "DECIMAL(" + (rdColumn.precision() > 0 ? rdColumn.precision() : 15) + ", 0)";
            }
            if (info.getColumnType() == ColumnType.TIMESTAMP) {
                return "TIMESTAMP";
            }
            if (info.getColumnType() != ColumnType.DATETIME) throw new ORMException("Not support type : " + infoType + "," + info.getColumnType().name());
            return "DATE";
        }
        if (Long.class.getName().equals(infoType)) {
            return "BIGINT(" + rdColumn.precision() + ")";
        }
        if (Double.class.getName().equals(infoType)) {
            return "DOUBLE";
        }
        if (Float.class.getName().equals(infoType)) {
            if (info.getColumnType() != ColumnType.REAL) return "DOUBLE";
            return "REAL";
        }
        if (BigDecimal.class.getName().equals(infoType)) {
            return "DECIMAL(" + rdColumn.precision() + "," + rdColumn.scale() + ")";
        }
        if (!byte[].class.getName().equals(infoType)) throw new ORMException("Not support type : " + infoType + "," + info.getColumnType().name());
        return "VARBINARY(" + rdColumn.length() + ")";
    }

    @Override
    public String getCaseSensitive(String name, int sensitive) {
        if (name == null) {
            return name;
        }
        if (2 == sensitive) {
            return name.toLowerCase(Locale.ROOT);
        }
        if (1 == sensitive) {
            return name.toUpperCase(Locale.ROOT);
        }
        if (3 == sensitive) {
            return name;
        }
        return name;
    }
}

