/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql;

import com.objectsql.DynamicDataSource;
import com.objectsql.ISQLService;
import com.objectsql.ObjectSQLManager;
import com.objectsql.annotation.RdId;
import com.objectsql.annotation.RdTable;
import com.objectsql.exception.ORMBatchException;
import com.objectsql.exception.ORMException;
import com.objectsql.exception.ORMSQLException;
import com.objectsql.handler.DefaultResultSetHandler;
import com.objectsql.handler.IResultSetHandler;
import com.objectsql.handler.ResultSetFunction;
import com.objectsql.helper.SQLHelper;
import com.objectsql.helper.SQLHelperCreator;
import com.objectsql.support.ColumnClass;
import com.objectsql.support.ColumnInfo;
import com.objectsql.support.DatabaseTypeHolder;
import com.objectsql.support.IRealConnection;
import com.objectsql.support.KV;
import com.objectsql.support.Options;
import com.objectsql.support.Pair;
import com.objectsql.support.Table;
import com.objectsql.support.TableColumn;
import com.objectsql.utils.ORMUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.springframework.util.StringUtils;

public class SQLServiceImpl
implements ISQLService {
    public ObjectSQLManager objectSQLManager;
    protected Class<?> thisClass;
    protected Class<?> serviceClass;
    protected IResultSetHandler resultSetHandler = new DefaultResultSetHandler();

    public SQLServiceImpl() {
    }

    public SQLServiceImpl(ObjectSQLManager objectSQLManager) {
        this.objectSQLManager = objectSQLManager;
    }

    public SQLServiceImpl(DataSource dataSource) {
        this.objectSQLManager = new ObjectSQLManager(dataSource);
    }

    public IResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(IResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public ObjectSQLManager getObjectSQLManager() {
        return this.objectSQLManager;
    }

    @Override
    public Options getOptions() {
        if (this.objectSQLManager == null) {
            return null;
        }
        return this.objectSQLManager.getOptions(this.thisClass, this.serviceClass);
    }

    @Override
    public String currentDatabaseName() {
        if (this.objectSQLManager == null) {
            return null;
        }
        return this.objectSQLManager.getProductName(this.thisClass, this.serviceClass);
    }

    @Override
    public String currentDatabaseType() {
        Options options = this.getOptions();
        if (options != null) {
            return this.getOptions().databaseType();
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        if (this.objectSQLManager == null) {
            return null;
        }
        return this.objectSQLManager.getDataSource(this.thisClass, this.serviceClass);
    }

    @Override
    public void changeDataSource(String alias) {
        DynamicDataSource.setDataSource(alias);
    }

    @Override
    public void setObjectSQLManager(ObjectSQLManager objectSQLManager) {
        this.objectSQLManager = objectSQLManager;
    }

    @Override
    public boolean execute(String sql, Object ... params) {
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "execute", sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            boolean bl = ps.execute();
            this.closeConnection(null, ps, conn);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "execute").put("sql", sql).put("params", params);
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
    }

    private void setParams(PreparedStatement ps, Object[] params, Connection connection) throws SQLException {
        if (params != null && params.length > 0) {
            ArrayList<Pair> pairList = new ArrayList<Pair>();
            for (Object object : params) {
                pairList.add(new Pair(object));
            }
            SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, connection);
        }
    }

    @Override
    public boolean executeBatch(String sql, Object[] ... params) {
        return this.executeBatch(sql, false, true, params);
    }

    @Override
    public void query(String sql, Object[] params, ResultSetFunction function) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "query", sql, params, function);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (params != null) {
                ArrayList<Pair> pairList = new ArrayList<Pair>();
                for (Object param : params) {
                    pairList.add(new Pair(param));
                }
                SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, conn);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                function.process(rs);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "query").put("sql", sql).put("params", params).put("function", function);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean executeBatch(String sql, boolean autoCommit, boolean rollback, Object[] ... params) {
        boolean result;
        Connection conn;
        PreparedStatement ps;
        ResultSet rs;
        block18: {
            boolean i2222;
            block19: {
                rs = null;
                ps = null;
                conn = null;
                result = false;
                try {
                    ORMUtils.handleDebugInfo(SQLServiceImpl.class, "executeBatch", new Object[]{sql, autoCommit, rollback, params});
                    if (params != null) {
                        conn = this.getConnection();
                        ps = conn.prepareStatement(sql);
                        if (!autoCommit) {
                            conn.setAutoCommit(false);
                        }
                        for (int i2222 = 0; i2222 < params.length; ++i2222) {
                            this.setParams(ps, params[i2222], conn);
                            ps.addBatch();
                        }
                        ps.executeBatch();
                        ps.clearBatch();
                        if (!autoCommit) {
                            conn.commit();
                        }
                        result = true;
                        break block18;
                    }
                    i2222 = false;
                    if (conn == null || autoCommit) break block19;
                }
                catch (SQLException e) {
                    try {
                        if (autoCommit) throw new ORMBatchException(e, params.length, -1);
                        if (!rollback) throw new ORMBatchException(e, params.length, -1);
                        try {
                            conn.rollback();
                            throw new ORMBatchException(e, params.length, -1);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        throw new ORMBatchException(e, params.length, -1);
                    }
                    catch (Throwable throwable) {
                        if (conn != null && !autoCommit) {
                            try {
                                conn.setAutoCommit(true);
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        this.closeConnection(rs, ps, conn);
                        throw throwable;
                    }
                }
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.closeConnection(rs, ps, conn);
            return i2222;
        }
        if (conn != null && !autoCommit) {
            try {
                conn.setAutoCommit(true);
            }
            catch (SQLException i2222) {
                // empty catch block
            }
        }
        this.closeConnection(rs, ps, conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T queryObject(Class<T> clazz, String sql, Object ... params) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        T temp = null;
        Connection conn = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "queryObject", clazz, sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (params != null) {
                ArrayList<Pair> pairList = new ArrayList<Pair>();
                for (Object param : params) {
                    pairList.add(new Pair(param));
                }
                SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, conn);
            }
            if ((rs = ps.executeQuery()).next()) {
                temp = SQLHelperCreator.newClass(clazz, rs, this.resultSetHandler);
            }
            this.closeConnection(rs, ps, conn);
            return temp;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "query").put("class", clazz).put("sql", sql).put("params", params);
                catch (IllegalAccessException e2) {
                    throw new ORMSQLException(e2, "query").put("class", clazz).put("sql", sql).put("params", params);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> queryObjectList(Class<T> clazz, String sql, Object ... params) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "queryObjectList", clazz, sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            if (params != null) {
                ArrayList<Pair> pairList = new ArrayList<Pair>();
                for (Object param : params) {
                    pairList.add(new Pair(param));
                }
                SQLHelperCreator.setParameter(this.getOptions(), ps, pairList, conn);
            }
            rs = ps.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.closeConnection(rs, ps, conn);
                    return temp;
                }
                Object tmp = SQLHelperCreator.newClass(clazz, rs, this.resultSetHandler);
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "queryObjectList").put("class", clazz).put("sql", sql).put("params", params);
                catch (IllegalAccessException e2) {
                    throw new ORMSQLException(e2, "queryObjectList").put("class", clazz).put("sql", sql).put("params", params);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
    }

    @Override
    public Map<String, Object> queryMap(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        HashMap<String, Object> tempMap = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "queryMap", sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                ResultSetMetaData metaMap = rs.getMetaData();
                tempMap = new HashMap<String, Object>();
                for (int i = 1; i <= metaMap.getColumnCount(); ++i) {
                    Object obj = rs.getObject(i);
                    KV kv = this.resultSetHandler.parseMap(metaMap, i, obj, rs);
                    if (kv == null) continue;
                    tempMap.put(kv.getKey(), kv.getValue());
                }
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "queryMap").put("sql", sql).put("params", params);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return tempMap;
    }

    @Override
    public List<Map<String, Object>> queryMapList(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        ArrayList<Map<String, Object>> temp = new ArrayList<Map<String, Object>>();
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "queryMapList", sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                ResultSetMetaData metaMap = rs.getMetaData();
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                for (int i = 1; i <= metaMap.getColumnCount(); ++i) {
                    Object obj = rs.getObject(i);
                    KV kv = this.resultSetHandler.parseMap(metaMap, i, obj, rs);
                    if (kv == null) continue;
                    tempMap.put(kv.getKey(), kv.getValue());
                }
                temp.add(tempMap);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "queryMapList").put("sql", sql).put("params", params);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return temp;
    }

    @Override
    public int queryCount(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        int temp = 0;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "queryCount", sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                temp = rs.getInt(1);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "queryCount").put("sql", sql).put("params", params);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return temp;
    }

    @Override
    public Object queryResult(String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        Object temp = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "queryResult", sql, params);
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            this.setParams(ps, params, conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                temp = rs.getObject(1);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "queryResult").put("sql", sql).put("params", params);
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        return temp;
    }

    public void closeConnection(ResultSet rs, Statement stmt, Connection conn) {
        if (this.objectSQLManager == null) {
            return;
        }
        this.objectSQLManager.close(this.thisClass, this.serviceClass, rs, stmt, conn);
    }

    @Override
    public Connection getConnection() {
        if (this.objectSQLManager == null) {
            return null;
        }
        return this.objectSQLManager.getConnection(this.thisClass, this.serviceClass);
    }

    @Override
    public Date getDatabaseDateTime() {
        Double longTime = this.getDatabaseNanoTime();
        if (longTime != null) {
            return new Date(longTime.longValue());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Double getDatabaseNanoTime() {
        if (this.objectSQLManager == null) {
            return null;
        }
        ResultSet rs = null;
        Statement ps = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            String type = DatabaseTypeHolder.get();
            if (type == null) {
                Double d = null;
                return d;
            }
            Options options = this.objectSQLManager.getOptions(type);
            if (options == null) {
                Double d = null;
                return d;
            }
            String sql = options.nanoTimeSQL();
            if (sql == null) {
                Double d = null;
                this.closeConnection(rs, ps, conn);
                return d;
            }
            ps = conn.createStatement();
            rs = ps.executeQuery(sql);
            if (rs.next()) {
                Object object = rs.getObject(1);
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    Double d = (double)timestamp.getTime() + (double)timestamp.getNanos() / 1.0E9;
                    this.closeConnection(rs, ps, conn);
                    return d;
                }
                if (object instanceof LocalDateTime) {
                    LocalDateTime ldt = (LocalDateTime)object;
                    int hour = TimeZone.getDefault().getRawOffset() / 1000 / 3600;
                    Double d = (double)ldt.toInstant(ZoneOffset.ofHours(hour)).toEpochMilli() * 1.0;
                    this.closeConnection(rs, ps, conn);
                    return d;
                }
                Timestamp timestamp = this.getOracleTimestamp(object, conn);
                ORMUtils.whenEmpty(timestamp, "Error get timestamp from oracle.");
                Double d = (double)timestamp.getTime() + (double)timestamp.getNanos() / 1.0E9;
                this.closeConnection(rs, ps, conn);
                return d;
            }
            this.closeConnection(rs, ps, conn);
            return null;
        }
        catch (SQLException e) {
            throw new ORMSQLException(e, "getDatabaseNanoTime");
        }
        finally {
            this.closeConnection(rs, ps, conn);
        }
    }

    private Timestamp getOracleTimestamp(Object value, Connection connection) {
        try {
            ORMUtils.whenEmpty(connection, "Oracle connection should not be nullable.");
            Connection conn = this.getRealConnection(connection);
            Class<?> clz = value.getClass();
            Method m = clz.getMethod("timestampValue", Connection.class);
            return (Timestamp)m.invoke(value, conn);
        }
        catch (Exception e) {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "getOracleTimestamp exception:" + e.getMessage(), value);
            return null;
        }
    }

    private Connection getRealConnection(Connection connection) {
        Connection conn = null;
        ObjectSQLManager sqlManager = this.getObjectSQLManager();
        if (sqlManager == null) {
            return null;
        }
        List<IRealConnection> realConnections = sqlManager.getRealConnection();
        if (!realConnections.isEmpty()) {
            for (IRealConnection realConnection : realConnections) {
                Connection temp = realConnection.getConnection(connection);
                if (temp == null) continue;
                conn = temp;
                break;
            }
        }
        if (conn == null && connection.getClass().getName().endsWith("DruidPooledConnection")) {
            Class<?> clazz = null;
            try {
                clazz = connection.getClass().getClassLoader().loadClass("com.alibaba.druid.pool.DruidPooledConnection");
                Method method = clazz.getMethod("getConnection", new Class[0]);
                conn = (Connection)method.invoke((Object)connection, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getTargetException();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (conn == null) {
            conn = connection;
        }
        return conn;
    }

    @Override
    public <S> List<S> batchInserts(List<S> ts, int batchCount) {
        return this.batchInserts(ts, batchCount, true, false);
    }

    @Override
    public <S> List<S> batchInserts(List<S> ts, int batchCount, boolean autoCommit) {
        return this.batchInserts(ts, batchCount, autoCommit, false);
    }

    @Override
    public <S> List<S> batchInserts(List<S> ts, boolean rollback) {
        return this.batchInserts(ts, ts.size(), !rollback, rollback);
    }

    /*
     * Loose catch block
     */
    @Override
    public <S> List<S> batchInserts(List<S> ts, int batchCount, boolean autoCommit, boolean rollback) {
        Connection conn;
        PreparedStatement ps;
        ResultSet rs;
        block25: {
            List<SQLHelper> helpers2333333332;
            int index;
            block23: {
                ArrayList arrayList;
                block24: {
                    if (ts == null || ts.isEmpty()) {
                        return ts;
                    }
                    rs = null;
                    ps = null;
                    conn = null;
                    index = 0;
                    helpers2333333332 = SQLHelperCreator.inserts(ts, this.getOptions());
                    if (!helpers2333333332.isEmpty()) break block23;
                    arrayList = new ArrayList();
                    if (conn == null || autoCommit) break block24;
                    try {
                        conn.setAutoCommit(true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.closeConnection(rs, ps, conn);
                return arrayList;
            }
            SQLHelper helper = helpers2333333332.get(0);
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "batchInserts", helper, ts, batchCount, autoCommit, rollback);
            RdId rdId = null;
            if (helper.getIdValue() == null && helper.getIdField() != null) {
                rdId = helper.getIdField().getAnnotation(RdId.class);
            }
            conn = this.getConnection();
            if (!autoCommit) {
                conn.setAutoCommit(false);
            }
            ps = rdId != null && rdId.autoIncrement() ? conn.prepareStatement(helper.getSql(), 1) : conn.prepareStatement(helper.getSql());
            for (int i = 0; i < helpers2333333332.size(); i += batchCount) {
                index = i;
                int lastIndex = Math.min(i + batchCount, helpers2333333332.size()) - 1;
                if (i > lastIndex) continue;
                for (int j = i; j <= lastIndex; ++j) {
                    SQLHelper sqlHelper = helpers2333333332.get(j);
                    SQLHelperCreator.setParameter(this.getOptions(), ps, sqlHelper.getParameters(), conn);
                    ps.addBatch();
                }
                ps.executeBatch();
                if (rdId != null && rdId.autoIncrement()) {
                    ResultSet seqRs = ps.getGeneratedKeys();
                    int j = i;
                    while (seqRs.next()) {
                        Object key = seqRs.getObject(1);
                        S s = ts.get(j);
                        helper.setId(s, key);
                        ++j;
                    }
                    seqRs.close();
                }
                ps.clearBatch();
            }
            if (!autoCommit) {
                conn.commit();
            }
            if (conn == null || autoCommit) break block25;
            try {
                conn.setAutoCommit(true);
                break block25;
            }
            catch (SQLException helpers2333333332) {
                // empty catch block
            }
            break block25;
            catch (SQLException e) {
                try {
                    if (!autoCommit && rollback) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    throw new ORMBatchException(e, ts.size(), index);
                }
                catch (Throwable throwable) {
                    if (conn != null && !autoCommit) {
                        try {
                            conn.setAutoCommit(true);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
        }
        this.closeConnection(rs, ps, conn);
        return ts;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean batchUpdates(List ts, String[] columns, int batchCount, boolean autoCommit, boolean rollback) {
        Connection conn;
        PreparedStatement ps;
        ResultSet rs;
        boolean result;
        block22: {
            List<SQLHelper> helpers2333333332;
            int index;
            block20: {
                boolean bl;
                block21: {
                    result = false;
                    if (ts == null || ts.isEmpty()) {
                        return result;
                    }
                    rs = null;
                    ps = null;
                    conn = null;
                    index = 0;
                    helpers2333333332 = SQLHelperCreator.updates(ts, columns == null ? null : Arrays.asList(columns));
                    if (!helpers2333333332.isEmpty()) break block20;
                    bl = result;
                    if (conn == null || autoCommit) break block21;
                    try {
                        conn.setAutoCommit(true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.closeConnection(rs, ps, conn);
                return bl;
            }
            SQLHelper helper = helpers2333333332.get(0);
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "batchUpdates", helper);
            conn = this.getConnection();
            if (!autoCommit) {
                conn.setAutoCommit(false);
            }
            ps = conn.prepareStatement(helper.getSql());
            for (int i = 0; i < helpers2333333332.size(); i += batchCount) {
                index = i;
                int lastIndex = Math.min(i + batchCount, helpers2333333332.size()) - 1;
                if (i > lastIndex) continue;
                for (int j = i; j <= lastIndex; ++j) {
                    SQLHelper sqlHelper = helpers2333333332.get(j);
                    SQLHelperCreator.setParameter(this.getOptions(), ps, sqlHelper.getParameters(), conn);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
            }
            if (!autoCommit) {
                conn.commit();
            }
            result = true;
            if (conn == null || autoCommit) break block22;
            try {
                conn.setAutoCommit(true);
                break block22;
            }
            catch (SQLException helpers2333333332) {
                // empty catch block
            }
            break block22;
            catch (SQLException e) {
                try {
                    if (!autoCommit && rollback) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    throw new ORMBatchException(e, ts.size(), index);
                }
                catch (Throwable throwable) {
                    if (conn != null && !autoCommit) {
                        try {
                            conn.setAutoCommit(true);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
        }
        this.closeConnection(rs, ps, conn);
        return result;
    }

    @Override
    public boolean batchUpdates(List ts, String[] columns, boolean rollback) {
        return this.batchUpdates(ts, columns, ts.size(), !rollback, rollback);
    }

    @Override
    public boolean batchUpdates(List ts, int batchCount) {
        return this.batchUpdates(ts, null, ts.size(), true, false);
    }

    @Override
    public boolean batchUpdates(List ts, int batchCount, boolean autoCommit) {
        return this.batchUpdates(ts, null, batchCount, autoCommit, false);
    }

    @Override
    public boolean batchUpdates(List ts, int batchCount, boolean autoCommit, boolean rollback) {
        return this.batchUpdates(ts, null, batchCount, autoCommit, rollback);
    }

    @Override
    public boolean batchUpdates(List ts, boolean rollback) {
        return this.batchUpdates(ts, null, ts.size(), !rollback, rollback);
    }

    @Override
    public boolean batchUpdates(List ts, String[] columns, int batchCount) {
        return this.batchUpdates(ts, columns, batchCount, true, false);
    }

    @Override
    public boolean batchUpdates(List ts, String[] columns, int batchCount, boolean autoCommit) {
        return this.batchUpdates(ts, columns, batchCount, autoCommit, false);
    }

    @Override
    public void createOrUpdate(Class<?> table) throws ORMException {
        if (table == null) {
            throw new ORMException("Table is null.");
        }
        RdTable rdTable = ORMUtils.getRdTable(table);
        if (rdTable == null) {
            throw new ORMException(String.format("Class[%s] Table annotation(RdTable) not found.", table.getName()));
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMException(String.format("Create Or update Not Support. [%s]", table.getName()));
        }
        Connection temp = null;
        try {
            List<String> sqls;
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "createOrUpdate", table);
            temp = this.getConnection();
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, rdTable);
            List<ColumnInfo> columnInfoList = ORMUtils.getColumnInfo(table);
            if (queryTable == null && columnInfoList.isEmpty() && !rdTable.dropped()) {
                throw new ORMException(String.format("Class[%s] Table[%s], column(RdColumn) is empty.", table.getName(), rdTable.name()));
            }
            List<TableColumn> columns = null;
            if (queryTable != null && !rdTable.dropped()) {
                columns = options.columns(connection, rdTable);
            }
            if ((sqls = options.createOrUpdateSqls(connection, rdTable, columnInfoList, queryTable != null, columns)) != null && !sqls.isEmpty()) {
                for (String sql : sqls) {
                    ORMUtils.handleDebugInfo(SQLServiceImpl.class, "createOrUpdate", sql, sqls, table);
                    PreparedStatement ps = null;
                    try {
                        ps = temp.prepareStatement(sql);
                        ps.execute();
                    }
                    catch (SQLException e) {
                        throw new ORMException(e);
                    }
                    finally {
                        this.closeConnection(null, ps, null);
                    }
                }
            }
            this.closeConnection(null, null, temp);
        }
        catch (Exception e) {
            try {
                throw new ORMSQLException(e, "createOrUpdate," + table.getName()).put("class", table);
            }
            catch (Throwable throwable) {
                this.closeConnection(null, null, temp);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(Table table) throws ORMException {
        if (table == null) {
            throw new ORMException("Table is null.");
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMException(String.format("Drop table Not Support. [%s]", table.getName()));
        }
        Connection temp = null;
        try {
            ORMUtils.handleDebugInfo(SQLServiceImpl.class, "drop", table);
            temp = this.getConnection();
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, table);
            if (queryTable != null) {
                String sql = options.dropTable(table);
                ORMUtils.handleDebugInfo(SQLServiceImpl.class, "drop", table, sql);
                PreparedStatement ps = null;
                try {
                    ps = temp.prepareStatement(sql);
                    ps.execute();
                }
                catch (SQLException e) {
                    throw new ORMSQLException(e, "drop").put("table", table);
                }
                finally {
                    this.closeConnection(null, ps, null);
                }
            } else {
                ORMUtils.handleDebugInfo(SQLServiceImpl.class, "Table not exist : " + table.getName(), table);
            }
            this.closeConnection(null, null, temp);
        }
        catch (Throwable throwable) {
            this.closeConnection(null, null, temp);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdate(Table table, List<TableColumn> tableColumns) throws ORMException {
        if (table == null) {
            throw new ORMException("Table is null.");
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Create Or update Table Not Support : " + table.getName()).put("table", table).put("tableColumns", tableColumns);
        }
        Connection temp = this.getConnection();
        try {
            List<String> sqls;
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, table);
            List<TableColumn> columns = null;
            if (queryTable != null) {
                columns = options.columns(connection, table.getName());
            }
            if ((sqls = options.createOrUpdateSqls(connection, table, tableColumns, columns, queryTable != null)) != null && !sqls.isEmpty()) {
                for (String sql : sqls) {
                    ORMUtils.handleDebugInfo(SQLServiceImpl.class, "createOrUpdate", sql, sqls, table, tableColumns);
                    PreparedStatement ps = null;
                    try {
                        ps = temp.prepareStatement(sql);
                        ps.execute();
                    }
                    catch (SQLException e) {
                        throw new ORMSQLException(e, "createOrUpdate").put("sql", sql).put("table", table).put("tableColumns", tableColumns);
                    }
                    finally {
                        this.closeConnection(null, ps, null);
                    }
                }
            }
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public boolean tableExists(String table) {
        if (StringUtils.isEmpty((Object)table)) {
            throw new ORMException("Table is empty.");
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query Table Not Support : " + table).put("table", table);
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            boolean bl = options.tableExists(connection, table);
            return bl;
        }
        catch (ORMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ORMSQLException(e, "tableExists").put("table", table);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public String getTableName(Class<?> clazz) throws ORMException {
        if (clazz == null) {
            throw new ORMException("Class is null.");
        }
        RdTable rdTable = ORMUtils.getRdTable(clazz);
        if (rdTable == null) {
            throw new ORMException(String.format("Class[%s] Table annotation(RdTable) not found.", clazz.getName()));
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query Table Not Support : " + rdTable.name()).put("class", clazz);
        }
        return options.getTableName(rdTable);
    }

    @Override
    public Table table(Class<?> clazz) throws ORMException {
        if (clazz == null) {
            throw new ORMException("Class is null.");
        }
        RdTable rdTable = ORMUtils.getRdTable(clazz);
        if (rdTable == null) {
            throw new ORMException(String.format("Class[%s] Table annotation(RdTable) not found.", clazz.getName()));
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query Table Not Support : " + rdTable.name()).put("class", clazz);
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            Table table = options.table(connection, rdTable);
            return table;
        }
        catch (ORMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ORMSQLException(e, "table").put("class", clazz);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public Table table(String tableName) {
        if (ORMUtils.isEmpty(tableName)) {
            throw new ORMException("TableName is empty");
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query Table Not Support : " + tableName).put("tableName", tableName);
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            Table table = options.table(connection, new Table(tableName));
            return table;
        }
        catch (ORMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ORMSQLException(e, "table").put("tableName", tableName);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public List<TableColumn> columns(Class<?> clazz) throws ORMException {
        if (clazz == null) {
            throw new ORMException("Class is null");
        }
        RdTable rdTable = ORMUtils.getRdTable(clazz);
        if (rdTable == null) {
            throw new ORMException(String.format("Class[%s] Table annotation(RdTable) not found.", clazz.getName()));
        }
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query columns Not Support : " + clazz.getName()).put("class", clazz);
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            Table queryTable = options.table(connection, rdTable);
            List<TableColumn> columns = null;
            if (queryTable != null && !rdTable.dropped()) {
                columns = options.columns(connection, rdTable);
            }
            List<TableColumn> list = columns;
            return list;
        }
        catch (ORMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ORMSQLException(e, "columns").put("class", clazz);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public List<Table> tables() {
        return this.tables(null);
    }

    @Override
    public List<Table> tables(String keyword) {
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query tables Not Support.").put("keyword", keyword);
        }
        Connection temp = this.getConnection();
        try {
            Connection connection = this.getRealConnection(temp);
            List<Table> list = options.tables(connection, keyword);
            return list;
        }
        catch (ORMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ORMSQLException(e, "tables").put("keyword", keyword);
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableColumn> tableColumns(String tableName) {
        Connection temp = this.getConnection();
        try {
            List<TableColumn> list = this.tableColumns(temp, tableName);
            return list;
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    @Override
    public List<TableColumn> tableColumns(Connection temp, String tableName) {
        List<TableColumn> columns = null;
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query Table Columns Not Support : " + tableName).put("connection", temp).put("tableName", tableName);
        }
        try {
            columns = options.columns(temp, tableName);
        }
        catch (ORMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ORMSQLException(e, "tableColumns").put("connection", temp).put("tableName", tableName);
        }
        if (columns != null && !columns.isEmpty()) {
            List<ColumnClass> columnClasses = this.tableColumnsClass(tableName);
            HashMap<String, String> columnClassMap = new HashMap<String, String>();
            for (ColumnClass columnClass : columnClasses) {
                columnClassMap.put(columnClass.getColumn(), columnClass.getColumnClass());
                columnClassMap.put(columnClass.getColumn().toUpperCase(Locale.ROOT), columnClass.getColumnClass());
                columnClassMap.put(columnClass.getColumn().toLowerCase(Locale.ROOT), columnClass.getColumnClass());
            }
            for (TableColumn tableColumn : columns) {
                tableColumn.setColumnClass((String)columnClassMap.get(tableColumn.getColumn()));
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnClass> tableColumnsClass(String tableName) {
        Connection temp = null;
        try {
            temp = this.getConnection();
            List<ColumnClass> list = this.tableColumnsClass(temp, tableName);
            return list;
        }
        finally {
            this.closeConnection(null, null, temp);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ColumnClass> tableColumnsClass(Connection temp, String tableName) {
        ArrayList<ColumnClass> arrayList;
        Options options = this.getOptions();
        if (options == null) {
            throw new ORMSQLException("Query Table Columns Not Support : " + tableName).put("connection", temp).put("tableName", tableName);
        }
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<ColumnClass> columnClasses = new ArrayList<ColumnClass>();
        try {
            String sql = String.format("SELECT * FROM %s WHERE 1 <> 1", tableName);
            stmt = temp.createStatement();
            rs = stmt.executeQuery(sql);
            ResultSetMetaData data = rs.getMetaData();
            int count = data.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String className = data.getColumnClassName(i);
                String columnName = data.getColumnName(i);
                int precision = data.getPrecision(i);
                int scale = data.getScale(i);
                ColumnClass columnClass = new ColumnClass(tableName, columnName, className);
                columnClass.setPrecision(precision);
                columnClass.setScale(scale);
                columnClasses.add(columnClass);
            }
            arrayList = columnClasses;
        }
        catch (ORMException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ORMSQLException(e2, "tableColumnsClass").put("connection", temp).put("tableName", tableName);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, stmt, null);
                throw throwable;
            }
        }
        this.closeConnection(rs, stmt, null);
        return arrayList;
    }
}

