/*
 * Copyright 2017 @objectsql.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.objectsql.query;


import com.objectsql.support.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface MultiQuery extends IQuery {

    static MultiQuery newQuery(){
        return new MultiQueryImpl();
    }

    static MultiQuery newQuery(String id){
        MultiQuery multiQuery = new MultiQueryImpl();
        multiQuery.setId(id);
        return multiQuery;
    }

    MultiQuery createQuery(Class<?> clazz, Column... columns);//select a.id, a.name from
    MultiQuery createQuery(Class<?> clazz, Columns... columns);//select a.id, a.name from
    MultiQuery createQuery(Column ... columns);

    MultiQuery addReturnColumn(Column ... columns);
    MultiQuery addReturnColumn(Columns ... columns);
    MultiQuery clearReturnColumns();

    MultiQuery addFixedReturnColumn(Column ... columns);
    MultiQuery addFixedReturnColumn(Columns ... columns);
    MultiQuery clearFixedReturnColumns();

    AliasTable table(IQuery query);
    AliasTable table(Class<?> clazz);
    AliasTable table(String table);
    AliasTable table(String table, String alias);
    AliasTable table(IQuery query, String alias);
    AliasTable table(Class<?> clazz, String alias);

    AliasTable join(IQuery query);
    AliasTable join(Class<?> clazz);
    AliasTable join(IQuery query, String alias);
    AliasTable join(Class<?> clazz, String alias);

    AliasTable join(Class<?> clazz, String clazzColumn, Column tableColumn);
    AliasTable join(Class<?> clazz, JoinType joinType, String clazzColumn, Column tableColumn);

    <T,R> AliasTable join(Class<?> clazz, LambdaQuery<T,R> clazzColumn, Column tableColumn);
    <T,R> AliasTable join(Class<?> clazz, JoinType joinType, LambdaQuery<T,R> clazzColumn, Column tableColumn);

    MultiQuery whereEqual(Column left, Object value);
    MultiQuery whereNotEqual(Column left, Object value);

    MultiQuery whereLike(Column left, String value);
    MultiQuery whereNotLike(Column left, String value);
    MultiQuery whereStartWith(Column left, String value);
    MultiQuery whereEndWith(Column left, String value);
    MultiQuery whereNotStartWith(Column left, String value);
    MultiQuery whereNotEndWith(Column left, String value);

    MultiQuery whereLess(Column left, Object value);
    MultiQuery whereLessEqual(Column left, Object value);
    MultiQuery whereMore(Column left, Object value);
    MultiQuery whereMoreEqual(Column left, Object value);

    MultiQuery whereIsNull(Column left);
    MultiQuery whereIsNotNull(Column left);
    MultiQuery whereIsEmpty(Column left);
    MultiQuery whereIsNotEmpty(Column left);

    MultiQuery whereIn(Column left, Collection value);
    MultiQuery whereNotIn(Column left, Collection value);

    MultiQuery whereInValues(Column left, Object ... values);
    MultiQuery whereNotInValues(Column left, Object ... values);

    MultiQuery whereInQuery(Column left, MultiQuery query);
    MultiQuery whereNotInQuery(Column left, MultiQuery query);

    MultiQuery whereBetween(Column left, Object value, Object andValue);

    MultiQuery where(Column left, Object value, ExpressionType type);
    MultiQuery where(Column left, Column value);
    MultiQuery where(Condition condition);
    MultiQuery where(Expression... expressions);
    MultiQuery group(Column ...columns);
    MultiQuery group(Columns ...columns);
    MultiQuery groupCountSelectColumn(Column ... columns);

    MultiQuery having(Column left, Object value, ExpressionType type);
    MultiQuery having(Column left, Column value);
    MultiQuery having(Condition condition);
    MultiQuery having(Expression expression);

    MultiQuery orderDesc(Column column);
    MultiQuery orderAsc(Column column);
    MultiQuery order(Order order);
    MultiQuery orders(List<Order> orders);

    MultiQuery join(Join join);
    MultiQuery join(AliasTable table, Column left, Column right);
    MultiQuery join(AliasTable table, JoinType joinType, Column left, Column right);
    MultiQuery distinct();

    MultiQuery enableDataPermission();
    MultiQuery disableDataPermission();
    boolean isEnableDataPermission();

    String dataKey(Object dataType);
    MultiQuery dataColumn(Object dataType, Column column);
    MultiQuery dataColumn(Object dataType, String dataKey, Column column);
    Column dataColumn(Object dataType);

    boolean containsAlias(String alias);
    void addUsedAlias(String alias);

    MultiQuery whereExists(MultiQuery query);
    MultiQuery whereNotExists(MultiQuery query);

    MultiQuery newMultiQuery();

    MultiQuery parentQuery();

    List<String> getAliasList();

    Map<String, Object> getAliasTable();
    List<Join> getJoins();

//    MultiQuery union(IMultiQuery query);
//    MultiQuery unionAll(IMultiQuery query);
}
