/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.spring;

import com.objectsql.support.ChangeHolder;
import com.objectsql.utils.ORMUtils;
import java.util.UUID;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class MultiTransactionManager
extends JtaTransactionManager {
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        String key = "jta-transaction-" + UUID.randomUUID().toString();
        ORMUtils.handleDebugInfo(MultiTransactionManager.class, "begin", key);
        ChangeHolder.set(key);
        super.doBegin(transaction, definition);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        ORMUtils.handleDebugInfo(MultiTransactionManager.class, "commit", ChangeHolder.get());
        super.doCommit(status);
        ChangeHolder.change();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        ORMUtils.handleDebugInfo(MultiTransactionManager.class, "rollback", ChangeHolder.get());
        ChangeHolder.remove();
        super.doRollback(status);
    }
}

