package com.paymentplugins;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * The XMLNode class contains values for the xml nodes that are children of this node. 
 * @author Clayton
 *
 */
public abstract class XMLNode {

	public String name;
	
	private String value;
	
	private List<XMLNode> content = new LinkedList<XMLNode>();
	
	public XMLNode(String name){
		this.name = name;
	}
	
	/**
	 * Search through all the nodes contained in this node and find the matching node based on the name.
	 * Each node is looped through until either the node is found or null is returned.  
	 * @param name - The string of the name given to the XMLNode being searched for. 
	 * @return Returns an instance of XMLNode associated with the given name.
	 */
	public XMLNode findNode(String name){
		XMLNode returnNode = null;
		for(XMLNode node : this.content){
			if(node.name.equals(name)){
				return node;
			}
			else{
				if((returnNode = node.findNode(name)) != null){
					break;
				}
			}
		}
		return returnNode;
	}
	
	public void addNode(XMLNode node){
		this.content.add(node);
	}
	
	public void addValue(String value){
		this.value = value;
	}
	
	public String getValue(){
		return this.value;
	}
	
	public String getString(String name){
		String value = null;
		if(this.name.equals(name)){
			value = this.value;
		}
		else{
			for(XMLNode node : this.content){
				if((value = node.getString(name))!= null){
					break;
				}
			}
		}
		return value;
	}
	
	public List<XMLNode> findAll(String name){
		String[] parentChild = name.split("/");
		ArrayList<XMLNode> list = new ArrayList<XMLNode>();
		XMLNode rootNode = this.findNode(parentChild[0]);
		for(XMLNode node : rootNode.content){
			if(node.name.equals(parentChild[1])){
				list.add(node);
			}
		}
		return list;
	}
}
