/*
 * Decompiled with CFR 0.152.
 */
package com.protegrity.ap.java;

import com.protegrity.ap.java.Authenticator;
import com.protegrity.ap.java.CoreproviderAdapter;
import com.protegrity.ap.java.InitializationException;
import com.protegrity.ap.java.PTYCharset;
import com.protegrity.ap.java.ParseResult;
import com.protegrity.ap.java.ProtectorException;
import com.protegrity.ap.java.SessionHandler;
import com.protegrity.ap.java.SessionObject;
import com.protegrity.ap.java.SessionTimeoutException;
import java.util.Date;

public class Protector {
    public static final String HOST = "api.developer-edition.protegrity.com";
    public static final String VERSION = "1";
    private static final String ENCODING_UTF8 = "utf8";
    private static final String ENCODING_BASE64 = "base64";
    private static final String OPERATION_PROTECT = "protect";
    private static final String OPERATION_UNPROTECT = "unprotect";
    private static final String OPERATION_REPROTECT = "reprotect";
    private static Protector instance = null;
    private CoreproviderAdapter coreproviderAdapter = null;
    private static SessionHandler sessionHandler = null;
    private String apiKey;
    private String jwtToken;

    private Protector(SessionHandler sessionHandler) throws ProtectorException {
        this.coreproviderAdapter = new CoreproviderAdapter(sessionHandler);
    }

    public static synchronized Protector getProtector() throws ProtectorException {
        if (instance == null) {
            try {
                Authenticator authenticator = new Authenticator();
                String apiKey = authenticator.getApiKey();
                String jwtToken = authenticator.getJwtToken();
                sessionHandler = new SessionHandler(15);
                instance = new Protector(sessionHandler);
                Protector.instance.apiKey = apiKey;
                Protector.instance.jwtToken = jwtToken;
            }
            catch (InitializationException e) {
                throw new ProtectorException("Failed to Initialize Protector", e);
            }
        }
        return instance;
    }

    public String getVersion() {
        return this.coreproviderAdapter.getVersion();
    }

    public String getVersionEx() {
        return String.format("SDK Version: %s, Core Version: %s", this.coreproviderAdapter.getVersion(), this.coreproviderAdapter.getCoreVersion());
    }

    @Deprecated
    public String getCoreVersion() {
        return this.coreproviderAdapter.getCoreVersion();
    }

    public String getLastError(SessionObject session) throws ProtectorException, SessionTimeoutException {
        return sessionHandler.getLastError(session);
    }

    public synchronized SessionObject createSession(String policyUser) throws ProtectorException {
        return sessionHandler.createSession(policyUser);
    }

    @Deprecated
    public synchronized void closeSession(SessionObject session) throws ProtectorException {
        sessionHandler.closeSession(session);
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, short[] input, short[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        if (success) {
            short[] converted = (short[])result.getConvertedArray();
            System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        }
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, short[] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        if (success) {
            byte[][] converted = (byte[][])result.getConvertedArray();
            System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        }
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, short[] input, short[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, short[] input, byte[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, int[] input, int[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        if (success) {
            int[] converted = (int[])result.getConvertedArray();
            System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        }
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, int[] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, int[] input, int[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, int[] input, byte[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, long[] input, long[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, long[] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, long[] input, long[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, long[] input, byte[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, float[] input, float[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, float[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        float[] converted = (float[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, float[] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, double[] input, double[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, double[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        double[] converted = (double[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, double[] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, Date[] input, Date[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, Date[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        Date[] converted = (Date[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, String[] input, String[] output) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, input, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, String[] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, String[] input, String[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, input, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, String[] input, byte[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, char[][] input, char[][] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, char[][] input, byte[][] output) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, char[][] input, char[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, char[][] input, byte[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        byte[][] inputBytes = this.coreproviderAdapter.convertToByteArray(input, ENCODING_UTF8);
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(inputBytes);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, byte[][] input, byte[][] output, PTYCharset ... ptyCharsets) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, byte[][] input, byte[][] output, byte[] externalIv, PTYCharset ... ptyCharsets) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean protect(SessionObject sessionObj, String dataElementName, String[] input, String[] output, byte[] externalIv, byte[] externalTweak) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, input, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_PROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, short[] input, short[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, short[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, short[] input, short[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, short[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, int[] input, int[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, int[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, int[] input, int[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, int[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, long[] input, long[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, long[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, long[] input, long[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, long[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, float[] input, float[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, float[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        float[] converted = (float[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, float[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, float[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        float[] converted = (float[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, double[] input, double[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, double[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        double[] converted = (double[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, double[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, double[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        double[] converted = (double[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, Date[] input, Date[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, Date[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        Date[] converted = (Date[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, String[] input, String[] output) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, input, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, String[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, String[] input, String[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, input, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, String[] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, char[][] input, char[][] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, char[][] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, char[][] input, char[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, char[][] output, byte[] externalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, byte[][] output, PTYCharset ... ptyCharsets) throws ProtectorException, SessionTimeoutException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, byte[][] input, byte[][] output, byte[] externalIv, PTYCharset ... ptyCharsets) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, stringInput, externalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean unprotect(SessionObject sessionObj, String dataElementName, String[] input, String[] output, byte[] externalIv, byte[] externalTweak) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildProtectPayload(sessionObj.getUser(), dataElementName, input, externalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_UNPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, short[] input, short[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, short[] input, short[] output, byte[] newExternalIv, byte[] oldExternalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, newExternalIv, oldExternalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, short[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        short[] converted = (short[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, int[] input, int[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, int[] input, int[] output, byte[] newExternalIv, byte[] oldExternalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, newExternalIv, oldExternalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, int[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        int[] converted = (int[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, long[] input, long[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, long[] input, long[] output, byte[] newExternalIv, byte[] oldExternalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, newExternalIv, oldExternalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, long[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        long[] converted = (long[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, float[] input, float[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, float[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        float[] converted = (float[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, double[] input, double[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, double[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        double[] converted = (double[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, Date[] input, Date[] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, Date[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        Date[] converted = (Date[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, String[] input, String[] output) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, input, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, String[] input, String[] output, byte[] newExternalIv, byte[] oldExternalIv) throws ProtectorException, SessionTimeoutException {
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, input, newExternalIv, oldExternalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, String[].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        String[] converted = (String[])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, char[][] input, char[][] output) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, char[][] input, char[][] output, byte[] newExternalIv, byte[] oldExternalIv) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, newExternalIv, oldExternalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, char[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        char[][] converted = (char[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, byte[][] input, byte[][] output, PTYCharset ... ptyCharsets) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, null, null, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, byte[][] input, byte[][] output, byte[] newExternalIv, byte[] oldExternalIv, PTYCharset ... ptyCharsets) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, newExternalIv, oldExternalIv, ENCODING_BASE64);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_BASE64);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public boolean reprotect(SessionObject sessionObj, String newDataElementName, String oldDataElementName, String[] input, String[] output, byte[] newExternalIv, byte[] oldExternalIv, byte[] newExternalTweak, byte[] oldExternalTweak) throws ProtectorException, SessionTimeoutException {
        String[] stringInput = this.coreproviderAdapter.convertToStringArray(input);
        String jsonPayload = this.coreproviderAdapter.buildReprotectPayload(sessionObj.getUser(), newDataElementName, oldDataElementName, stringInput, newExternalIv, oldExternalIv, ENCODING_UTF8);
        String response = this.coreproviderAdapter.sendApiRequest(OPERATION_REPROTECT, Protector.instance.jwtToken, Protector.instance.apiKey, jsonPayload);
        ParseResult result = this.coreproviderAdapter.parseResultsToOutput(sessionObj, response, byte[][].class, ENCODING_UTF8);
        boolean success = result.isSuccess();
        byte[][] converted = (byte[][])result.getConvertedArray();
        System.arraycopy(converted, 0, output, 0, Math.min(output.length, converted.length));
        return success;
    }

    public void flushAudits() throws ProtectorException {
        this.coreproviderAdapter.flush();
    }
}

