/*
 * Decompiled with CFR 0.152.
 */
package com.protegrity.ap.java;

import com.protegrity.ap.java.ProtectorException;
import com.protegrity.ap.java.SessionObject;
import com.protegrity.ap.java.SessionTimeoutException;
import java.lang.reflect.Field;
import java.util.Date;

public class SessionHandler {
    private int timeToLive = 0;

    public SessionHandler(int sessionTimeout) {
        this.timeToLive = sessionTimeout * 60 * 1000;
    }

    public SessionObject createSession(String apiUser) throws ProtectorException {
        if (null == apiUser) {
            throw new ProtectorException("Null input");
        }
        if ("".equals(apiUser)) {
            throw new ProtectorException("Empty input");
        }
        return new SessionObject(apiUser);
    }

    @Deprecated
    public void closeSession(SessionObject session) throws ProtectorException {
        try {
            Field[] fields;
            for (Field field : fields = session.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                field.set(session, null);
            }
        }
        catch (Throwable e) {
            throw new ProtectorException(e.getMessage());
        }
    }

    private boolean isValid(SessionObject session) {
        if (null == session) {
            return false;
        }
        if (session.getSessionId() == null) {
            return false;
        }
        Date now = new Date();
        return now.getTime() - session.getTimeStamp().getTime() < (long)this.timeToLive;
    }

    public String getUser(SessionObject session) throws ProtectorException {
        if (!this.isValid(session)) {
            throw new SessionTimeoutException("Session timeout or invalid");
        }
        return session.getUser();
    }

    public void setLastError(SessionObject session, String errorMessage) throws ProtectorException {
        session.setLastError(errorMessage);
    }

    public String getLastError(SessionObject session) throws ProtectorException {
        return session.getLastError();
    }
}

