/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.pushnotifications;

import com.google.gson.Gson;
import com.pusher.pushnotifications.PublishNotificationResponse;
import com.pusher.pushnotifications.PushNotificationErrorResponse;
import com.pusher.pushnotifications.PusherAuthError;
import com.pusher.pushnotifications.PusherMissingInstanceError;
import com.pusher.pushnotifications.PusherServerError;
import com.pusher.pushnotifications.PusherValidationError;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J*\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pusher/pushnotifications/PushNotifications;", "", "instanceId", "", "secretKey", "(Ljava/lang/String;Ljava/lang/String;)V", "baseURL", "gson", "Lcom/google/gson/Gson;", "interestsMaxLength", "", "extractErrorDescription", "responseBody", "publish", "interests", "", "publishRequest", "", "validateInterests", "", "pusher-push-notification-java"})
public final class PushNotifications {
    private final Gson gson;
    private final int interestsMaxLength = 164;
    private final String baseURL;
    private final String instanceId;
    private final String secretKey;

    @NotNull
    public final String publish(@NotNull List<String> interests, @NotNull Map<String, ? extends Object> publishRequest) throws IOException, InterruptedException, URISyntaxException {
        int statusCode;
        CloseableHttpResponse response;
        Intrinsics.checkParameterIsNotNull(interests, (String)"interests");
        Intrinsics.checkParameterIsNotNull(publishRequest, (String)"publishRequest");
        this.validateInterests(interests);
        Map publishRequestWithInterests = MapsKt.toMutableMap(publishRequest);
        publishRequestWithInterests.put("interests", interests);
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost("" + this.baseURL + "/instances/" + this.instanceId + "/publishes");
        httpPost.setEntity((HttpEntity)new StringEntity(this.gson.toJson((Object)publishRequestWithInterests)));
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Bearer %s";
        Object[] objectArray = new Object[]{this.secretKey};
        String string2 = "Authorization";
        HttpPost httpPost2 = httpPost;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String string4 = string3;
        httpPost2.setHeader(string2, string4);
        CloseableHttpResponse closeableHttpResponse = response = client.execute((HttpUriRequest)httpPost);
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
        String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        int n = statusCode = statusLine.getStatusCode();
        if (n == 401) {
            String string5 = responseBody;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"responseBody");
            throw (Throwable)new PusherAuthError(this.extractErrorDescription(string5));
        }
        if (n == 404) {
            String string6 = responseBody;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"responseBody");
            throw (Throwable)new PusherMissingInstanceError(this.extractErrorDescription(string6));
        }
        int n2 = n;
        if (400 <= n2 && 499 >= n2) {
            String string7 = responseBody;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"responseBody");
            throw (Throwable)new PusherValidationError(this.extractErrorDescription(string7));
        }
        int n3 = n;
        if (500 <= n3 && 599 >= n3) {
            String string8 = responseBody;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"responseBody");
            throw (Throwable)new PusherServerError(this.extractErrorDescription(string8));
        }
        return ((PublishNotificationResponse)this.gson.fromJson(responseBody, PublishNotificationResponse.class)).getPublishId();
    }

    private final String extractErrorDescription(String responseBody) {
        return ((PushNotificationErrorResponse)this.gson.fromJson(responseBody, PushNotificationErrorResponse.class)).getDescription();
    }

    private final void validateInterests(List<String> interests) {
        Object v0;
        Object object;
        block4: {
            if (interests.isEmpty()) {
                throw (Throwable)new IllegalArgumentException("Publish method expects at least one interest");
            }
            object = interests;
            if (object.size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(interests)), (Object)"")) {
                throw (Throwable)new IllegalArgumentException("interest should not be an empty string");
            }
            object = interests;
            Iterable iterable = object;
            for (Object e : iterable) {
                String it = (String)e;
                if (!(it.length() > this.interestsMaxLength)) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        String string = v0;
        if (string != null) {
            Object it = object = string;
            throw (Throwable)new IllegalArgumentException("interest " + (String)it + " is longer than the maximum of " + this.interestsMaxLength + " characters");
        }
    }

    public PushNotifications(@NotNull String instanceId, @NotNull String secretKey) {
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        this.instanceId = instanceId;
        this.secretKey = secretKey;
        this.gson = new Gson();
        this.interestsMaxLength = 164;
        this.baseURL = "https://" + this.instanceId + ".pushnotifications.pusher.com/publish_api/v1";
        CharSequence charSequence = this.instanceId;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("instanceId can't be an empty string");
        }
        charSequence = this.secretKey;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("secretKey can't be an empty string");
        }
    }
}

