/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.pushnotifications;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.gson.Gson;
import com.pusher.pushnotifications.PublishNotificationResponse;
import com.pusher.pushnotifications.PushNotificationErrorResponse;
import com.pusher.pushnotifications.PusherAuthError;
import com.pusher.pushnotifications.PusherMissingInstanceError;
import com.pusher.pushnotifications.PusherServerError;
import com.pusher.pushnotifications.PusherTooManyRequestsError;
import com.pusher.pushnotifications.PusherValidationError;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0003J*\u0010\u001b\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001aH\u0007J*\u0010\u001f\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001aH\u0007J*\u0010 \u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001aH\u0007R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pusher/pushnotifications/PushNotifications;", "", "instanceId", "", "secretKey", "(Ljava/lang/String;Ljava/lang/String;)V", "baseURL", "gson", "Lcom/google/gson/Gson;", "interestNameMaxLength", "", "maxRequestInterestsAllowed", "maxRequestUsersAllowed", "sdkVersion", "userIdMaxLength", "addRequestHeaders", "", "request", "Lorg/apache/http/client/methods/HttpRequestBase;", "checkForServerErrors", "responseStatusCode", "responseBody", "deleteUser", "userId", "extractErrorDescription", "generateToken", "", "publish", "interests", "", "publishRequest", "publishToInterests", "publishToUsers", "users", "pusher-push-notification-java"})
public final class PushNotifications {
    private final String sdkVersion = "1.1.1";
    private final Gson gson;
    private final int interestNameMaxLength = 164;
    private final int maxRequestInterestsAllowed = 100;
    private final int userIdMaxLength = 164;
    private final int maxRequestUsersAllowed = 1000;
    private final String baseURL;
    private final String instanceId;
    private final String secretKey;

    @NotNull
    public final Map<String, Object> generateToken(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        if (userId.length() > this.userIdMaxLength) {
            throw (Throwable)new IllegalArgumentException("User id (" + userId + ") is too long (expected less than " + (this.userIdMaxLength + 1) + ", got " + userId.length() + ')');
        }
        String iss = "https://" + this.instanceId + ".pushnotifications.pusher.com";
        LocalDateTime exp = LocalDateTime.now().plusDays(1L);
        String token = JWT.create().withSubject(userId).withIssuer(iss).withExpiresAt(Date.from(exp.toInstant(ZoneOffset.UTC))).sign(Algorithm.HMAC256((String)this.secretKey));
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"token", (Object)token));
    }

    @Deprecated(message="use publishToInterests instead", replaceWith=@ReplaceWith(imports={}, expression="publishToInterests(interests, publishRequest)"))
    @NotNull
    public final String publish(@NotNull List<String> interests, @NotNull Map<String, ? extends Object> publishRequest) throws IOException, InterruptedException, URISyntaxException {
        Intrinsics.checkParameterIsNotNull(interests, (String)"interests");
        Intrinsics.checkParameterIsNotNull(publishRequest, (String)"publishRequest");
        return this.publishToInterests(interests, publishRequest);
    }

    @NotNull
    public final String publishToInterests(@NotNull List<String> interests, @NotNull Map<String, ? extends Object> publishRequest) throws IOException, InterruptedException, URISyntaxException {
        CloseableHttpResponse response;
        Object v1;
        Object object;
        block4: {
            Intrinsics.checkParameterIsNotNull(interests, (String)"interests");
            Intrinsics.checkParameterIsNotNull(publishRequest, (String)"publishRequest");
            if (interests.isEmpty()) {
                throw (Throwable)new IllegalArgumentException("Publish method expects at least one interest");
            }
            object = interests;
            if (object.size() > this.maxRequestInterestsAllowed) {
                IllegalArgumentException illegalArgumentException;
                object = interests;
                StringBuilder stringBuilder = new StringBuilder().append("publish requests can only have up to ").append(this.maxRequestInterestsAllowed).append(" interests (given ");
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                IllegalArgumentException illegalArgumentException3 = illegalArgumentException;
                int n = object.size();
                illegalArgumentException2(stringBuilder.append(n).append(')').toString());
                throw (Throwable)illegalArgumentException3;
            }
            object = interests;
            Iterable iterable = object;
            for (Object e : iterable) {
                String it = (String)e;
                if (!(it.length() > this.interestNameMaxLength)) continue;
                v1 = e;
                break block4;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            Object it = object = string;
            throw (Throwable)new IllegalArgumentException("interest " + (String)it + " is longer than the maximum of " + this.interestNameMaxLength + " characters");
        }
        Map publishRequestWithInterests = MapsKt.toMutableMap(publishRequest);
        publishRequestWithInterests.put("interests", interests);
        HttpPost httpPost = new HttpPost("" + this.baseURL + "/publish_api/v1/instances/" + this.instanceId + "/publishes/interests");
        this.addRequestHeaders((HttpRequestBase)httpPost);
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(this.gson.toJson((Object)publishRequestWithInterests), "UTF-8"));
        CloseableHttpResponse closeableHttpResponse = response = HttpClients.createDefault().execute((HttpUriRequest)httpPost);
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
        String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        int statusCode = statusLine.getStatusCode();
        String string2 = responseBody;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"responseBody");
        this.checkForServerErrors(statusCode, string2);
        return ((PublishNotificationResponse)this.gson.fromJson(responseBody, PublishNotificationResponse.class)).getPublishId();
    }

    @NotNull
    public final String publishToUsers(@NotNull List<String> users, @NotNull Map<String, ? extends Object> publishRequest) throws IOException, InterruptedException, URISyntaxException {
        CloseableHttpResponse response;
        Object v1;
        Object object;
        block4: {
            Intrinsics.checkParameterIsNotNull(users, (String)"users");
            Intrinsics.checkParameterIsNotNull(publishRequest, (String)"publishRequest");
            if (users.isEmpty()) {
                throw (Throwable)new IllegalArgumentException("Publish method expects at least one user");
            }
            object = users;
            if (object.size() > this.maxRequestUsersAllowed) {
                IllegalArgumentException illegalArgumentException;
                object = users;
                StringBuilder stringBuilder = new StringBuilder().append("publish requests can only have up to ").append(this.maxRequestUsersAllowed).append(" users (given ");
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                IllegalArgumentException illegalArgumentException3 = illegalArgumentException;
                int n = object.size();
                illegalArgumentException2(stringBuilder.append(n).append(')').toString());
                throw (Throwable)illegalArgumentException3;
            }
            object = users;
            Iterable iterable = object;
            for (Object e : iterable) {
                String it = (String)e;
                if (!(it.length() > this.userIdMaxLength)) continue;
                v1 = e;
                break block4;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            Object it = object = string;
            throw (Throwable)new IllegalArgumentException("user id " + (String)it + " is longer than the maximum of " + this.userIdMaxLength + " characters");
        }
        Map publishRequestWithUsers = MapsKt.toMutableMap(publishRequest);
        publishRequestWithUsers.put("users", users);
        HttpPost httpPost = new HttpPost("" + this.baseURL + "/publish_api/v1/instances/" + this.instanceId + "/publishes/users");
        this.addRequestHeaders((HttpRequestBase)httpPost);
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(this.gson.toJson((Object)publishRequestWithUsers), "UTF-8"));
        CloseableHttpResponse closeableHttpResponse = response = HttpClients.createDefault().execute((HttpUriRequest)httpPost);
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
        String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        int statusCode = statusLine.getStatusCode();
        String string2 = responseBody;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"responseBody");
        this.checkForServerErrors(statusCode, string2);
        return ((PublishNotificationResponse)this.gson.fromJson(responseBody, PublishNotificationResponse.class)).getPublishId();
    }

    public final void deleteUser(@NotNull String userId) {
        CloseableHttpResponse response;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        if (userId.length() > this.userIdMaxLength) {
            throw (Throwable)new IllegalArgumentException("User id (" + userId + ") is too long (expected less than " + (this.userIdMaxLength + 1) + ", got " + userId.length() + ')');
        }
        String userIdURLEncoded = URLEncoder.encode(userId, "UTF-8");
        HttpDelete httpDelete = new HttpDelete("" + this.baseURL + "/customer_api/v1/instances/" + this.instanceId + "/users/" + userIdURLEncoded);
        this.addRequestHeaders((HttpRequestBase)httpDelete);
        CloseableHttpResponse closeableHttpResponse = response = HttpClients.createDefault().execute((HttpUriRequest)httpDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
        String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        int statusCode = statusLine.getStatusCode();
        String string = responseBody;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseBody");
        this.checkForServerErrors(statusCode, string);
    }

    private final void addRequestHeaders(HttpRequestBase request) {
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "Bearer " + this.secretKey);
        request.setHeader("X-Pusher-Library", "pusher-push-notifications-server-java " + this.sdkVersion);
    }

    private final void checkForServerErrors(int responseStatusCode, String responseBody) {
        int n = responseStatusCode;
        if (n == 401) {
            throw (Throwable)new PusherAuthError(this.extractErrorDescription(responseBody));
        }
        if (n == 404) {
            throw (Throwable)new PusherMissingInstanceError(this.extractErrorDescription(responseBody));
        }
        if (n == 429) {
            throw (Throwable)new PusherTooManyRequestsError(this.extractErrorDescription(responseBody));
        }
        int n2 = n;
        if (400 <= n2 && 499 >= n2) {
            throw (Throwable)new PusherValidationError(this.extractErrorDescription(responseBody));
        }
        int n3 = n;
        if (500 <= n3 && 599 >= n3) {
            throw (Throwable)new PusherServerError(this.extractErrorDescription(responseBody));
        }
    }

    private final String extractErrorDescription(String responseBody) {
        return ((PushNotificationErrorResponse)this.gson.fromJson(responseBody, PushNotificationErrorResponse.class)).getDescription();
    }

    public PushNotifications(@NotNull String instanceId, @NotNull String secretKey) {
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        this.instanceId = instanceId;
        this.secretKey = secretKey;
        this.sdkVersion = "1.1.1";
        this.gson = new Gson();
        this.interestNameMaxLength = 164;
        this.maxRequestInterestsAllowed = 100;
        this.userIdMaxLength = 164;
        this.maxRequestUsersAllowed = 1000;
        this.baseURL = "https://" + this.instanceId + ".pushnotifications.pusher.com";
        CharSequence charSequence = this.instanceId;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("instanceId can't be an empty string");
        }
        charSequence = this.secretKey;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("secretKey can't be an empty string");
        }
    }
}

