/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.impl.InternalChannel;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import java.util.HashMap;
import java.util.Map;

public class ChannelManager
implements ConnectionEventListener {
    private final Map<String, InternalChannel> channelNameToChannelMap = new HashMap<String, InternalChannel>();
    private final Factory factory;
    private InternalConnection connection;

    public ChannelManager(Factory factory) {
        this.factory = factory;
    }

    public void setConnection(InternalConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot construct ChannelManager with a null connection");
        }
        if (this.connection != null) {
            this.connection.unbind(ConnectionState.CONNECTED, this);
        }
        this.connection = connection;
        connection.bind(ConnectionState.CONNECTED, this);
    }

    public void subscribeTo(InternalChannel channel, ChannelEventListener listener, String ... eventNames) {
        this.validateArgumentsAndBindEvents(channel, listener, eventNames);
        this.channelNameToChannelMap.put(channel.getName(), channel);
        this.sendOrQueueSubscribeMessage(channel);
    }

    public void unsubscribeFrom(String channelName) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot unsubscribe from null channel");
        }
        InternalChannel channel = this.channelNameToChannelMap.remove(channelName);
        if (channel == null) {
            return;
        }
        channel.updateState(ChannelState.UNSUBSCRIBED);
        if (this.connection.getState() == ConnectionState.CONNECTED) {
            this.connection.sendMessage(channel.toUnsubscribeMessage());
        }
    }

    public void onMessage(String event, String wholeMessage) {
        String channelName;
        InternalChannel channel;
        Map json = (Map)new Gson().fromJson(wholeMessage, Map.class);
        Object channelNameObject = json.get("channel");
        if (channelNameObject != null && (channel = this.channelNameToChannelMap.get(channelName = (String)channelNameObject)) != null) {
            channel.onMessage(event, wholeMessage);
        }
    }

    @Override
    public void onConnectionStateChange(ConnectionStateChange change) {
        if (change.getCurrentState() == ConnectionState.CONNECTED) {
            for (InternalChannel channel : this.channelNameToChannelMap.values()) {
                this.sendOrQueueSubscribeMessage(channel);
            }
        }
    }

    @Override
    public void onError(String message, String code, Exception e) {
    }

    private void sendOrQueueSubscribeMessage(final InternalChannel channel) {
        this.factory.getEventQueue().execute(new Runnable(){

            @Override
            public void run() {
                if (ChannelManager.this.connection.getState() == ConnectionState.CONNECTED) {
                    try {
                        String message = channel.toSubscribeMessage();
                        ChannelManager.this.connection.sendMessage(message);
                        channel.updateState(ChannelState.SUBSCRIBE_SENT);
                    }
                    catch (AuthorizationFailureException e) {
                        ChannelManager.this.clearDownSubscription(channel, e);
                    }
                }
            }
        });
    }

    private void clearDownSubscription(final InternalChannel channel, final Exception e) {
        this.channelNameToChannelMap.remove(channel.getName());
        channel.updateState(ChannelState.FAILED);
        if (channel.getEventListener() != null) {
            this.factory.getEventQueue().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelEventListener eventListener = channel.getEventListener();
                    PrivateChannelEventListener privateChannelListener = (PrivateChannelEventListener)eventListener;
                    privateChannelListener.onAuthenticationFailure(e.getMessage(), e);
                }
            });
        }
    }

    private void validateArgumentsAndBindEvents(InternalChannel channel, ChannelEventListener listener, String ... eventNames) {
        if (channel == null) {
            throw new IllegalArgumentException("Cannot subscribe to a null channel");
        }
        if (this.channelNameToChannelMap.containsKey(channel.getName())) {
            throw new IllegalArgumentException("Already subscribed to a channel with name " + channel.getName());
        }
        for (String eventName : eventNames) {
            channel.bind(eventName, listener);
        }
        channel.setEventListener(listener);
    }
}

