/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.connection;

import com.pusher.client.connection.ConnectionState;

public class ConnectionStateChange {
    private final ConnectionState previousState;
    private final ConnectionState currentState;

    public ConnectionStateChange(ConnectionState previousState, ConnectionState currentState) {
        if (previousState == currentState) {
            throw new IllegalArgumentException("Attempted to create an connection state update where both previous and current state are: " + (Object)((Object)currentState));
        }
        this.previousState = previousState;
        this.currentState = currentState;
    }

    public ConnectionState getPreviousState() {
        return this.previousState;
    }

    public ConnectionState getCurrentState() {
        return this.currentState;
    }

    public int hashCode() {
        return this.previousState.hashCode() + this.currentState.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ConnectionStateChange) {
            ConnectionStateChange other = (ConnectionStateChange)obj;
            return this.currentState == other.currentState && this.previousState == other.previousState;
        }
        return false;
    }
}

