/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.PrivateEncryptedChannel;
import com.pusher.client.channel.PrivateEncryptedChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.util.HttpAuthorizer;

public class PrivateEncryptedChannelExampleApp {
    private String channelsKey = "FILL_ME_IN";
    private String channelName = "private-encrypted-channel";
    private String eventName = "my-event";
    private String cluster = "eu";
    private String authorizationEndpoint = "http://localhost:3030/pusher/auth";
    private PrivateEncryptedChannel channel;

    public static void main(String[] args) {
        new PrivateEncryptedChannelExampleApp(args);
    }

    private PrivateEncryptedChannelExampleApp(String[] args) {
        switch (args.length) {
            case 4: {
                this.cluster = args[3];
            }
            case 3: {
                this.eventName = args[2];
            }
            case 2: {
                this.channelName = args[1];
            }
            case 1: {
                this.channelsKey = args[0];
            }
        }
        HttpAuthorizer authorizer = new HttpAuthorizer(this.authorizationEndpoint);
        PusherOptions options = new PusherOptions().setCluster(this.cluster).setAuthorizer(authorizer).setForceTLS(true);
        Pusher pusher = new Pusher(this.channelsKey, options);
        ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

            @Override
            public void onConnectionStateChange(ConnectionStateChange change) {
                System.out.println(String.format("Connection state changed from [%s] to [%s]", new Object[]{change.getPreviousState(), change.getCurrentState()}));
            }

            @Override
            public void onError(String message, String code, Exception e) {
                System.out.println(String.format("An error was received with message [%s], code [%s], exception [%s]", message, code, e));
            }
        };
        pusher.connect(connectionEventListener, new ConnectionState[0]);
        PrivateEncryptedChannelEventListener privateEncryptedChannelEventListener = new PrivateEncryptedChannelEventListener(){

            @Override
            public void onSubscriptionSucceeded(String channelName) {
                System.out.println(String.format("Subscription to channel [%s] succeeded", channelName));
            }

            @Override
            public void onEvent(PusherEvent event) {
                System.out.println(String.format("Received event [%s]", event.toString()));
            }

            @Override
            public void onAuthenticationFailure(String message, Exception e) {
                System.out.println(String.format("Authentication failure due to [%s], exception was [%s]", message, e));
            }

            @Override
            public void onDecryptionFailure(String event, String reason) {
                System.out.println(String.format("An error was received decrypting message for event:[%s] - reason: [%s]", event, reason));
            }
        };
        this.channel = pusher.subscribePrivateEncrypted(this.channelName, privateEncryptedChannelEventListener, this.eventName);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

