/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.PusherEventDeserializer;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.InternalChannel;
import com.pusher.client.util.Factory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ChannelImpl
implements InternalChannel {
    protected final Gson GSON;
    private static final String INTERNAL_EVENT_PREFIX = "pusher_internal:";
    protected static final String SUBSCRIPTION_SUCCESS_EVENT = "pusher_internal:subscription_succeeded";
    protected final String name;
    private Set<SubscriptionEventListener> globalListeners = new HashSet<SubscriptionEventListener>();
    private final Map<String, Set<SubscriptionEventListener>> eventNameToListenerMap = new HashMap<String, Set<SubscriptionEventListener>>();
    protected volatile ChannelState state = ChannelState.INITIAL;
    private ChannelEventListener eventListener;
    private final Factory factory;
    private final Object lock = new Object();

    public ChannelImpl(String channelName, Factory factory) {
        GsonBuilder gsonBldr = new GsonBuilder();
        gsonBldr.registerTypeAdapter(PusherEvent.class, (Object)new PusherEventDeserializer());
        this.GSON = gsonBldr.create();
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot subscribe to a channel with a null name");
        }
        for (String disallowedPattern : this.getDisallowedNameExpressions()) {
            if (!channelName.matches(disallowedPattern)) continue;
            throw new IllegalArgumentException("Channel name " + channelName + " is invalid. Private channel names must start with \"private-\" and presence channel names must start with \"presence-\"");
        }
        this.name = channelName;
        this.factory = factory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        Object object = this.lock;
        synchronized (object) {
            Set<SubscriptionEventListener> listeners = this.eventNameToListenerMap.get(eventName);
            if (listeners == null) {
                listeners = new HashSet<SubscriptionEventListener>();
                this.eventNameToListenerMap.put(eventName, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindGlobal(SubscriptionEventListener listener) {
        this.validateArguments("", listener);
        Object object = this.lock;
        synchronized (object) {
            this.globalListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        Object object = this.lock;
        synchronized (object) {
            Set<SubscriptionEventListener> listeners = this.eventNameToListenerMap.get(eventName);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.eventNameToListenerMap.remove(eventName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindGlobal(SubscriptionEventListener listener) {
        this.validateArguments("", listener);
        Object object = this.lock;
        synchronized (object) {
            if (this.globalListeners != null) {
                this.globalListeners.remove(listener);
            }
        }
    }

    @Override
    public boolean isSubscribed() {
        return this.state == ChannelState.SUBSCRIBED;
    }

    @Override
    public PusherEvent prepareEvent(String event, String message) {
        return (PusherEvent)this.GSON.fromJson(message, PusherEvent.class);
    }

    @Override
    public void onMessage(String event, String message) {
        if (event.equals(SUBSCRIPTION_SUCCESS_EVENT)) {
            this.updateState(ChannelState.SUBSCRIBED);
        } else {
            PusherEvent pusherEvent;
            Set<SubscriptionEventListener> listeners = this.getInterestedListeners(event);
            if (listeners != null && (pusherEvent = this.prepareEvent(event, message)) != null) {
                for (final SubscriptionEventListener listener : listeners) {
                    this.factory.queueOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onEvent(pusherEvent);
                        }
                    });
                }
            }
        }
    }

    @Override
    public String toSubscribeMessage() {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        jsonObject.put("event", "pusher:subscribe");
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("channel", this.name);
        jsonObject.put("data", dataMap);
        return this.GSON.toJson(jsonObject);
    }

    @Override
    public String toUnsubscribeMessage() {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        jsonObject.put("event", "pusher:unsubscribe");
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("channel", this.name);
        jsonObject.put("data", dataMap);
        return this.GSON.toJson(jsonObject);
    }

    @Override
    public void updateState(ChannelState state) {
        this.state = state;
        if (state == ChannelState.SUBSCRIBED && this.eventListener != null) {
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    ChannelImpl.this.eventListener.onSubscriptionSucceeded(ChannelImpl.this.getName());
                }
            });
        }
    }

    @Override
    public void setEventListener(ChannelEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public ChannelEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public int compareTo(InternalChannel other) {
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return String.format("[Public Channel: name=%s]", this.name);
    }

    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^private-.*", "^presence-.*"};
    }

    private void validateArguments(String eventName, SubscriptionEventListener listener) {
        if (eventName == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.name + " with a null event name");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.name + " with a null listener");
        }
        if (eventName.startsWith(INTERNAL_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot bind or unbind channel " + this.name + " with an internal event name such as " + eventName);
        }
        if (this.state == ChannelState.UNSUBSCRIBED) {
            throw new IllegalStateException("Cannot bind or unbind to events on a channel that has been unsubscribed. Call Pusher.subscribe() to resubscribe to this channel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<SubscriptionEventListener> getInterestedListeners(String event) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<SubscriptionEventListener> listeners = new HashSet<SubscriptionEventListener>();
            Set<SubscriptionEventListener> sharedListeners = this.eventNameToListenerMap.get(event);
            if (sharedListeners != null) {
                listeners.addAll(sharedListeners);
            }
            if (!this.globalListeners.isEmpty()) {
                listeners.addAll(this.globalListeners);
            }
            if (listeners.isEmpty()) {
                return null;
            }
            return listeners;
        }
    }
}

