/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.user.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.pusher.client.AuthenticationFailureException;
import com.pusher.client.UserAuthenticator;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.PusherEventDeserializer;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.ChannelManager;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.connection.impl.message.AuthenticationResponse;
import com.pusher.client.connection.impl.message.SigninMessage;
import com.pusher.client.user.User;
import com.pusher.client.user.impl.ServerToUserChannel;
import com.pusher.client.util.Factory;
import java.util.Map;
import java.util.logging.Logger;

public class InternalUser
implements User {
    private static final Gson GSON;
    private static final Logger log;
    private final InternalConnection connection;
    private final UserAuthenticator userAuthenticator;
    private final ChannelManager channelManager;
    private boolean signinRequested;
    private ServerToUserChannel serverToUserChannel;
    private String userId;

    public InternalUser(InternalConnection connection, UserAuthenticator userAuthenticator, Factory factory) {
        this.connection = connection;
        this.userAuthenticator = userAuthenticator;
        this.channelManager = factory.getChannelManager();
        this.signinRequested = false;
        this.serverToUserChannel = new ServerToUserChannel(this, factory);
        connection.bind(ConnectionState.ALL, new ConnectionStateChangeHandler(this));
    }

    public void signin() throws AuthenticationFailureException {
        if (this.signinRequested || this.userId != null) {
            return;
        }
        this.signinRequested = true;
        this.attemptSignin();
    }

    public void handleEvent(String event, String wholeMessage) {
        if (event.equals("pusher:signin_success")) {
            this.onSigninSuccess((PusherEvent)GSON.fromJson(wholeMessage, PusherEvent.class));
        }
    }

    private void attemptSignin() throws AuthenticationFailureException {
        if (!this.signinRequested || this.userId != null) {
            return;
        }
        if (this.connection.getState() != ConnectionState.CONNECTED) {
            return;
        }
        AuthenticationResponse authenticationResponse = this.getAuthenticationResponse();
        this.connection.sendMessage(InternalUser.authenticationResponseToSigninMessage(authenticationResponse));
    }

    private static String authenticationResponseToSigninMessage(AuthenticationResponse authenticationResponse) {
        return GSON.toJson((Object)new SigninMessage(authenticationResponse.getAuth(), authenticationResponse.getUserData()));
    }

    private AuthenticationResponse getAuthenticationResponse() throws AuthenticationFailureException {
        String response = this.userAuthenticator.authenticate(this.connection.getSocketId());
        try {
            AuthenticationResponse authenticationResponse = (AuthenticationResponse)GSON.fromJson(response, AuthenticationResponse.class);
            if (authenticationResponse.getAuth() == null || authenticationResponse.getUserData() == null) {
                throw new AuthenticationFailureException("Didn't receive all the fields expected from the UserAuthenticator. Expected auth and user_data");
            }
            return authenticationResponse;
        }
        catch (JsonSyntaxException e) {
            throw new AuthenticationFailureException("Unable to parse response from AuthenticationResponse");
        }
    }

    private void onSigninSuccess(PusherEvent event) {
        try {
            String userData = (String)((Map)GSON.fromJson(event.getData(), Map.class)).get("user_data");
            this.userId = (String)((Map)GSON.fromJson(userData, Map.class)).get("id");
        }
        catch (Exception e) {
            log.severe("Failed parsing user data after signin");
            return;
        }
        if (this.userId == null) {
            log.severe("User data doesn't contain an id");
            return;
        }
        this.channelManager.subscribeTo(this.serverToUserChannel, null, new String[0]);
    }

    private void disconnect() {
        if (this.serverToUserChannel.isSubscribed()) {
            this.channelManager.unsubscribeFrom(this.serverToUserChannel.getName());
        }
        this.userId = null;
    }

    @Override
    public String userId() {
        return this.userId;
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        this.serverToUserChannel.bind(eventName, listener);
    }

    @Override
    public void bindGlobal(SubscriptionEventListener listener) {
        this.serverToUserChannel.bindGlobal(listener);
    }

    @Override
    public void unbind(String eventName, SubscriptionEventListener listener) {
        this.serverToUserChannel.unbind(eventName, listener);
    }

    @Override
    public void unbindGlobal(SubscriptionEventListener listener) {
        this.serverToUserChannel.unbindGlobal(listener);
    }

    static {
        log = Logger.getLogger(User.class.getName());
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(PusherEvent.class, (Object)new PusherEventDeserializer());
        GSON = gsonBuilder.create();
    }

    private static class ConnectionStateChangeHandler
    implements ConnectionEventListener {
        private InternalUser user;

        public ConnectionStateChangeHandler(InternalUser user) {
            this.user = user;
        }

        @Override
        public void onConnectionStateChange(ConnectionStateChange change) {
            switch (change.getCurrentState()) {
                case CONNECTED: {
                    this.user.attemptSignin();
                    break;
                }
                case CONNECTING: 
                case DISCONNECTED: {
                    this.user.disconnect();
                    break;
                }
            }
        }

        @Override
        public void onError(String message, String code, Exception e) {
            log.warning(message);
        }
    }
}

