/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.util.ConnectionFactory;
import com.pusher.client.util.UrlEncodedConnectionFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

abstract class BaseHttpAuthClient {
    private final URL endPoint;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    protected ConnectionFactory mConnectionFactory = null;

    public BaseHttpAuthClient(String endPoint) {
        try {
            this.endPoint = new URL(endPoint);
            this.mConnectionFactory = new UrlEncodedConnectionFactory();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse channel authorization end point into a valid URL", e);
        }
    }

    public BaseHttpAuthClient(String endPoint, ConnectionFactory connectionFactory) {
        try {
            this.endPoint = new URL(endPoint);
            this.mConnectionFactory = connectionFactory;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse channel authorization end point into a valid URL", e);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers;
    }

    public Boolean isSSL() {
        return this.endPoint.getProtocol().equals("https");
    }

    protected String performAuthRequest() {
        try {
            String line;
            String body = this.mConnectionFactory.getBody();
            HashMap<String, String> defaultHeaders = new HashMap<String, String>();
            defaultHeaders.put("Content-Type", this.mConnectionFactory.getContentType());
            defaultHeaders.put("charset", this.mConnectionFactory.getCharset());
            HttpURLConnection connection = this.isSSL() != false ? (HttpsURLConnection)this.endPoint.openConnection() : (HttpURLConnection)this.endPoint.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            defaultHeaders.putAll(this.mHeaders);
            defaultHeaders.put("Content-Length", "" + body.getBytes().length);
            for (String headerName : defaultHeaders.keySet()) {
                String headerValue = (String)defaultHeaders.get(headerName);
                connection.setRequestProperty(headerName, headerValue);
            }
            connection.setUseCaches(false);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.flush();
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            rd.close();
            int responseHttpStatus = connection.getResponseCode();
            if (responseHttpStatus != 200 && responseHttpStatus != 201) {
                throw this.authFailureException(response.toString());
            }
            return response.toString();
        }
        catch (IOException e) {
            throw this.authFailureException(e);
        }
    }

    protected abstract RuntimeException authFailureException(String var1);

    protected abstract RuntimeException authFailureException(IOException var1);
}

