/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.util.ConnectionFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class UrlEncodedConnectionFactory
extends ConnectionFactory {
    private Map<String, String> mQueryStringParameters = new HashMap<String, String>();

    public UrlEncodedConnectionFactory() {
    }

    public UrlEncodedConnectionFactory(Map<String, String> queryStringParameters) {
        this.mQueryStringParameters = queryStringParameters;
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public String getBody() {
        StringBuilder urlParameters = new StringBuilder();
        try {
            urlParameters.append("socket_id=").append(URLEncoder.encode(this.getSocketId(), this.getCharset()));
            if (this.getChannelName() != null) {
                urlParameters.append("&channel_name=").append(URLEncoder.encode(this.getChannelName(), this.getCharset()));
            }
            for (String parameterName : this.mQueryStringParameters.keySet()) {
                urlParameters.append("&").append(parameterName).append("=");
                urlParameters.append(URLEncoder.encode(this.mQueryStringParameters.get(parameterName), this.getCharset()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return urlParameters.toString();
    }
}

