/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.data.converter;

import com.rapidclipse.framework.security.util.PasswordHasher;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.util.Objects;
import java.util.function.Supplier;

public interface HashConverter
extends Converter<String, String> {
    public static HashConverter Md5() {
        return new Default(PasswordHasher::Md5, 32);
    }

    public static HashConverter Sha1() {
        return new Default(PasswordHasher::Sha1, 40);
    }

    public static HashConverter Sha2() {
        return new Default(PasswordHasher::Sha2, 64);
    }

    public static HashConverter Pbkdf2withHmacSha1() {
        return new Default(PasswordHasher::Pbkdf2withHmacSha1, 32);
    }

    public static class Default
    implements HashConverter {
        private final Supplier<PasswordHasher> passwordHasherSupplier;
        private final int hashLength;

        protected Default(Supplier<PasswordHasher> passwordHasherSupplier, int hashLength) {
            this.passwordHasherSupplier = Objects.requireNonNull(passwordHasherSupplier);
            this.hashLength = hashLength;
        }

        public Result<String> convertToModel(String value, ValueContext context) {
            if (value == null || value.length() == 0) {
                return Result.ok(null);
            }
            byte[] bytes = value.getBytes();
            if (bytes.length == this.hashLength) {
                return Result.ok((Object)value);
            }
            return Result.ok((Object)Hex.encodeToString(this.passwordHasherSupplier.get().hashPassword(bytes)));
        }

        public String convertToPresentation(String value, ValueContext context) {
            return value;
        }

        public static class Hex {
            private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

            public static String encodeToString(byte[] bytes) {
                return new String(Hex.encode(bytes));
            }

            public static char[] encode(byte[] data) {
                int l = data.length;
                char[] out = new char[l << 1];
                int j = 0;
                for (int i = 0; i < l; ++i) {
                    out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
                    out[j++] = DIGITS[0xF & data[i]];
                }
                return out;
            }
        }
    }
}

