/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.data.converter;

import com.rapidclipse.framework.security.util.PasswordHasher;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;

public interface StringToHashConverter
extends Converter<String, byte[]> {
    public static StringToHashConverter New(Supplier<PasswordHasher> passwordHasherSupplier) {
        return new Default(passwordHasherSupplier);
    }

    public static class Default
    implements StringToHashConverter {
        private final Supplier<PasswordHasher> passwordHasherSupplier;

        protected Default(Supplier<PasswordHasher> passwordHasherSupplier) {
            this.passwordHasherSupplier = Objects.requireNonNull(passwordHasherSupplier);
        }

        public Result<byte[]> convertToModel(String value, ValueContext context) {
            if (value != null) {
                return Result.ok((Object)this.passwordHasherSupplier.get().hashPassword(value.getBytes(StandardCharsets.UTF_8)));
            }
            return Result.ok(null);
        }

        public String convertToPresentation(byte[] value, ValueContext context) {
            if (value != null) {
                return new String(value, StandardCharsets.UTF_8);
            }
            return null;
        }
    }
}

