/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.navigation;

import com.rapidclipse.framework.security.authorization.Resource;
import com.rapidclipse.framework.security.authorization.Subject;
import com.rapidclipse.framework.server.security.authentication.AccessibleView;
import com.rapidclipse.framework.server.security.authentication.Authentication;
import com.rapidclipse.framework.server.security.authorization.Authorization;
import com.rapidclipse.framework.server.util.ReflectionUtils;
import com.vaadin.flow.router.HasErrorParameter;
import java.io.Serializable;
import java.util.Collection;

public interface AuthNavigationController
extends Serializable {
    public boolean isAuthenticated(Class<?> var1);

    public boolean isAuthorized(Class<?> var1);

    public static AuthNavigationController Default() {
        return new Default();
    }

    public static class Default
    implements AuthNavigationController {
        protected Default() {
        }

        @Override
        public boolean isAuthenticated(Class<?> target) {
            return ReflectionUtils.isAnnotationPresent(target, AccessibleView.class) || HasErrorParameter.class.isAssignableFrom(target) || Authentication.getUser() != null;
        }

        @Override
        public boolean isAuthorized(Class<?> target) {
            Collection<Resource> resources = Authorization.getRouteResourcesProvider().getResourcesFor(target);
            if (resources == null || resources.isEmpty()) {
                return true;
            }
            Subject user = Authentication.getUser();
            if (user == null) {
                return false;
            }
            for (Resource resource : resources) {
                if (user.hasPermission(resource)) continue;
                return false;
            }
            return true;
        }
    }
}

