/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.navigation;

import com.rapidclipse.framework.server.navigation.AuthNavigationController;
import com.rapidclipse.framework.server.navigation.NavigationItem;
import com.rapidclipse.framework.server.navigation.NavigationItemFilter;
import java.util.Objects;

public class AuthNavigationItemFilter
implements NavigationItemFilter {
    private AuthNavigationController controller = AuthNavigationController.Default();
    private boolean hideUnauthenticated = true;
    private boolean hideUnauthorized = true;

    public AuthNavigationController getController() {
        return this.controller;
    }

    public AuthNavigationItemFilter setController(AuthNavigationController controller) {
        this.controller = Objects.requireNonNull(controller);
        return this;
    }

    public boolean isHideUnauthenticated() {
        return this.hideUnauthenticated;
    }

    public AuthNavigationItemFilter setHideUnauthenticated(boolean hideUnauthenticated) {
        this.hideUnauthenticated = hideUnauthenticated;
        return this;
    }

    public boolean isHideUnauthorized() {
        return this.hideUnauthorized;
    }

    public AuthNavigationItemFilter setHideUnauthorized(boolean hideUnauthorized) {
        this.hideUnauthorized = hideUnauthorized;
        return this;
    }

    public boolean test(NavigationItem item) {
        Class target = item.routeData().getNavigationTarget();
        if (this.hideUnauthenticated && !this.controller.isAuthenticated(target)) {
            return false;
        }
        return !this.hideUnauthorized || this.controller.isAuthorized(target);
    }
}

