/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.security.authentication;

import com.rapidclipse.framework.security.authentication.AuthenticationFailedException;
import com.rapidclipse.framework.security.authentication.AuthenticatorProvider;
import com.rapidclipse.framework.security.authentication.CredentialsUsernamePassword;
import com.rapidclipse.framework.security.authorization.AuthorizationConfigurationProvider;
import com.rapidclipse.framework.security.authorization.AuthorizationManager;
import com.rapidclipse.framework.security.authorization.Subject;
import com.rapidclipse.framework.server.navigation.Navigation;
import com.rapidclipse.framework.server.security.authentication.LoginView;
import com.rapidclipse.framework.server.security.authentication.RedirectView;
import com.rapidclipse.framework.server.security.authentication.UnauthenticatedNavigationRequestHandler;
import com.rapidclipse.framework.server.security.authorization.Authorization;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.server.VaadinSession;
import java.util.Objects;

public final class Authentication {
    private static final String AUTHENTICATION_RESULT = Authentication.class.getName() + ".AUTHENTICATION_RESULT";
    private static final String REDIRECT_VIEW = Authentication.class.getName() + ".REDIRECT_VIEW";
    private static UnauthenticatedNavigationRequestHandler unauthenticatedNavigationRequestHandler = UnauthenticatedNavigationRequestHandler.Default();

    public static <C extends CredentialsUsernamePassword> boolean tryLogin(C credentials, AuthenticatorProvider<C, ?> authenticatorProvider) {
        return Authentication.tryLogin(credentials, authenticatorProvider, null);
    }

    public static <C extends CredentialsUsernamePassword> boolean tryLogin(C credentials, AuthenticatorProvider<C, ?> authenticatorProvider, AuthorizationConfigurationProvider authorizationConfigurationProvider) {
        try {
            Subject subject;
            Object authenticationResult = authenticatorProvider.provideAuthenticator().authenticate(credentials);
            if (authorizationConfigurationProvider != null) {
                AuthorizationManager authorizationManager = AuthorizationManager.New((AuthorizationConfigurationProvider)authorizationConfigurationProvider);
                Authorization.setAuthorizationManager(authorizationManager);
                subject = authorizationManager.subject(credentials.username());
            } else {
                subject = Subject.New((String)credentials.username());
            }
            Authentication.login(subject, authenticationResult);
            return true;
        }
        catch (AuthenticationFailedException e) {
            return false;
        }
    }

    public static void login(Subject user, Object authenticationResult) {
        Authentication.setUser(user, authenticationResult);
        Authentication.navigateToRedirectView();
    }

    public static void logout() {
        Authentication.setUser(null, null);
        Authentication.navigateToLoginView();
    }

    public static void setUser(Subject user, Object authenticationResult) {
        VaadinSession session = VaadinSession.getCurrent();
        session.setAttribute(Subject.class, (Object)user);
        session.setAttribute(AUTHENTICATION_RESULT, authenticationResult);
    }

    public static Subject getUser() {
        return (Subject)VaadinSession.getCurrent().getAttribute(Subject.class);
    }

    public static Object getAuthenticationResult() {
        return VaadinSession.getCurrent().getAttribute(AUTHENTICATION_RESULT);
    }

    public static boolean isUserLoggedIn() {
        return Authentication.getUser() != null;
    }

    public static void navigateToLoginView() {
        Navigation.navigateTo(LoginView.class);
    }

    public static void rerouteToLoginView(BeforeEvent event) {
        Authentication.setRedirectView(event.getNavigationTarget());
        Navigation.rerouteTo((BeforeEvent)event, LoginView.class);
    }

    public static void navigateToRedirectView() {
        Navigation.navigateTo(Authentication.getAndClearRedirectView());
    }

    public static void rerouteToRedirectView(BeforeEvent event) {
        Navigation.rerouteTo((BeforeEvent)event, Authentication.getAndClearRedirectView());
    }

    public static void setRedirectView(Class<?> redirectView) {
        VaadinSession.getCurrent().setAttribute(REDIRECT_VIEW, redirectView);
    }

    private static Class<?> getAndClearRedirectView() {
        VaadinSession session = VaadinSession.getCurrent();
        Object attribute = session.getAttribute(REDIRECT_VIEW);
        session.setAttribute(REDIRECT_VIEW, null);
        return attribute instanceof Class ? (Class)attribute : RedirectView.class;
    }

    public static void setUnauthenticatedNavigationRequestHandler(UnauthenticatedNavigationRequestHandler unauthenticatedNavigationRequestHandler) {
        Authentication.unauthenticatedNavigationRequestHandler = Objects.requireNonNull(unauthenticatedNavigationRequestHandler);
    }

    public static UnauthenticatedNavigationRequestHandler getUnauthenticatedNavigationRequestHandler() {
        return unauthenticatedNavigationRequestHandler;
    }

    private Authentication() {
        throw new Error();
    }
}

