/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.security.authentication;

import com.rapidclipse.framework.security.authentication.AuthenticationMemoizer;
import com.rapidclipse.framework.security.authentication.CredentialsUsernamePassword;
import com.rapidclipse.framework.server.Rap;
import com.rapidclipse.framework.server.net.Cookies;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CookieBasedAuthenticationMemoizer
implements AuthenticationMemoizer<CredentialsUsernamePassword> {
    protected static final String COOKIE_NAME = "XUID";
    protected final Map<String, CredentialsUsernamePassword> rememberedCredentials = new HashMap<String, CredentialsUsernamePassword>();
    protected Duration lifespan = Duration.ofDays(14L);

    public static CookieBasedAuthenticationMemoizer getCurrent() {
        return (CookieBasedAuthenticationMemoizer)Rap.ensureSessionInstance(CookieBasedAuthenticationMemoizer.class, session -> new CookieBasedAuthenticationMemoizer());
    }

    public Duration getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(Duration lifespan) {
        this.lifespan = lifespan;
    }

    public void remember(CredentialsUsernamePassword credentials) {
        this.remove(credentials);
        String hash = UUID.randomUUID().toString();
        Cookies.getCurrent().setCookie(COOKIE_NAME, hash, this.lifespan);
        this.rememberedCredentials.put(hash, credentials);
    }

    public void forget(CredentialsUsernamePassword credentials) {
        this.remove(credentials);
        Cookies.getCurrent().deleteCookie(COOKIE_NAME);
    }

    protected void remove(CredentialsUsernamePassword credentials) {
        this.rememberedCredentials.values().remove(credentials);
    }

    public CredentialsUsernamePassword lookup() {
        String hash = Cookies.getCurrent().getCookie(COOKIE_NAME);
        return this.rememberedCredentials.get(hash);
    }
}

